/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.wicket.csp.CSPRenderable;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;

public class RelativeURICSPValue
implements CSPRenderable {
    private final String relativeUri;

    public RelativeURICSPValue(String relativeUri) {
        Args.notEmpty(relativeUri, "relativeUri");
        this.relativeUri = relativeUri;
    }

    @Override
    public String render(ContentSecurityPolicySettings settings, RequestCycle cycle) {
        return cycle.getUrlRenderer().renderContextRelativeUrl(this.relativeUri);
    }

    @Override
    public void checkValidityForSrc() {
        try {
            new URI("https://example.com/" + this.relativeUri);
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("Illegal relative URI", urise);
        }
    }

    public String toString() {
        return this.relativeUri;
    }
}

