/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.formatter.preferences;

import java.net.URL;
import org.apache.uima.ruta.ide.formatter.preferences.Messages;
import org.eclipse.dltk.ui.formatter.FormatterModifyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class RutaFormatterIndentationTabPage
extends FormatterModifyTabPage {
    private Combo tabPolicy;
    private Text indentSize;
    private Text tabSize;
    private final String[] tabPolicyItems = new String[]{"space", "tab", "mixed"};
    private TabPolicyListener tabPolicyListener;

    public RutaFormatterIndentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group tabPolicyGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.RutaFormatterIndentationTabPage_generalSettings, (int)2, (int)1, (int)768);
        this.tabPolicy = manager.createCombo((Composite)tabPolicyGroup, "formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabPolicyItems);
        this.tabPolicyListener = new TabPolicyListener(manager);
        this.tabPolicy.addSelectionListener((SelectionListener)this.tabPolicyListener);
        manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this.tabPolicyListener);
        this.indentSize = manager.createNumber((Composite)tabPolicyGroup, "formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size);
        this.tabSize = manager.createNumber((Composite)tabPolicyGroup, "formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size);
        this.tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = RutaFormatterIndentationTabPage.this.tabPolicy.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(RutaFormatterIndentationTabPage.this.tabPolicyItems[index]))) {
                    RutaFormatterIndentationTabPage.this.indentSize.setText(RutaFormatterIndentationTabPage.this.tabSize.getText());
                }
            }
        });
        Group indentGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.RutaFormatterIndentationTabPage_indentWithinBlocks, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentGroup, "indent.block", Messages.RutaFormatterIndentationTabPage_statementsWithinBlockBody);
        Group indentBlocks = SWTFactory.createGroup((Composite)parent, (String)Messages.RutaFormatterIndentationTabPage_indentWithinCreateActions, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentBlocks, "indent.structure", Messages.RutaFormatterIndentationTabPage_assignmentsWithinCreateAction);
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("indentation-preview.ruta");
    }

    private class TabPolicyListener
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private final IFormatterControlManager manager;

        public TabPolicyListener(IFormatterControlManager manager) {
            this.manager = manager;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = RutaFormatterIndentationTabPage.this.tabPolicy.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(RutaFormatterIndentationTabPage.this.tabPolicyItems[index]);
                this.manager.enableControl((Control)RutaFormatterIndentationTabPage.this.indentSize, !tabMode);
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"formatter.tabulation.char"));
            this.manager.enableControl((Control)RutaFormatterIndentationTabPage.this.indentSize, !tabMode);
        }
    }
}

