/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.util.Preconditions;

public class ConstantBackOff
implements BackOff {
    private final long delayInMillis;
    private final Jitter jitter;

    public ConstantBackOff(long delayInMillis, Jitter jitter) {
        this.delayInMillis = Preconditions.check(delayInMillis, delayInMillis >= 0L, "Delay must be >= 0");
        this.jitter = Preconditions.checkNotNull(jitter, "Jitter must be set");
    }

    @Override
    public long getInMillis(Throwable cause) {
        return Math.max(0L, this.delayInMillis + this.jitter.generate());
    }
}

