/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;

public class JULLogFactory
implements LogFactory,
Configurable {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Log getLog(String channel) {
        ClassLoader oldLoader;
        Thread thread;
        if (this.classLoader != null) {
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
        } else {
            thread = null;
            oldLoader = null;
        }
        try {
            JULLog jULLog = new JULLog(Logger.getLogger(channel));
            return jULLog;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    @Override
    public void setConfiguration(Configuration conf) {
        String string;
        Value value = conf.getValue("Log.JULFactory");
        if (value != null && (string = value.getString()) != null && string.contains("SkipStartClassLoader=true")) {
            this.classLoader = null;
        }
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    private static class JULLog
    implements Log {
        private final Logger logger;

        public JULLog(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public void trace(Object o) {
            this.logger.finest(String.valueOf(o));
        }

        @Override
        public void trace(Object o, Throwable t) {
            this.logger.log(Level.FINEST, String.valueOf(o), t);
        }

        @Override
        public void info(Object o) {
            this.logger.info(String.valueOf(o));
        }

        @Override
        public void info(Object o, Throwable t) {
            this.logger.log(Level.INFO, String.valueOf(o), t);
        }

        @Override
        public void warn(Object o) {
            this.logger.warning(String.valueOf(o));
        }

        @Override
        public void warn(Object o, Throwable t) {
            this.logger.log(Level.WARNING, String.valueOf(o), t);
        }

        @Override
        public void error(Object o) {
            this.logger.severe(String.valueOf(o));
        }

        @Override
        public void error(Object o, Throwable t) {
            this.logger.log(Level.SEVERE, String.valueOf(o), t);
        }

        @Override
        public void fatal(Object o) {
            this.error(o);
        }

        @Override
        public void fatal(Object o, Throwable t) {
            this.error(o, t);
        }
    }
}

