/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import jakarta.validation.ValidationException;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.bval.jsr.GraphContext;
import org.apache.bval.jsr.descriptor.BeanD;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public abstract class PropertyD<E extends AnnotatedElement>
extends CascadableContainerD<BeanD<?>, E>
implements PropertyDescriptor {
    protected PropertyD(MetadataReader.ForContainer<E> reader, BeanD<?> parent) {
        super(reader, parent);
    }

    public final Stream<GraphContext> read(GraphContext context) {
        if (context.getValue() == null) {
            return Stream.empty();
        }
        try {
            Object value = this.getValue(context.getValue());
            PathImpl p = context.getPath();
            p.addProperty(this.getPropertyName());
            return Stream.of(context.child(p, value));
        }
        catch (Exception e) {
            throw e instanceof ValidationException ? (ValidationException)((Object)e) : new ValidationException((Throwable)e);
        }
    }

    public abstract Object getValue(Object var1) throws Exception;

    static class ForMethod
    extends PropertyD<Method> {
        ForMethod(MetadataReader.ForContainer<Method> reader, BeanD<?> parent) {
            super(reader, parent);
        }

        public String getPropertyName() {
            return Methods.propertyName((Method)this.getTarget());
        }

        @Override
        public Object getValue(Object parent) throws Exception {
            Reflection.makeAccessible((AccessibleObject)this.getTarget());
            try {
                return ((Method)this.getTarget()).invoke(parent, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    static class ForField
    extends PropertyD<Field> {
        ForField(MetadataReader.ForContainer<Field> reader, BeanD<?> parent) {
            super(reader, parent);
        }

        public String getPropertyName() {
            return ((Field)this.getTarget()).getName();
        }

        @Override
        public Object getValue(Object parent) throws Exception {
            Reflection.makeAccessible((AccessibleObject)this.getTarget());
            try {
                return ((Field)this.getTarget()).get(parent);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

