/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.filters.FilterBase;
import org.apache.catalina.util.NetMaskSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class RemoteCIDRFilter
extends FilterBase {
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";
    private final Log log = LogFactory.getLog(RemoteCIDRFilter.class);
    private final NetMaskSet allow = new NetMaskSet();
    private final NetMaskSet deny = new NetMaskSet();

    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    public void setAllow(String input) {
        List<String> messages = this.allow.addAll(input);
        if (messages.isEmpty()) {
            return;
        }
        for (String message : messages) {
            this.log.error((Object)message);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", new Object[]{"allow"}));
    }

    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    public void setDeny(String input) {
        List<String> messages = this.deny.addAll(input);
        if (messages.isEmpty()) {
            return;
        }
        for (String message : messages) {
            this.log.error((Object)message);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", new Object[]{"deny"}));
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAllowed(request.getRemoteAddr())) {
            chain.doFilter(request, response);
            return;
        }
        if (!(response instanceof HttpServletResponse)) {
            this.sendErrorWhenNotHttp(response);
            return;
        }
        ((HttpServletResponse)response).sendError(403);
    }

    @Override
    public Log getLogger() {
        return this.log;
    }

    private boolean isAllowed(String property) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(property);
        }
        catch (UnknownHostException e) {
            this.log.error((Object)sm.getString("remoteCidrFilter.noRemoteIp"), (Throwable)e);
            return false;
        }
        if (this.deny.contains(addr)) {
            return false;
        }
        if (this.allow.contains(addr)) {
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    private void sendErrorWhenNotHttp(ServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType(PLAIN_TEXT_MIME_TYPE);
        writer.write(sm.getString("http.403"));
        writer.flush();
    }
}

