/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConstraintExceptionFormula
extends ConstraintFormula {
    FunctionalExpression left;

    public ConstraintExceptionFormula(FunctionalExpression left, TypeBinding type) {
        this.left = left;
        this.right = type;
        this.relation = 7;
    }

    @Override
    public Object reduce(InferenceContext18 inferenceContext) {
        if ((this.right.tagBits & 0x80L) != 0L) {
            inferenceContext.missingType = this.right;
            return TRUE;
        }
        Scope scope = inferenceContext.scope;
        if (!this.right.isFunctionalInterface(scope)) {
            return FALSE;
        }
        MethodBinding sam = this.right.getSingleAbstractMethod(scope, true);
        if (sam == null) {
            return FALSE;
        }
        if (this.left instanceof LambdaExpression) {
            if (((LambdaExpression)this.left).argumentsTypeElided()) {
                nParam = sam.parameters.length;
                i = 0;
                while (i < nParam) {
                    if (!sam.parameters[i].isProperType(true)) {
                        return FALSE;
                    }
                    ++i;
                }
            }
            if (sam.returnType != TypeBinding.VOID && !sam.returnType.isProperType(true)) {
                return FALSE;
            }
        } else if (!((ReferenceExpression)this.left).isExactMethodReference()) {
            nParam = sam.parameters.length;
            i = 0;
            while (i < nParam) {
                if (!sam.parameters[i].isProperType(true)) {
                    return FALSE;
                }
                ++i;
            }
            if (sam.returnType != TypeBinding.VOID && !sam.returnType.isProperType(true)) {
                return FALSE;
            }
        }
        ReferenceBinding[] thrown = sam.thrownExceptions;
        InferenceVariable[] e = new InferenceVariable[thrown.length];
        int n = 0;
        ReferenceBinding[] referenceBindingArray = thrown;
        int n2 = thrown.length;
        int n3 = 0;
        while (n3 < n2) {
            ReferenceBinding ex = referenceBindingArray[n3];
            if (!((TypeBinding)ex).isProperType(true)) {
                e[n++] = (InferenceVariable)ex;
            }
            ++n3;
        }
        if (n == 0) {
            return TRUE;
        }
        TypeBinding[] ePrime = null;
        if (this.left instanceof LambdaExpression) {
            LambdaExpression lambda = ((LambdaExpression)this.left).resolveExpressionExpecting(this.right, inferenceContext.scope, inferenceContext);
            if (lambda == null) {
                return TRUE;
            }
            ePrime = (TypeBinding[])lambda.getThrownExceptions().toArray(TypeBinding[]::new);
        } else {
            MethodBinding method;
            ReferenceExpression referenceExpression = ((ReferenceExpression)this.left).resolveExpressionExpecting(this.right, scope, inferenceContext);
            MethodBinding methodBinding = method = referenceExpression != null ? referenceExpression.binding : null;
            if (method != null) {
                ePrime = method.thrownExceptions;
            }
        }
        if (ePrime == null) {
            return TRUE;
        }
        int m = ePrime.length;
        ArrayList<ConstraintTypeFormula> result = new ArrayList<ConstraintTypeFormula>();
        int i = 0;
        while (i < m) {
            block27: {
                if (!ePrime[i].isUncheckedException(false)) {
                    ReferenceBinding[] referenceBindingArray2 = thrown;
                    int n4 = thrown.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ReferenceBinding ex = referenceBindingArray2[n5];
                        if (!((TypeBinding)ex).isProperType(true) || !ePrime[i].isCompatibleWith(ex)) {
                            ++n5;
                            continue;
                        }
                        break block27;
                    }
                    int j = 0;
                    while (j < n) {
                        result.add(ConstraintTypeFormula.create(ePrime[i], e[j], 2));
                        ++j;
                    }
                }
            }
            ++i;
        }
        int j = 0;
        while (j < n) {
            inferenceContext.currentBounds.inThrows.add(e[j].prototype());
            ++j;
        }
        return result.toArray(new ConstraintFormula[result.size()]);
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 context) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                LambdaExpression lambda = (LambdaExpression)this.left;
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                if (lambda.argumentsTypeElided()) {
                    int len = sam.parameters.length;
                    int i = 0;
                    while (i < len) {
                        sam.parameters[i].collectInferenceVariables(variables);
                        ++i;
                    }
                }
                if (sam.returnType != TypeBinding.VOID) {
                    sam.returnType.collectInferenceVariables(variables);
                }
                return variables;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                int len = sam.parameters.length;
                int i = 0;
                while (i < len) {
                    sam.parameters[i].collectInferenceVariables(variables);
                    ++i;
                }
                sam.returnType.collectInferenceVariables(variables);
                return variables;
            }
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('\u27e8');
        this.left.printExpression(4, buf);
        buf.append(" \u2286throws ");
        this.appendTypeName(buf, this.right);
        buf.append('\u27e9');
        return buf.toString();
    }
}

