/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.tomcat.util.buf.B2CConverter;

public class CharsetHolder {
    public static final CharsetHolder EMPTY = new CharsetHolder(null, null);
    private final String name;
    private final Charset charset;

    public static CharsetHolder getInstance(String name) {
        Charset charset;
        if (name == null) {
            return EMPTY;
        }
        try {
            charset = B2CConverter.getCharset(name);
        }
        catch (UnsupportedEncodingException e) {
            charset = null;
        }
        return new CharsetHolder(name, charset);
    }

    public static CharsetHolder getInstance(Charset encoding) {
        if (encoding == null) {
            return EMPTY;
        }
        return new CharsetHolder(encoding.name(), encoding);
    }

    private CharsetHolder(String name, Charset charset) {
        this.name = name;
        this.charset = charset;
    }

    public String getName() {
        return this.name;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Charset getValidatedCharset() throws UnsupportedEncodingException {
        this.validate();
        return this.charset;
    }

    public void validate() throws UnsupportedEncodingException {
        if (this.name != null && this.charset == null) {
            throw new UnsupportedEncodingException(this.name);
        }
    }
}

