/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.MultiValuedColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcMapredRecordWriter;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcValue;

public class OrcMapreduceRecordWriter<V extends Writable>
extends RecordWriter<NullWritable, V> {
    private final Writer writer;
    private final VectorizedRowBatch batch;
    private final TypeDescription schema;
    private final boolean isTopStruct;
    private final List<MultiValuedColumnVector> variableLengthColumns = new ArrayList<MultiValuedColumnVector>();
    private final int maxChildLength;

    public OrcMapreduceRecordWriter(Writer writer) {
        this(writer, 1024);
    }

    public OrcMapreduceRecordWriter(Writer writer, int rowBatchSize) {
        this(writer, rowBatchSize, (Integer)OrcConf.ROW_BATCH_CHILD_LIMIT.getDefaultValue());
    }

    public OrcMapreduceRecordWriter(Writer writer, int rowBatchSize, int maxChildLength) {
        this.writer = writer;
        this.schema = writer.getSchema();
        this.batch = this.schema.createRowBatch(rowBatchSize);
        this.isTopStruct = this.schema.getCategory() == TypeDescription.Category.STRUCT;
        OrcMapredRecordWriter.addVariableLengthColumns(this.variableLengthColumns, this.batch);
        this.maxChildLength = maxChildLength;
    }

    public void write(NullWritable nullWritable, V v) throws IOException {
        if (this.batch.size == this.batch.getMaxSize() || OrcMapredRecordWriter.getMaxChildLength(this.variableLengthColumns) >= this.maxChildLength) {
            this.writer.addRowBatch(this.batch);
            this.batch.reset();
        }
        int row = this.batch.size++;
        if (v instanceof OrcKey) {
            v = ((OrcKey)v).key;
        } else if (v instanceof OrcValue) {
            v = ((OrcValue)v).value;
        }
        if (this.isTopStruct) {
            for (int f = 0; f < this.schema.getChildren().size(); ++f) {
                OrcMapredRecordWriter.setColumn((TypeDescription)this.schema.getChildren().get(f), this.batch.cols[f], row, (Writable)((OrcStruct)v).getFieldValue(f));
            }
        } else {
            OrcMapredRecordWriter.setColumn(this.schema, this.batch.cols[0], row, v);
        }
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException {
        if (this.batch.size != 0) {
            this.writer.addRowBatch(this.batch);
        }
        this.writer.close();
    }
}

