/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.V2ExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.VariableReference;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.optimizer.ConstantFolding$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition;
import org.apache.spark.sql.catalyst.plans.logical.DefaultValueExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$DefaultColumnAnalyzer$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$DefaultColumnOptimizer$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumnsUtils;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.DefaultValue;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class ResolveDefaultColumns$
implements QueryErrorsBase,
ResolveDefaultColumnsUtils,
SQLConfHelper,
Logging {
    public static final ResolveDefaultColumns$ MODULE$ = new ResolveDefaultColumns$();
    private static final String CURRENT_DEFAULT_COLUMN_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static String CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    private static String EXISTS_DEFAULT_COLUMN_METADATA_KEY;

    static {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)MODULE$);
        QueryErrorsBase.$init$(MODULE$);
        ResolveDefaultColumnsUtils.$init$((ResolveDefaultColumnsUtils)MODULE$);
        SQLConfHelper.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
        CURRENT_DEFAULT_COLUMN_NAME = "DEFAULT";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CURRENT_DEFAULT_COLUMN_METADATA_KEY() {
        return CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    }

    public String EXISTS_DEFAULT_COLUMN_METADATA_KEY() {
        return EXISTS_DEFAULT_COLUMN_METADATA_KEY;
    }

    public void org$apache$spark$sql$catalyst$util$ResolveDefaultColumnsUtils$_setter_$CURRENT_DEFAULT_COLUMN_METADATA_KEY_$eq(String x$1) {
        CURRENT_DEFAULT_COLUMN_METADATA_KEY = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$ResolveDefaultColumnsUtils$_setter_$EXISTS_DEFAULT_COLUMN_METADATA_KEY_$eq(String x$1) {
        EXISTS_DEFAULT_COLUMN_METADATA_KEY = x$1;
    }

    public String CURRENT_DEFAULT_COLUMN_NAME() {
        return CURRENT_DEFAULT_COLUMN_NAME;
    }

    public StructType constantFoldCurrentDefaultsToExistDefaults(StructType tableSchema, String statementType) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns()) {
            ArraySeq newFields = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()), (Function1 & Serializable)field -> {
                if (field.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
                    Metadata newMetadata;
                    Expression analyzed = MODULE$.analyze((StructField)field, statementType, MODULE$.analyze$default$3());
                    Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), analyzed.sql()).build();
                    String x$2 = field.copy$default$1();
                    DataType x$3 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    return field.copy(x$2, x$3, x$4, x$1);
                }
                return field;
            }, ClassTag$.MODULE$.apply(StructField.class))).toImmutableArraySeq();
            return StructType$.MODULE$.apply((Seq)newFields);
        }
        return tableSchema;
    }

    public void validateCatalogForDefaultValue(Seq<ColumnDefinition> columns, TableCatalog catalog, Identifier ident) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && columns.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateCatalogForDefaultValue$1(x$1))) && !catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORT_COLUMN_DEFAULT_VALUE)) {
            throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "column default value");
        }
    }

    public void validateTableProviderForDefaultValue(StructType schema, Option<String> tableProvider, String statementType, boolean addNewColumnToExistingTable) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateTableProviderForDefaultValue$1(x$2)))) {
            String[] keywords2 = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS()).toLowerCase().split(",")), (Function1 & Serializable)x$3 -> x$3.trim(), ClassTag$.MODULE$.apply(String.class));
            String[] allowedTableProviders = Utils$.MODULE$.isTesting() ? (String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])keywords2), (Function1 & Serializable)x$4 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$4), "*"), ClassTag$.MODULE$.apply(String.class))), (Object)"in-memory", ClassTag$.MODULE$.apply(String.class)) : (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])keywords2), (Function1 & Serializable)x$5 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$5), "*"), ClassTag$.MODULE$.apply(String.class));
            String[] addColumnExistingTableBannedProviders = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])keywords2), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.endsWith("*")))), (Function1 & Serializable)x$7 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$7), "*"), ClassTag$.MODULE$.apply(String.class));
            String givenTableProvider = ((String)tableProvider.getOrElse((Function0 & Serializable)() -> "")).toLowerCase();
            if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])allowedTableProviders), (Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.defaultReferencesNotAllowedInDataSource(statementType, givenTableProvider);
            }
            if (addNewColumnToExistingTable && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(givenTableProvider)) && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])addColumnExistingTableBannedProviders), (Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.addNewDefaultColumnToExistingTableNotAllowed(statementType, givenTableProvider);
            }
            return;
        }
    }

    public boolean isExplicitDefaultColumn(UnresolvedAttribute col) {
        return col.name().equalsIgnoreCase(this.CURRENT_DEFAULT_COLUMN_NAME());
    }

    public boolean containsExplicitDefaultColumn(Expression expr) {
        return expr.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$containsExplicitDefaultColumn$1(x0$1)));
    }

    public Expression resolveColumnDefaultInAssignmentValue(Expression key, Expression value, Function0<Throwable> invalidColumnDefaultException) {
        Expression expression = key;
        if (expression instanceof AttributeReference) {
            UnresolvedAttribute unresolvedAttribute;
            AttributeReference attributeReference = (AttributeReference)expression;
            Expression expression2 = value;
            if (expression2 instanceof UnresolvedAttribute && this.isExplicitDefaultColumn(unresolvedAttribute = (UnresolvedAttribute)expression2)) {
                return this.getDefaultValueExprOrNullLit(attributeReference);
            }
            if (this.containsExplicitDefaultColumn(expression2)) {
                throw (Throwable)invalidColumnDefaultException.apply();
            }
            return expression2;
        }
        return value;
    }

    private Option<Expression> getDefaultValueExprOpt(StructField field) {
        if (field.metadata().contains(this.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
            return new Some((Object)this.analyze(field, "INSERT", this.analyze$default$3()));
        }
        return None$.MODULE$;
    }

    public Expression getDefaultValueExprOrNullLit(StructField field) {
        Option<NamedExpression> defaultValue = this.getDefaultValueExprOrNullLit(field, true);
        if (defaultValue.isEmpty()) {
            throw new AnalysisException("NO_DEFAULT_COLUMN_VALUE_AVAILABLE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId((Seq<String>)new .colon.colon((Object)field.name(), (List)Nil$.MODULE$)))})));
        }
        return (Expression)defaultValue.get();
    }

    public Expression getDefaultValueExprOrNullLit(Attribute attr) {
        StructField field = new StructField(attr.name(), attr.dataType(), attr.nullable(), attr.metadata());
        return this.getDefaultValueExprOrNullLit(field);
    }

    public Option<NamedExpression> getDefaultValueExprOrNullLit(StructField field, boolean useNullAsDefault) {
        return this.getDefaultValueExprOpt(field).orElse((Function0 & Serializable)() -> {
            if (useNullAsDefault && field.nullable()) {
                return new Some((Object)new Literal(null, field.dataType()));
            }
            return None$.MODULE$;
        }).map((Function1 & Serializable)expr -> {
            Expression x$1 = expr;
            String x$2 = field.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        });
    }

    public Option<NamedExpression> getDefaultValueExprOrNullLit(Attribute attr, boolean useNullAsDefault) {
        StructField field = new StructField(attr.name(), attr.dataType(), attr.nullable(), attr.metadata());
        return this.getDefaultValueExprOrNullLit(field, useNullAsDefault);
    }

    public Expression analyze(StructField field, String statementType, String metadataKey) {
        Tuple2 tuple2 = field.metadata().getExpression(metadataKey);
        if (tuple2 != null) {
            String sql2 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression expr = (Expression)some.value();
                return this.analyze(field.name(), field.dataType(), expr, sql2, statementType);
            }
        }
        if (tuple2 != null) {
            String sql3 = (String)tuple2._1();
            return this.analyze(field.name(), field.dataType(), sql3, statementType);
        }
        throw new MatchError((Object)tuple2);
    }

    public Expression analyze(String colName, DataType dataType, String defaultSQL, String statementType) {
        Expression expression;
        LazyRef parser$lzy = new LazyRef();
        try {
            expression = ResolveDefaultColumns$.parser$1(parser$lzy).parseExpression(defaultSQL);
        }
        catch (ParseException ex) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesUnresolvedExprError(statementType, colName, defaultSQL, ex);
        }
        Expression parsed = expression;
        return this.analyze(colName, dataType, parsed, defaultSQL, statementType);
    }

    public Expression analyze(String colName, DataType dataType, DefaultValue defaultValue, String statementType) {
        if (defaultValue.getExpression() != null) {
            Option<Expression> option = V2ExpressionUtils$.MODULE$.toCatalyst(defaultValue.getExpression());
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression defaultExpr = (Expression)some.value();
                String defaultSQL = (String)Option$.MODULE$.apply((Object)defaultValue.getSql()).getOrElse((Function0 & Serializable)() -> defaultExpr.sql());
                return this.analyze(colName, dataType, defaultExpr, defaultSQL, statementType);
            }
            if (None$.MODULE$.equals(option) && defaultValue.getSql() != null) {
                return this.analyze(colName, dataType, defaultValue.getSql(), statementType);
            }
            throw SparkException$.MODULE$.internalError("Can't convert " + defaultValue + " to Catalyst");
        }
        return this.analyze(colName, dataType, defaultValue.getSql(), statementType);
    }

    private Expression analyze(String colName, DataType dataType, Expression defaultExpr, String defaultSQL, String statementType) {
        LogicalPlan logicalPlan;
        if (defaultExpr.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesMayNotContainSubQueryExpressions(statementType, colName, defaultSQL);
        }
        try {
            ResolveDefaultColumns$DefaultColumnAnalyzer$ analyzer = ResolveDefaultColumns$DefaultColumnAnalyzer$.MODULE$;
            Expression x$1 = defaultExpr;
            String x$2 = colName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            LogicalPlan analyzed = analyzer.execute(new Project((Seq<NamedExpression>)new .colon.colon((Object)new Alias(x$1, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$), new OneRowRelation()));
            analyzer.checkAnalysis(analyzed);
            logicalPlan = ConstantFolding$.MODULE$.apply(ResolveDefaultColumns$DefaultColumnOptimizer$.MODULE$.FinishAnalysis().apply(analyzed));
        }
        catch (AnalysisException ex) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesUnresolvedExprError(statementType, colName, defaultSQL, ex);
        }
        LogicalPlan plan2 = logicalPlan;
        Expression analyzed = (Expression)plan2.collectFirst(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    NamedExpression a;
                    SeqOps seqOps;
                    Project project = (Project)A1;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan = project.child();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias) {
                        Alias alias = (Alias)a;
                        if (logicalPlan instanceof OneRowRelation) {
                            return (B1)alias.child();
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Project) {
                    NamedExpression a;
                    SeqOps seqOps;
                    Project project = (Project)logicalPlan;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan2 = project.child();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias && logicalPlan2 instanceof OneRowRelation) {
                        return true;
                    }
                }
                return false;
            }
        }).get();
        if (!analyzed.foldable()) {
            throw QueryCompilationErrors$.MODULE$.defaultValueNotConstantError(statementType, colName, defaultSQL);
        }
        if (!analyzed.resolved()) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesUnresolvedExprError(statementType, colName, defaultSQL, null);
        }
        return this.coerceDefaultValue(analyzed, dataType, statementType, colName, defaultSQL);
    }

    public String analyze$default$3() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY();
    }

    private Expression analyzeExistenceDefaultValue(StructField field) {
        Expression expression;
        String defaultSQL = field.metadata().getString(this.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Literal$.MODULE$.fromSQL(defaultSQL));
        if (try_ instanceof Success) {
            Cast cast;
            Expression expression2;
            Cast cast2;
            Success success = (Success)try_;
            Expression literal = (Expression)success.value();
            Expression expression3 = literal;
            if (expression3 instanceof Cast && (cast2 = (Cast)expression3).child().resolved() && cast2.needsTimeZone()) {
                expression2 = (Expression)((Object)cast2.withTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            } else if (expression3 != null) {
                Expression expression4;
                expression2 = expression4 = expression3;
            } else {
                throw new MatchError((Object)expression3);
            }
            Expression expr = expression2;
            if (expr.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
                throw QueryCompilationErrors$.MODULE$.defaultValuesMayNotContainSubQueryExpressions("", field.name(), defaultSQL);
            }
            Expression expression5 = expr;
            expression = expression5 instanceof Literal ? expr : (expression5 instanceof Cast && (cast = (Cast)expression5).resolved() ? expr : this.fallbackResolveExistenceDefaultValue(field));
        } else if (try_ instanceof Failure) {
            expression = this.fallbackResolveExistenceDefaultValue(field);
        } else {
            throw new MatchError((Object)try_);
        }
        Expression resolvedExpr = expression;
        return this.coerceDefaultValue(resolvedExpr, field.dataType(), "", field.name(), defaultSQL);
    }

    private Expression fallbackResolveExistenceDefaultValue(StructField field) {
        return (Expression)field.getExistenceDefaultValue().map((Function1 & Serializable)defaultSQL -> {
            Expression expr;
            MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered unresolved exists default value: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_DEFAULT_VALUE, defaultSQL)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for column ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_NAME, field.name())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_DATA_TYPE_SOURCE, field.dataType())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"falling back to full analysis."}))).log((Seq)Nil$.MODULE$))));
            Expression expression = expr = MODULE$.analyze(field, "", MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
            if (!(expression instanceof Literal ? true : expression instanceof Cast)) {
                throw SparkException$.MODULE$.internalError("parse existence default as literal err, field name: " + field.name() + ", value: " + defaultSQL);
            }
            Expression literal = expr;
            return literal;
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<Expression> defaultValueFromWiderTypeLiteral(Expression expr, DataType targetType, String colName) {
        Expression expression = expr;
        if (expression.foldable() && !new .colon.colon((Object)targetType, (List)new .colon.colon((Object)expression.dataType(), (List)Nil$.MODULE$)).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$defaultValueFromWiderTypeLiteral$1(x$8)))) {
            Option option;
            Cast casted = new Cast(expression, targetType, (Option<String>)new Some((Object)this.conf().sessionLocalTimeZone()), EvalMode$.MODULE$.TRY());
            try {
                option = Option$.MODULE$.apply(casted.eval(package$.MODULE$.EmptyRow())).map((Function1 & Serializable)x$9 -> new Literal(x$9, targetType));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to cast default value '", "' "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_DEFAULT_VALUE, expression)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for column ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_NAME, colName)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_DATA_TYPE_SOURCE, expression.dataType())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.COLUMN_DATA_TYPE_TARGET, targetType)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"due to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.ERROR, throwable2.getMessage())})))), throwable2);
                    option = None$.MODULE$;
                }
                throw throwable;
            }
            return option;
        }
        return None$.MODULE$;
    }

    public Expression coerceDefaultValue(Expression analyzed, DataType dataType, String statementType, String colName, String defaultSQL) {
        DataType supplanted = CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(dataType);
        Expression expression = analyzed;
        DataType dataType2 = expression.dataType();
        DataType dataType3 = supplanted;
        Expression ret = !(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null) ? expression : (Cast$.MODULE$.canUpCast(expression.dataType(), supplanted) ? new Cast(analyzed, supplanted, (Option<String>)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4()) : (Expression)this.defaultValueFromWiderTypeLiteral(expression, supplanted, colName).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.defaultValuesDataTypeError(statementType, colName, defaultSQL, dataType, expression.dataType());
        }));
        Object object = !this.conf().charVarcharAsString() && CharVarcharUtils$.MODULE$.hasCharVarchar(dataType) ? CharVarcharUtils$.MODULE$.stringLengthCheck(ret, dataType).eval(package$.MODULE$.EmptyRow()) : BoxedUnit.UNIT;
        return ret;
    }

    public String normalizeFieldName(String str) {
        if (SQLConf$.MODULE$.get().caseSensitiveAnalysis()) {
            return str;
        }
        return str.toLowerCase();
    }

    public Object[] getExistenceDefaultValues(StructType schema) {
        return (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> MODULE$.getExistenceDefaultValue((StructField)field), ClassTag$.MODULE$.Any());
    }

    public Object getExistenceDefaultValue(StructField field) {
        if (field.hasExistenceDefaultValue()) {
            Expression expr = this.analyzeExistenceDefaultValue(field);
            return expr.eval(expr.eval$default$1());
        }
        return null;
    }

    public boolean[] getExistenceDefaultsBitmask(StructType schema) {
        return (boolean[])Array$.MODULE$.fill(this.existenceDefaultValues(schema).length, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public void resetExistenceDefaultsBitmask(StructType schema, boolean[] bitmask) {
        Object[] defaultValues = this.existenceDefaultValues(schema);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), defaultValues.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            bitmask$1[i] = defaultValues[i] != null;
        });
    }

    public void applyExistenceDefaultValuesToRow(StructType schema, InternalRow row, boolean[] bitmask) {
        Object[] existingValues = this.existenceDefaultValues(schema);
        if (this.hasExistenceDefaultValues(schema)) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), existingValues.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (bitmask[i]) {
                    row.update(i, existingValues[i]);
                    return;
                }
            });
            return;
        }
    }

    public Seq<Tuple3<String, String, String>> getDescribeMetadata(StructType schema) {
        ArrayBuffer rows;
        block0: {
            rows = new ArrayBuffer();
            if (!ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$getDescribeMetadata$1(x$10)))) break block0;
            rows.append((Object)new Tuple3((Object)"", (Object)"", (Object)""));
            rows.append((Object)new Tuple3((Object)"# Column Default Values", (Object)"", (Object)""));
            schema.foreach((Function1 & Serializable)column -> column.getCurrentDefaultValue().map((Function1 & Serializable)value -> (ArrayBuffer)rows.append((Object)new Tuple3((Object)column.name(), (Object)column.dataType().simpleString(), value))));
        }
        return rows.toSeq();
    }

    public Seq<Tuple3<String, String, String>> getDescribeMetadata(Column[] cols) {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])cols), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$getDescribeMetadata$4(x$11)))), (Function1 & Serializable)col -> {
            Tuple3 tuple3 = new Tuple3((Object)"", (Object)"", (Object)"");
            Tuple3 tuple32 = new Tuple3((Object)"# Column Default Values", (Object)"", (Object)"");
            Tuple3 tuple33 = new Tuple3((Object)col.name(), (Object)col.dataType().simpleString(), (Object)col.defaultValue().getSql());
            return Nil$.MODULE$.$colon$colon((Object)tuple33).$colon$colon((Object)tuple32).$colon$colon((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Tuple3.class))));
    }

    public Object[] existenceDefaultValues(StructType schema) {
        return this.getExistenceDefaultValues(schema);
    }

    public boolean[] existenceDefaultsBitmask(StructType schema) {
        return this.getExistenceDefaultsBitmask(schema);
    }

    public boolean hasExistenceDefaultValues(StructType schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.genericArrayOps((Object)this.existenceDefaultValues(schema)), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$hasExistenceDefaultValues$1(x$12)));
    }

    public void validateDefaultValueExpr(DefaultValueExpression defaultValueExpression, String statement, String colName, Option<DataType> targetTypeOption) {
        if (defaultValueExpression.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesMayNotContainSubQueryExpressions(statement, colName, defaultValueExpression.originalSQL());
        }
        if (defaultValueExpression.resolved()) {
            Option<DataType> option = targetTypeOption;
            if (option instanceof Some) {
                Some some = (Some)option;
                DataType targetType = (DataType)some.value();
                CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(targetType);
                if (!Cast$.MODULE$.canUpCast(defaultValueExpression.child().dataType(), targetType) && this.defaultValueFromWiderTypeLiteral(defaultValueExpression.child(), targetType, colName).isEmpty()) {
                    throw QueryCompilationErrors$.MODULE$.defaultValuesDataTypeError(statement, colName, defaultValueExpression.originalSQL(), targetType, defaultValueExpression.child().dataType());
                }
            }
        } else {
            throw QueryCompilationErrors$.MODULE$.defaultValuesUnresolvedExprError(statement, colName, defaultValueExpression.originalSQL(), null);
        }
        if (defaultValueExpression.references().nonEmpty() || defaultValueExpression.exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateDefaultValueExpr$1(x$13)))) {
            throw QueryCompilationErrors$.MODULE$.defaultValueNotConstantError(statement, colName, defaultValueExpression.originalSQL());
        }
        if (!defaultValueExpression.deterministic()) {
            throw QueryCompilationErrors$.MODULE$.defaultValueNonDeterministicError(statement, colName, defaultValueExpression.originalSQL());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateCatalogForDefaultValue$1(ColumnDefinition x$1) {
        return x$1.defaultValue().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$validateTableProviderForDefaultValue$1(StructField x$2) {
        return x$2.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$containsExplicitDefaultColumn$1(Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            return MODULE$.isExplicitDefaultColumn(unresolvedAttribute);
        }
        return false;
    }

    private static final /* synthetic */ CatalystSqlParser parser$lzycompute$1(LazyRef parser$lzy$1) {
        CatalystSqlParser catalystSqlParser;
        LazyRef lazyRef = parser$lzy$1;
        synchronized (lazyRef) {
            catalystSqlParser = parser$lzy$1.initialized() ? (CatalystSqlParser)parser$lzy$1.value() : (CatalystSqlParser)parser$lzy$1.initialize((Object)new CatalystSqlParser());
        }
        return catalystSqlParser;
    }

    private static final CatalystSqlParser parser$1(LazyRef parser$lzy$1) {
        if (parser$lzy$1.initialized()) {
            return (CatalystSqlParser)parser$lzy$1.value();
        }
        return ResolveDefaultColumns$.parser$lzycompute$1(parser$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$defaultValueFromWiderTypeLiteral$1(DataType x$8) {
        DataType dataType = x$8;
        return dataType instanceof BooleanType ? true : (dataType instanceof ArrayType ? true : (dataType instanceof StructType ? true : dataType instanceof MapType));
    }

    public static final /* synthetic */ boolean $anonfun$getDescribeMetadata$1(StructField x$10) {
        return x$10.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$getDescribeMetadata$4(Column x$11) {
        return x$11.defaultValue() != null;
    }

    public static final /* synthetic */ boolean $anonfun$hasExistenceDefaultValues$1(Object x$12) {
        return x$12 != null;
    }

    public static final /* synthetic */ boolean $anonfun$validateDefaultValueExpr$1(Expression x$13) {
        return x$13 instanceof VariableReference;
    }

    private ResolveDefaultColumns$() {
    }
}

