/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.fpm.AssociationRules;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;

public class JavaSimpleFPGrowth {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("FP-growth Example");
        JavaSparkContext sc = new JavaSparkContext(conf);
        JavaRDD data = sc.textFile("data/mllib/sample_fpgrowth.txt");
        JavaRDD transactions = data.map((Function & Serializable)line -> Arrays.asList(line.split(" ")));
        FPGrowth fpg = new FPGrowth().setMinSupport(0.2).setNumPartitions(10);
        FPGrowthModel model = fpg.run(transactions);
        for (FPGrowth.FreqItemset itemset : model.freqItemsets().toJavaRDD().collect()) {
            System.out.println("[" + String.valueOf(itemset.javaItems()) + "], " + itemset.freq());
        }
        double minConfidence = 0.8;
        for (AssociationRules.Rule rule : model.generateAssociationRules(minConfidence).toJavaRDD().collect()) {
            System.out.println(String.valueOf(rule.javaAntecedent()) + " => " + String.valueOf(rule.javaConsequent()) + ", " + rule.confidence());
        }
        sc.stop();
    }
}

