/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNHash {
    private static final Logger LOG = LoggerFactory.getLogger(TopNHash.class);
    public static final int FORWARD = -1;
    public static final int EXCLUDE = -2;
    private static final int MAY_FORWARD = -3;
    protected BinaryCollector collector;
    protected int topN;
    protected long threshold;
    protected long usage;
    private byte[][] keys;
    private byte[][] values;
    private int[] hashes;
    private int[] distKeyLengths;
    private IndexStore indexes;
    private int evicted;
    private int excluded;
    private int batchNumForwards = 0;
    private int[] indexToBatchIndex;
    protected int[] batchIndexToResult;
    protected int batchSize;
    protected boolean isEnabled = false;
    private final Comparator<Integer> C = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            byte[] key1 = TopNHash.this.keys[o1];
            byte[] key2 = TopNHash.this.keys[o2];
            int length1 = TopNHash.this.distKeyLengths[o1];
            int length2 = TopNHash.this.distKeyLengths[o2];
            return WritableComparator.compareBytes((byte[])key1, (int)0, (int)length1, (byte[])key2, (int)0, (int)length2);
        }
    };

    public void initialize(int topN, float memUsage, boolean isMapGroupBy, BinaryCollector collector, OperatorDesc conf, Configuration hconf) {
        assert (topN >= 0 && memUsage > 0.0f);
        assert (!this.isEnabled);
        this.isEnabled = false;
        this.topN = topN;
        this.collector = collector;
        if (topN == 0) {
            this.isEnabled = true;
            return;
        }
        boolean isTez = HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez");
        boolean isLlap = isTez && HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE).equals("llap");
        int numExecutors = isLlap ? HiveConf.getIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS) : 1;
        long totalFreeMemory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        if (isTez) {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            long memoryUsedPerExecutor = memoryMXBean.getHeapMemoryUsage().getUsed() / (long)numExecutors;
            totalFreeMemory = conf.getMaxMemoryAvailable() - memoryUsedPerExecutor;
        }
        this.threshold = (long)(memUsage * (float)totalFreeMemory) - (long)topN * 64L;
        if (this.threshold < 0L) {
            return;
        }
        this.indexes = isMapGroupBy ? new HashForGroup() : new HashForRow();
        this.keys = new byte[topN + 1][];
        this.values = new byte[topN + 1][];
        this.hashes = new int[topN + 1];
        this.distKeyLengths = new int[topN + 1];
        this.evicted = topN;
        this.isEnabled = true;
    }

    public int tryStoreKey(HiveKey key, boolean partColsIsNull) throws HiveException, IOException {
        if (!this.isEnabled) {
            return -1;
        }
        if (this.topN == 0) {
            return -2;
        }
        int index = this.insertKeyIntoHeap(key);
        if (index >= 0) {
            this.usage += (long)key.getLength();
            return index;
        }
        switch (index) {
            case -1: {
                return -1;
            }
            case -2: {
                return -2;
            }
        }
        assert (false);
        throw new HiveException("Invalid result trying to store the key: " + index);
    }

    public int startVectorizedBatch(int size) throws IOException, HiveException {
        if (!this.isEnabled) {
            return -1;
        }
        if (this.topN == 0) {
            return -2;
        }
        if (this.usage > this.threshold) {
            int excluded = this.excluded;
            LOG.info("Top-N hash is flushing rows");
            this.flushInternal();
            if (excluded == 0) {
                LOG.info("Top-N hash has been disabled");
                this.isEnabled = false;
                return -1;
            }
        }
        this.batchSize = size;
        if (this.batchIndexToResult == null || this.batchIndexToResult.length < this.batchSize) {
            this.batchIndexToResult = new int[Math.max(this.batchSize, 1024)];
        }
        if (this.indexToBatchIndex == null) {
            this.indexToBatchIndex = new int[this.topN + 1];
        }
        Arrays.fill(this.indexToBatchIndex, -1);
        this.batchNumForwards = 0;
        return 0;
    }

    public void tryStoreVectorizedKey(HiveKey key, boolean partColsIsNull, int batchIndex) throws HiveException, IOException {
        int size = this.indexes.size();
        int index = size < this.topN ? size : this.evicted;
        this.keys[index] = Arrays.copyOf(key.getBytes(), key.getLength());
        this.distKeyLengths[index] = key.getDistKeyLength();
        this.hashes[index] = key.hashCode();
        Integer collisionIndex = this.indexes.store(index);
        if (null != collisionIndex) {
            if (this.indexes instanceof HashForGroup) {
                this.indexes.store(collisionIndex);
            }
            ++this.batchNumForwards;
            this.batchIndexToResult[batchIndex] = -3 - collisionIndex;
            return;
        }
        this.indexToBatchIndex[index] = batchIndex;
        this.batchIndexToResult[batchIndex] = index;
        if (size != this.topN) {
            return;
        }
        this.evicted = this.indexes.removeBiggest();
        if (index == this.evicted) {
            ++this.excluded;
            this.batchIndexToResult[batchIndex] = -2;
            this.indexToBatchIndex[index] = -1;
            return;
        }
        this.removed(this.evicted);
        int evictedBatchIndex = this.indexToBatchIndex[this.evicted];
        if (evictedBatchIndex >= 0) {
            this.batchIndexToResult[evictedBatchIndex] = -2;
            this.indexToBatchIndex[this.evicted] = -1;
        }
        int evictedForward = -3 - this.evicted;
        for (int i = evictedBatchIndex + 1; i < batchIndex && this.batchNumForwards > 0; ++i) {
            if (this.batchIndexToResult[i] != evictedForward) continue;
            this.batchIndexToResult[i] = -2;
            --this.batchNumForwards;
        }
    }

    public int getVectorizedBatchResult(int batchIndex) {
        int result = this.batchIndexToResult[batchIndex];
        return result <= -3 ? -1 : result;
    }

    public HiveKey getVectorizedKeyToForward(int batchIndex) {
        int index = -3 - this.batchIndexToResult[batchIndex];
        HiveKey hk = new HiveKey();
        hk.set(this.keys[index], 0, this.keys[index].length);
        hk.setHashCode(this.hashes[index]);
        hk.setDistKeyLength(this.distKeyLengths[index]);
        return hk;
    }

    public int getVectorizedKeyDistLength(int batchIndex) {
        return this.distKeyLengths[this.batchIndexToResult[batchIndex]];
    }

    public int getVectorizedKeyHashCode(int batchIndex) {
        return this.hashes[this.batchIndexToResult[batchIndex]];
    }

    public void storeValue(int index, int hashCode, BytesWritable value, boolean vectorized) {
        this.values[index] = Arrays.copyOf(value.getBytes(), value.getLength());
        this.usage += (long)(this.values[index].length + (vectorized ? this.keys[index].length : 0));
    }

    public void flush() throws HiveException {
        if (!this.isEnabled || this.topN == 0) {
            return;
        }
        try {
            this.flushInternal();
        }
        catch (IOException ex) {
            throw new HiveException(ex);
        }
    }

    private int insertKeyIntoHeap(HiveKey key) throws IOException, HiveException {
        if (this.usage > this.threshold) {
            this.flushInternal();
            if (this.excluded == 0) {
                LOG.info("Top-N hash is disabled");
                this.isEnabled = false;
            }
            return -1;
        }
        int size = this.indexes.size();
        int index = size < this.topN ? size : this.evicted;
        this.keys[index] = Arrays.copyOf(key.getBytes(), key.getLength());
        this.distKeyLengths[index] = key.getDistKeyLength();
        this.hashes[index] = key.hashCode();
        if (null != this.indexes.store(index)) {
            return -1;
        }
        if (size == this.topN) {
            this.evicted = this.indexes.removeBiggest();
            if (index == this.evicted) {
                ++this.excluded;
                return -2;
            }
            this.removed(this.evicted);
        }
        return index;
    }

    private void removed(int index) {
        this.usage -= (long)this.keys[index].length;
        this.keys[index] = null;
        if (this.values[index] != null) {
            this.usage -= (long)this.values[index].length;
            this.values[index] = null;
        }
        this.hashes[index] = -1;
        this.distKeyLengths[index] = -1;
    }

    private void flushInternal() throws IOException, HiveException {
        for (int index : this.indexes.indexes()) {
            if (index == this.evicted || this.values[index] == null) continue;
            this.collector.collect(this.keys[index], this.values[index], this.hashes[index]);
            this.usage -= (long)this.values[index].length;
            this.values[index] = null;
            this.hashes[index] = -1;
        }
        this.excluded = 0;
    }

    private class HashForGroup
    implements IndexStore {
        private final TreeMap<Integer, Integer> indexes;

        private HashForGroup() {
            this.indexes = new TreeMap(TopNHash.this.C);
        }

        @Override
        public int size() {
            return this.indexes.size();
        }

        @Override
        public Integer store(int index) {
            return this.indexes.put(index, index);
        }

        @Override
        public int removeBiggest() {
            Integer last = this.indexes.lastKey();
            this.indexes.remove(last);
            return last;
        }

        @Override
        public Iterable<Integer> indexes() {
            return this.indexes.keySet();
        }
    }

    private class HashForRow
    implements IndexStore {
        private final MinMaxPriorityQueue<Integer> indexes;

        private HashForRow() {
            this.indexes = MinMaxPriorityQueue.orderedBy((Comparator)TopNHash.this.C).create();
        }

        @Override
        public int size() {
            return this.indexes.size();
        }

        @Override
        public Integer store(int index) {
            boolean result = this.indexes.add((Object)index);
            assert (result);
            return null;
        }

        @Override
        public int removeBiggest() {
            return (Integer)this.indexes.removeLast();
        }

        @Override
        public Iterable<Integer> indexes() {
            Integer[] array = (Integer[])this.indexes.toArray((Object[])new Integer[this.indexes.size()]);
            Arrays.sort(array, 0, array.length, TopNHash.this.C);
            return Arrays.asList(array);
        }
    }

    private static interface IndexStore {
        public int size();

        public Integer store(int var1);

        public int removeBiggest();

        public Iterable<Integer> indexes();
    }

    public static interface BinaryCollector {
        public void collect(byte[] var1, byte[] var2, int var3) throws IOException;
    }
}

