/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r-f\u0001\u0002\u001d:\t\u0012CQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001a\u0001\u0005B!DqA\u001e\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011\u0002=\t\u0011\u0005E\u0001A1A\u0005\n]Dq!a\u0005\u0001A\u0003%\u0001\u0010C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002\u0018\u0002!\t%!'\t\u0013\u0005\r\u0006!%A\u0005\u0002\u0005\u0015\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u00033\u0004A\u0011IAn\u0011\u001d\tI\u000f\u0001C!\u0003WDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0003:\u0001!\tEa\u000f\t\u000f\tm\u0003\u0001\"\u0011\u0003^!I!1\r\u0001C\u0002\u00135!Q\r\u0005\t\u0005k\u0002\u0001\u0015!\u0004\u0003h!9!q\u000f\u0001\u0005B\tedA\u0002BR\u0001\u0001\u0011)\u000b\u0003\u0004e3\u0011\u0005!q\u0016\u0005\b\u0005gKB\u0011\tB[\u0011\u001d\u0011y,\u0007C!\u0005\u0003DqAa4\u0001\t\u0003\u0012\t\u000eC\u0004\u0003`\u0002!\tE!9\t\u000f\t5\b\u0001\"\u0011\u0003p\"9!\u0011\u001f\u0001\u0005B\t=\bb\u0002Bz\u0001\u0011\u0005#q\u001e\u0005\b\u0005k\u0004A\u0011\tB|\u0011\u001d\u0019I\u0001\u0001C!\u0007\u0017Aqa!\u0006\u0001\t\u0003\u001a9\u0002C\u0004\u0004\u001c\u0001!\te!\b\t\u000f\r%\u0002\u0001\"\u0011\u0004,!A1\u0011\t\u0001\u0002\u0002\u0013\u0005Q\rC\u0005\u0004D\u0001\t\t\u0011\"\u0011\u0004F!I1q\t\u0001\u0002\u0002\u0013\u00051\u0011\n\u0005\n\u0007\u0017\u0002\u0011\u0011!C\u0001\u0007\u001bB\u0011ba\u0015\u0001\u0003\u0003%\te!\u0016\t\u0013\r}\u0003!!A\u0005\u0002\r\u0005\u0004\"CB3\u0001\u0005\u0005I\u0011IB4\u0011%\u0019Y\u0007AA\u0001\n\u0003\u001ai\u0007C\u0005\u0004p\u0001\t\t\u0011\"\u0011\u0004r!I11\u000f\u0001\u0002\u0002\u0013\u00053QO\u0004\n\u0007sJ\u0014\u0011!E\u0005\u0007w2\u0001\u0002O\u001d\u0002\u0002#%1Q\u0010\u0005\u0007IJ\"\ta!&\t\u0013\r=$'!A\u0005F\rE\u0004\u0002CBLe\u0005\u0005I\u0011Q3\t\u0013\re%'!A\u0005\u0002\u000em\u0005\"CBQe\u0005\u0005I\u0011BBR\u0005=\u0001vn\u001d;he\u0016\u001cH)[1mK\u000e$(B\u0001\u001e<\u0003\u0011QGMY2\u000b\u0005qj\u0014aA:rY*\u0011ahP\u0001\u0006gB\f'o\u001b\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001)\u0015j\u0014*Y!\t1u)D\u0001:\u0013\tA\u0015HA\u0006KI\n\u001cG)[1mK\u000e$\bC\u0001&N\u001b\u0005Y%B\u0001'<\u0003!\u0019\u0017\r^1msN$\u0018B\u0001(L\u00055\u0019\u0016\u000bT\"p]\u001aDU\r\u001c9feB\u0011a\tU\u0005\u0003#f\u0012\u0011CT8MK\u001e\f7-\u001f&E\u0005\u000e+%O]8s!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u001d\u0001&o\u001c3vGR\u0004\"!W1\u000f\u0005i{fBA._\u001b\u0005a&BA/D\u0003\u0019a$o\\8u}%\tQ+\u0003\u0002a)\u00069\u0001/Y2lC\u001e,\u0017B\u00012d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0001G+\u0001\u0004=S:LGO\u0010\u000b\u0002MB\u0011a\tA\u0001\nG\u0006t\u0007*\u00198eY\u0016$\"!\u001b7\u0011\u0005MS\u0017BA6U\u0005\u001d\u0011un\u001c7fC:DQ!\u001c\u0002A\u00029\f1!\u001e:m!\ty7O\u0004\u0002qcB\u00111\fV\u0005\u0003eR\u000ba\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!\u000fV\u0001\u001cgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u0003a\u0004B!\u001f@\u0002\u00025\t!P\u0003\u0002|y\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003{R\u000b!bY8mY\u0016\u001cG/[8o\u0013\ty(PA\u0002TKR\u0004B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0003mC:<'BAA\u0006\u0003\u0011Q\u0017M^1\n\u0007Q\f)!\u0001\u000ftkB\u0004xN\u001d;fI\u0006;wM]3hCR,g)\u001e8di&|gn\u001d\u0011\u0002%M,\b\u000f]8si\u0016$g)\u001e8di&|gn]\u0001\u0014gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7\u000fI\u0001\u0014SN\u001cV\u000f\u001d9peR,GMR;oGRLwN\u001c\u000b\u0004S\u0006e\u0001BBA\u000e\u000f\u0001\u0007a.\u0001\u0005gk:\u001cg*Y7f\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GCCA\u0011\u0003g\ti$!\u0011\u0002FA)1+a\t\u0002(%\u0019\u0011Q\u0005+\u0003\r=\u0003H/[8o!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017w\u0005)A/\u001f9fg&!\u0011\u0011GA\u0016\u0005!!\u0015\r^1UsB,\u0007bBA\u001b\u0011\u0001\u0007\u0011qG\u0001\bgFdG+\u001f9f!\r\u0019\u0016\u0011H\u0005\u0004\u0003w!&aA%oi\"1\u0011q\b\u0005A\u00029\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0003\u0007B\u0001\u0019AA\u001c\u0003\u0011\u0019\u0018N_3\t\u000f\u0005\u001d\u0003\u00021\u0001\u0002J\u0005\u0011Q\u000e\u001a\t\u0005\u0003S\tY%\u0003\u0003\u0002N\u0005-\"aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u001dQ|7)\u0019;bYf\u001cH\u000fV=qKRA\u0011\u0011EA*\u0003+\nI\u0006\u0003\u0004\u0002@%\u0001\rA\u001c\u0005\b\u0003/J\u0001\u0019AA\u001c\u0003%\u0001(/Z2jg&|g\u000eC\u0004\u0002H%\u0001\r!!\u0013\u0002E\r|gN^3si*\u000bg/\u0019+j[\u0016\u001cH/Y7q)>$\u0016.\\3ti\u0006l\u0007O\u0014+[)\u0011\ty&a\u001b\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GRA!!\u001a\u0002\n\u0005!A/[7f\u0013\u0011\tI'a\u0019\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u001d\tiG\u0003a\u0001\u0003_\n\u0011\u0001\u001e\t\u0005\u0003c\n)(\u0004\u0002\u0002t)\u0019A(!\u0003\n\t\u0005]\u00141\u000f\u0002\n)&lWm\u001d;b[B\f!eY8om\u0016\u0014H\u000fV5nKN$\u0018-\u001c9O)j#vNS1wCRKW.Z:uC6\u0004H\u0003BA8\u0003{Bq!a \f\u0001\u0004\ty&A\u0002mIR\f1bZ3u\u0015\u0012\u00135\tV=qKR!\u0011QQAG!\u0015\u0019\u00161EAD!\r1\u0015\u0011R\u0005\u0004\u0003\u0017K$\u0001\u0003&eE\u000e$\u0016\u0010]3\t\u000f\u0005=E\u00021\u0001\u0002(\u0005\u0011A\r^\u0001\u0019SN\u001c\u0015m]2bI&tw\r\u0016:v]\u000e\fG/\u001a+bE2,GCAAK!\u0011\u0019\u00161E5\u0002!\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLH#\u00028\u0002\u001c\u0006}\u0005BBAO\u001d\u0001\u0007a.A\u0003uC\ndW\rC\u0005\u0002\":\u0001\n\u00111\u0001\u0002\u0016\u000691-Y:dC\u0012,\u0017AG4fiR\u0013XO\\2bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAATU\u0011\t)*!+,\u0005\u0005-\u0006\u0003BAW\u0003ok!!a,\u000b\t\u0005E\u00161W\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!.U\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\u000byKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1BY3g_J,g)\u001a;dQR1\u0011qXAc\u0003\u001f\u00042aUAa\u0013\r\t\u0019\r\u0016\u0002\u0005+:LG\u000fC\u0004\u0002HB\u0001\r!!3\u0002\u0015\r|gN\\3di&|g\u000e\u0005\u0003\u0002r\u0005-\u0017\u0002BAg\u0003g\u0012!bQ8o]\u0016\u001cG/[8o\u0011\u001d\t\t\u000e\u0005a\u0001\u0003'\f!\u0002\u001d:pa\u0016\u0014H/[3t!\u0015y\u0017Q\u001b8o\u0013\r\t9.\u001e\u0002\u0004\u001b\u0006\u0004\u0018\u0001G4fiV\u0003H-\u0019;f\u0007>dW/\u001c8UsB,\u0017+^3ssR9a.!8\u0002b\u0006\u0015\bBBAp#\u0001\u0007a.A\u0005uC\ndWMT1nK\"1\u00111]\tA\u00029\f!bY8mk6tg*Y7f\u0011\u0019\t9/\u0005a\u0001]\u0006Ya.Z<ECR\fG+\u001f9f\u0003}9W\r^+qI\u0006$XmQ8mk6tg*\u001e7mC\nLG.\u001b;z#V,'/\u001f\u000b\b]\u00065\u0018q^Ay\u0011\u0019\tyN\u0005a\u0001]\"1\u00111\u001d\nA\u00029Da!a=\u0013\u0001\u0004I\u0017AC5t\u001dVdG.\u00192mK\u0006Y1M]3bi\u0016Le\u000eZ3y)-q\u0017\u0011`A\u007f\u0005#\u00119Ca\u000e\t\r\u0005m8\u00031\u0001o\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0002\u0000N\u0001\rA!\u0001\u0002\u0015Q\f'\r\\3JI\u0016tG\u000f\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u000f\r\fG/\u00197pO*\u0019!1B\u001e\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B\b\u0005\u000b\u0011!\"\u00133f]RLg-[3s\u0011\u001d\u0011\u0019b\u0005a\u0001\u0005+\tqaY8mk6t7\u000fE\u0003T\u0005/\u0011Y\"C\u0002\u0003\u001aQ\u0013Q!\u0011:sCf\u0004BA!\b\u0003$5\u0011!q\u0004\u0006\u0005\u0005C\u0011I!A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002B\u0013\u0005?\u0011aBT1nK\u0012\u0014VMZ3sK:\u001cW\rC\u0004\u0003*M\u0001\rAa\u000b\u0002#\r|G.^7ogB\u0013x\u000e]3si&,7\u000f\u0005\u0005\u0003.\tM\"1\u0004B\u001b\u001b\t\u0011yC\u0003\u0003\u00032\u0005%\u0011\u0001B;uS2LA!a6\u00030A1!Q\u0006B\u001a]:Dq!!5\u0014\u0001\u0004\u0011)$A\u0006j]\u0012,\u00070\u0012=jgR\u001cH#C5\u0003>\t\u0005#1\tB#\u0011\u001d\u0011y\u0004\u0006a\u0001\u0003\u0013\fAaY8o]\"1\u00111 \u000bA\u00029Dq!a@\u0015\u0001\u0004\u0011\t\u0001C\u0004\u0003HQ\u0001\rA!\u0013\u0002\u000f=\u0004H/[8ogB!!1\nB,\u001b\t\u0011iEC\u0002;\u0005\u001fRAA!\u0015\u0003T\u0005YA-\u0019;bg>,(oY3t\u0015\r\u0011)fO\u0001\nKb,7-\u001e;j_:LAA!\u0017\u0003N\tY!\n\u0012\"D\u001fB$\u0018n\u001c8t\u0003%!'o\u001c9J]\u0012,\u0007\u0010F\u0003o\u0005?\u0012\t\u0007\u0003\u0004\u0002|V\u0001\rA\u001c\u0005\b\u0003\u007f,\u0002\u0019\u0001B\u0001\u0003Q\u0001x-\u00117sK\u0006$\u00170\u0012=jgR\u001c(+Z4fqV\u0011!q\r\t\u0005\u0005S\u0012\t(\u0004\u0002\u0003l)!!Q\u000eB8\u0003!i\u0017\r^2iS:<'b\u0001B\u0019)&!!1\u000fB6\u0005\u0015\u0011VmZ3y\u0003U\u0001x-\u00117sK\u0006$\u00170\u0012=jgR\u001c(+Z4fq\u0002\n\u0011c\u00197bgNLg-_#yG\u0016\u0004H/[8o)1\u0011YHa$\u0003\u0014\n]%1\u0014BP%\u0019\u0011iH!!\u0003\b\u001a1!q\u0010\u0001\u0001\u0005w\u0012A\u0002\u0010:fM&tW-\\3oiz\u00022!\u0017BB\u0013\r\u0011)i\u0019\u0002\n)\"\u0014xn^1cY\u0016\u0004BA!#\u0003\f6\tQ(C\u0002\u0003\u000ev\u0012ab\u00159be.$\u0006N]8xC\ndW\rC\u0004\u0003\u0012b\u0001\rA!!\u0002\u0003\u0015DaA!&\u0019\u0001\u0004q\u0017!C2p]\u0012LG/[8o\u0011\u001d\u0011I\n\u0007a\u0001\u0003'\f\u0011#\\3tg\u0006<W\rU1sC6,G/\u001a:t\u0011\u0019\u0011i\n\u0007a\u0001]\u0006YA-Z:de&\u0004H/[8o\u0011\u0019\u0011\t\u000b\u0007a\u0001S\u0006I\u0011n\u001d*v]RLW.\u001a\u0002\u0013!>\u001cHo\u001a:fgN\u000bFJQ;jY\u0012,'oE\u0002\u001a\u0005O\u0003BA!+\u0003,6\t\u0001!C\u0002\u0003.\u001e\u0013aB\u0013#C\u0007N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u00032B\u0019!\u0011V\r\u0002\u0019YL7/\u001b;FqR\u0014\u0018m\u0019;\u0015\u000b9\u00149La/\t\r\te6\u00041\u0001o\u0003\u00151\u0017.\u001a7e\u0011\u0019\u0011il\u0007a\u0001]\u000611o\\;sG\u0016\fQC^5tSR\u0014\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7\rF\u0004o\u0005\u0007\u00149Ma3\t\r\t\u0015G\u00041\u0001o\u0003\u0011q\u0017-\\3\t\r\t%G\u00041\u0001o\u0003\u0005a\u0007B\u0002Bg9\u0001\u0007a.A\u0001s\u0003E\u0019w.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0005\u0005'\u0014)\u000e\u0005\u0003T\u0003Gq\u0007b\u0002Bl;\u0001\u0007!\u0011\\\u0001\u0005Kb\u0004(\u000f\u0005\u0003\u0003\u001e\tm\u0017\u0002\u0002Bo\u0005?\u0011!\"\u0012=qe\u0016\u001c8/[8o\u00031\u0019w.\u001c9jY\u00164\u0016\r\\;f)\u0011\u0011\u0019O!;\u0011\u0007M\u0013)/C\u0002\u0003hR\u00131!\u00118z\u0011\u001d\u0011YO\ba\u0001\u0005G\fQA^1mk\u0016\fQb];qa>\u0014Ho\u001d'j[&$X#A5\u0002\u001dM,\b\u000f]8siN|eMZ:fi\u0006\u00192/\u001e9q_J$8\u000fV1cY\u0016\u001c\u0016-\u001c9mK\u0006qq-\u001a;UC\ndWmU1na2,Gc\u00018\u0003z\"9!1 \u0012A\u0002\tu\u0018AB:b[BdW\r\u0005\u0003\u0003\u0000\u000e\u0015QBAB\u0001\u0015\u0011\u0019\u0019Aa\u0014\u0002\u0005Y\u0014\u0014\u0002BB\u0004\u0007\u0003\u0011q\u0002V1cY\u0016\u001c\u0016-\u001c9mK&sgm\\\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0003o\u0007\u001b\u0019\t\u0002C\u0004\u0004\u0010\r\u0002\rA!\u0001\u0002\u0011=dG\rV1cY\u0016Dqaa\u0005$\u0001\u0004\u0011\t!\u0001\u0005oK^$\u0016M\u00197f\u0003}\u0019wN\u001c<feRT\u0015M^1US6,7\u000f^1naR{G+[7fgR\fW\u000e\u001d\u000b\u0005\u0003_\u001aI\u0002C\u0004\u0002n\u0011\u0002\r!a\u001c\u0002+\r|gN^3si*\u000bg/\u0019#bi\u0016$v\u000eR1uKR!1qDB\u0013!\u0011\t\th!\t\n\t\r\r\u00121\u000f\u0002\u0005\t\u0006$X\rC\u0004\u0004(\u0015\u0002\raa\b\u0002\u0003\u0011\fQ#\u001e9eCR,W\t\u001f;sC\u000e{G.^7o\u001b\u0016$\u0018\r\u0006\u0006\u0002@\u000e52qFB\u001d\u0007{AqAa\u0010'\u0001\u0004\tI\rC\u0004\u00042\u0019\u0002\raa\r\u0002\tI\u001cX\u000e\u001a\t\u0005\u0003c\u001a)$\u0003\u0003\u00048\u0005M$!\u0005*fgVdGoU3u\u001b\u0016$\u0018\rR1uC\"911\b\u0014A\u0002\u0005]\u0012!C2pYVlg.\u00133y\u0011\u001d\u0019yD\na\u0001\u0003\u0013\n\u0001\"\\3uC\u0012\fG/Y\u0001\u0005G>\u0004\u00180A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1]B(\u0011%\u0019\tFKA\u0001\u0002\u0004\t9$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007/\u0002ba!\u0017\u0004\\\t\rX\"\u0001?\n\u0007\ruCP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA5\u0004d!I1\u0011\u000b\u0017\u0002\u0002\u0003\u0007!1]\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0002\r%\u0004\"CB)[\u0005\u0005\t\u0019AA\u001c\u0003!A\u0017m\u001d5D_\u0012,GCAA\u001c\u0003!!xn\u0015;sS:<GCAA\u0001\u0003\u0019)\u0017/^1mgR\u0019\u0011na\u001e\t\u0013\rE\u0003'!AA\u0002\t\r\u0018a\u0004)pgR<'/Z:ES\u0006dWm\u0019;\u0011\u0005\u0019\u00134#\u0002\u001a\u0004\u0000\r-\u0005#BBA\u0007\u000f3WBABB\u0015\r\u0019)\tV\u0001\beVtG/[7f\u0013\u0011\u0019Iia!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007\u0005\u0003\u0004\u000e\u000eMUBABH\u0015\u0011\u0019\t*!\u0003\u0002\u0005%|\u0017b\u00012\u0004\u0010R\u001111P\u0001\u0006CB\u0004H._\u0001\bk:\f\u0007\u000f\u001d7z)\rI7Q\u0014\u0005\t\u0007?3\u0014\u0011!a\u0001M\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r\u0015\u0006\u0003BA\u0002\u0007OKAa!+\u0002\u0006\t1qJ\u00196fGR\u0004")
public class PostgresDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Regex pgAlreadyExistsRegex;

    public static boolean unapply(PostgresDialect x$0) {
        return PostgresDialect$.MODULE$.unapply(x$0);
    }

    public static PostgresDialect apply() {
        return PostgresDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (7 == n2) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (5 == n2) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (-7 == n2) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (8 == n2) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (93 == n2 && "timestamptz".equalsIgnoreCase(typeName) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (92 == n2 && "timetz".equalsIgnoreCase(typeName)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (1 == n2 && "bpchar".equalsIgnoreCase(typeName) && size == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (1111 == n2) {
            bl = true;
            n = n2;
            if ("void".equalsIgnoreCase(typeName)) {
                return new Some((Object)NullType$.MODULE$);
            }
        }
        if (bl) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("text".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (2003 == n2) {
            Option<DataType> elementType = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, md);
            return elementType.map((Function1 & Serializable)et -> {
                Metadata metadata = md.build();
                int dim = metadata.contains("arrayDimension") ? (int)metadata.getLong("arrayDimension") : 1;
                return (DataType)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).foldLeft(et, (Function2 & Serializable)(acc, x$1) -> ArrayType$.MODULE$.apply(acc));
            });
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, MetadataBuilder md) {
        boolean bl = false;
        String string = null;
        String string2 = typeName;
        if ("bool".equals(string2)) {
            return new Some((Object)BooleanType$.MODULE$);
        }
        if ("bit".equals(string2)) {
            bl = true;
            string = string2;
            if (precision == 1) {
                return new Some((Object)BooleanType$.MODULE$);
            }
        }
        if (bl) {
            md.putBoolean("pg_bit_array_type", true);
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("int2".equals(string2)) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if ("int4".equals(string2)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if ("int8".equals(string2) ? true : "oid".equals(string2)) {
            return new Some((Object)LongType$.MODULE$);
        }
        if ("float4".equals(string2)) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if ("float8".equals(string2)) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        if ("varchar".equals(string2)) {
            return new Some((Object)new VarcharType(precision));
        }
        if ("bpchar".equals(string2) && precision == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("char".equals(string2) ? true : "bpchar".equals(string2)) {
            return new Some((Object)new CharType(precision));
        }
        if ("text".equals(string2) ? true : ("cidr".equals(string2) ? true : ("inet".equals(string2) ? true : ("json".equals(string2) ? true : ("jsonb".equals(string2) ? true : ("uuid".equals(string2) ? true : ("xml".equals(string2) ? true : ("tsvector".equals(string2) ? true : ("tsquery".equals(string2) ? true : ("macaddr".equals(string2) ? true : ("macaddr8".equals(string2) ? true : ("txid_snapshot".equals(string2) ? true : ("point".equals(string2) ? true : ("line".equals(string2) ? true : ("lseg".equals(string2) ? true : ("box".equals(string2) ? true : ("path".equals(string2) ? true : ("polygon".equals(string2) ? true : ("circle".equals(string2) ? true : ("pg_lsn".equals(string2) ? true : ("varbit".equals(string2) ? true : ("interval".equals(string2) ? true : "pg_snapshot".equals(string2))))))))))))))))))))))) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("bytea".equals(string2)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("timestamptz".equals(string2) ? true : "timetz".equals(string2)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ("timestamp".equals(string2) ? true : "time".equals(string2)) {
            return new Some((Object)this.getTimestampType(md.build()));
        }
        if ("date".equals(string2)) {
            return new Some((Object)DateType$.MODULE$);
        }
        if (("numeric".equals(string2) ? true : "decimal".equals(string2)) && precision > 0) {
            int scale = (int)md.build().getLong("scale");
            return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
        }
        if ("numeric".equals(string2) ? true : "decimal".equals(string2)) {
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        if ("money".equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)StringType$.MODULE$);
    }

    @Override
    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return t.toLocalDateTime();
    }

    @Override
    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH TIME ZONE", 93));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        if (dataType instanceof ArrayType && ((et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType || et instanceof ArrayType)) {
            return this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(typeName + "[]", 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE ONLY " + table + " CASCADE";
        }
        return "TRUNCATE TABLE ONLY " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String indexType;
        Object indexProperties;
        String[] columnList;
        block1: {
            columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
            indexProperties = "";
            Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String indexType2 = (String)tuple2._1();
            String[] indexPropertyList = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType2, (Object)indexPropertyList);
            indexType = (String)tuple22._1();
            String[] indexPropertyList2 = (String[])tuple22._2();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) break block1;
            indexProperties = "WITH (" + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ") + ")";
        }
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.quoteIdentifier(tableIdent.name()) + " " + indexType + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + (String)indexProperties;
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM pg_indexes WHERE tablename = '" + tableIdent.name() + "' AND indexname = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName);
    }

    private final Regex pgAlreadyExistsRegex() {
        return this.pgAlreadyExistsRegex;
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    String string2 = condition;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    if (!"42P07".equals(string)) break;
                    String string4 = condition;
                    String string5 = "FAILED_JDBC.CREATE_INDEX";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        throw new IndexAlreadyExistsException((String)messageParameters.apply((Object)"indexName"), (String)messageParameters.apply((Object)"tableName"), (Option)new Some((Object)e));
                    }
                    String string6 = condition;
                    String string7 = "FAILED_JDBC.RENAME_TABLE";
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        String newTable = (String)messageParameters.apply((Object)"newName");
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                    }
                    Option tblRegexp = this.pgAlreadyExistsRegex().findFirstMatchIn((CharSequence)sQLException.getMessage());
                    if (tblRegexp.nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(((Regex.MatchData)tblRegexp.get()).group(1));
                    }
                    return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        PostgresSQLBuilder postgresSQLBuilder = new PostgresSQLBuilder(this);
        try {
            some = new Some((Object)postgresSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$5 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$5))})), ClassTag$.MODULE$.apply(String.class))).mkString("'\\x", "", "'::bytea");
        }
        return super.compileValue(object);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE BERNOULLI (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        if (!Predef$.MODULE$.wrapRefArray((Object[])oldTable.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newTable.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.cannotRenameTableAcrossSchemaError();
        }
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + newTable.name();
    }

    @Override
    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        long l = t.getTime();
        if (9223372036825200000L == l) {
            return new Timestamp(LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999999999).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Timestamp(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return t;
    }

    @Override
    public Date convertJavaDateToDate(Date d) {
        long l = d.getTime();
        if (9223372036825200000L == l) {
            return new Date(LocalDateTime.of(9999, 12, 31, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Date(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return d;
    }

    @Override
    public void updateExtraColumnMeta(Connection conn, ResultSetMetaData rsmd, int columnIdx, MetadataBuilder metadata) {
        int n = rsmd.getColumnType(columnIdx);
        switch (n) {
            case 2003: {
                String tableName = rsmd.getTableName(columnIdx);
                String columnName = rsmd.getColumnName(columnIdx);
                String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT pg_attribute.attndims\n             |FROM pg_attribute\n             |  JOIN pg_class ON pg_attribute.attrelid = pg_class.oid\n             |  JOIN pg_namespace ON pg_class.relnamespace = pg_namespace.oid\n             |WHERE pg_class.relname = '" + tableName + "' and pg_attribute.attname = '" + columnName + "'\n             |"));
                try {
                    Using$.MODULE$.resource((Object)conn.createStatement(), (Function1 & Serializable)stmt -> Using$.MODULE$.resource((Object)stmt.executeQuery(query), (Function1 & Serializable)rs -> {
                        if (rs.next()) {
                            return metadata.putLong("arrayDimension", Math.max(1L, rs.getLong(1)));
                        }
                        return BoxedUnit.UNIT;
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                }
                catch (SQLException e) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get array dimension for column ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COLUMN_NAME$.MODULE$, (Object)columnName)}))), (Throwable)e);
                }
                return;
            }
        }
    }

    public PostgresDialect copy() {
        return new PostgresDialect();
    }

    public String productPrefix() {
        return "PostgresDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PostgresDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof PostgresDialect && ((PostgresDialect)x$1).canEqual(this);
    }

    public PostgresDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedFunctions = this.supportedAggregateFunctions();
        this.pgAlreadyExistsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:.*)relation \"(.*)\" already exists"));
    }

    public class PostgresSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISOYEAR";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISODOW";
                        break block5;
                    }
                    case 2074292194: {
                        if (!"DAY_OF_YEAR".equals(string2)) break;
                        string = "DOY";
                        break block5;
                    }
                }
                string = field;
            }
            String postgresField = string;
            return super.visitExtract(postgresField, source);
        }

        public String visitBinaryArithmetic(String name, String l, String r) {
            return l + " " + name.replace('^', '#') + " " + r;
        }

        public /* synthetic */ PostgresDialect org$apache$spark$sql$jdbc$PostgresDialect$PostgresSQLBuilder$$$outer() {
            return (PostgresDialect)this.$outer;
        }

        public PostgresSQLBuilder(PostgresDialect $outer) {
            super($outer);
        }
    }
}

