/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils;
import org.apache.spark.sql.execution.datasources.parquet.FieldToExtract;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedColumnReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.types.variant.VariantSchema;
import org.sparkproject.guava.base.Preconditions;

final class ParquetColumnVector {
    private final ParquetColumn column;
    private final List<ParquetColumnVector> children;
    private final WritableColumnVector vector;
    private VariantSchema variantSchema;
    private FieldToExtract[] fieldsToExtract;
    private WritableColumnVector repetitionLevels;
    private WritableColumnVector definitionLevels;
    private final boolean isPrimitive;
    private VectorizedColumnReader columnReader;

    ParquetColumnVector(ParquetColumn column, WritableColumnVector vector, int capacity, MemoryMode memoryMode, Set<ParquetColumn> missingColumns, boolean isTopLevel, Object defaultValue) {
        DataType sparkType = column.sparkType();
        if (!DataTypeUtils.sameType((DataType)sparkType, (DataType)vector.dataType())) {
            throw new IllegalArgumentException("Spark type: " + String.valueOf(sparkType) + " doesn't match the type: " + String.valueOf(vector.dataType()) + " in column vector");
        }
        this.column = column;
        this.vector = vector;
        this.children = new ArrayList<ParquetColumnVector>();
        this.isPrimitive = column.isPrimitive();
        if (missingColumns.contains(column)) {
            if (ParquetRowIndexUtil.isRowIndexColumn(column)) {
                return;
            }
            if (defaultValue == null) {
                vector.setAllNull();
                return;
            }
            if (vector.appendObjects(capacity, defaultValue).isEmpty()) {
                throw new IllegalArgumentException("Cannot assign default column value to result column batch in vectorized Parquet reader because the data type is not supported: " + String.valueOf(defaultValue));
            }
            vector.setIsConstant();
        }
        if (column.variantFileType().isDefined()) {
            ParquetColumn fileContentCol = (ParquetColumn)column.variantFileType().get();
            WritableColumnVector fileContent = memoryMode == MemoryMode.OFF_HEAP ? new OffHeapColumnVector(capacity, fileContentCol.sparkType()) : new OnHeapColumnVector(capacity, fileContentCol.sparkType());
            ParquetColumnVector contentVector = new ParquetColumnVector(fileContentCol, fileContent, capacity, memoryMode, missingColumns, false, null);
            this.children.add(contentVector);
            this.variantSchema = SparkShreddingUtils.buildVariantSchema(fileContentCol.sparkType());
            this.fieldsToExtract = SparkShreddingUtils.getFieldsToExtract(column.sparkType(), this.variantSchema);
            this.repetitionLevels = contentVector.repetitionLevels;
            this.definitionLevels = contentVector.definitionLevels;
        } else if (this.isPrimitive) {
            if (column.repetitionLevel() > 0) {
                this.repetitionLevels = ParquetColumnVector.allocateLevelsVector(capacity, memoryMode);
            }
            if (!isTopLevel) {
                this.definitionLevels = ParquetColumnVector.allocateLevelsVector(capacity, memoryMode);
            }
        } else {
            Preconditions.checkArgument((column.children().size() == vector.getNumChildren() ? 1 : 0) != 0);
            boolean allChildrenAreMissing = true;
            for (int i = 0; i < column.children().size(); ++i) {
                ParquetColumnVector childCv = new ParquetColumnVector((ParquetColumn)column.children().apply(i), vector.getChild(i), capacity, memoryMode, missingColumns, false, null);
                this.children.add(childCv);
                if (childCv.vector.isAllNull()) continue;
                allChildrenAreMissing = false;
                this.repetitionLevels = childCv.repetitionLevels;
                this.definitionLevels = childCv.definitionLevels;
            }
            if (allChildrenAreMissing) {
                vector.setAllNull();
            }
        }
    }

    List<ParquetColumnVector> getChildren() {
        return this.children;
    }

    List<ParquetColumnVector> getLeaves() {
        ArrayList<ParquetColumnVector> result = new ArrayList<ParquetColumnVector>();
        ParquetColumnVector.getLeavesHelper(this, result);
        return result;
    }

    private static void getLeavesHelper(ParquetColumnVector vector, List<ParquetColumnVector> coll) {
        if (vector.isPrimitive) {
            coll.add(vector);
        } else {
            for (ParquetColumnVector child : vector.children) {
                ParquetColumnVector.getLeavesHelper(child, coll);
            }
        }
    }

    void assemble() {
        if (this.variantSchema != null) {
            this.children.get(0).assemble();
            WritableColumnVector fileContent = this.children.get(0).getValueVector();
            if (this.fieldsToExtract == null) {
                SparkShreddingUtils.assembleVariantBatch(fileContent, this.vector, this.variantSchema);
            } else {
                SparkShreddingUtils.assembleVariantStructBatch(fileContent, this.vector, this.variantSchema, this.fieldsToExtract);
            }
            return;
        }
        if (this.vector.isAllNull()) {
            return;
        }
        DataType type = this.column.sparkType();
        if (type instanceof ArrayType || type instanceof MapType) {
            for (ParquetColumnVector child : this.children) {
                child.assemble();
            }
            this.assembleCollection();
        } else if (type instanceof StructType || type instanceof VariantType) {
            for (ParquetColumnVector child : this.children) {
                child.assemble();
            }
            this.assembleStruct();
        }
    }

    void reset() {
        if (this.vector.isAllNull()) {
            return;
        }
        this.vector.reset();
        if (this.repetitionLevels != null) {
            this.repetitionLevels.reset();
        }
        if (this.definitionLevels != null) {
            this.definitionLevels.reset();
        }
        for (ParquetColumnVector child : this.children) {
            child.reset();
        }
    }

    ParquetColumn getColumn() {
        return this.column;
    }

    WritableColumnVector getValueVector() {
        return this.vector;
    }

    WritableColumnVector getRepetitionLevelVector() {
        return this.repetitionLevels;
    }

    WritableColumnVector getDefinitionLevelVector() {
        return this.definitionLevels;
    }

    VectorizedColumnReader getColumnReader() {
        return this.columnReader;
    }

    void setColumnReader(VectorizedColumnReader reader) {
        if (!this.isPrimitive) {
            throw new IllegalStateException("Can't set reader for non-primitive column");
        }
        this.columnReader = reader;
    }

    private void assembleCollection() {
        int maxDefinitionLevel = this.column.definitionLevel();
        int maxElementRepetitionLevel = this.column.repetitionLevel();
        int rowId = 0;
        int i = 0;
        int offset = 0;
        while (i < this.definitionLevels.getElementsAppended()) {
            this.vector.reserve(rowId + 1);
            int definitionLevel = this.definitionLevels.getInt(i);
            if (definitionLevel <= maxDefinitionLevel) {
                ++offset;
            }
            if (definitionLevel <= maxDefinitionLevel - 1) {
                this.vector.putNull(rowId++);
            } else if (definitionLevel == maxDefinitionLevel) {
                this.vector.putNotNull(rowId);
                this.vector.putArray(rowId, offset, 0);
                ++rowId;
            } else if (definitionLevel > maxDefinitionLevel) {
                this.vector.putNotNull(rowId);
                int length = this.getCollectionSize(maxElementRepetitionLevel, i);
                this.vector.putArray(rowId, offset, length);
                offset += length;
                ++rowId;
            }
            i = this.getNextCollectionStart(maxElementRepetitionLevel, i);
        }
        this.vector.addElementsAppended(rowId);
    }

    private void assembleStruct() {
        int maxRepetitionLevel = this.column.repetitionLevel();
        int maxDefinitionLevel = this.column.definitionLevel();
        this.vector.reserve(this.definitionLevels.getElementsAppended());
        int rowId = 0;
        boolean hasRepetitionLevels = this.repetitionLevels != null && this.repetitionLevels.getElementsAppended() > 0;
        for (int i = 0; i < this.definitionLevels.getElementsAppended(); ++i) {
            if (hasRepetitionLevels && this.repetitionLevels.getInt(i) > maxRepetitionLevel) continue;
            if (this.definitionLevels.getInt(i) <= maxDefinitionLevel - 1) {
                this.vector.putNull(rowId);
                ++rowId;
                continue;
            }
            if (this.definitionLevels.getInt(i) < maxDefinitionLevel) continue;
            this.vector.putNotNull(rowId);
            ++rowId;
        }
        this.vector.addElementsAppended(rowId);
    }

    private static WritableColumnVector allocateLevelsVector(int capacity, MemoryMode memoryMode) {
        return switch (memoryMode) {
            default -> throw new IncompatibleClassChangeError();
            case MemoryMode.ON_HEAP -> new OnHeapColumnVector(capacity, DataTypes.IntegerType);
            case MemoryMode.OFF_HEAP -> new OffHeapColumnVector(capacity, DataTypes.IntegerType);
        };
    }

    private int getNextCollectionStart(int maxRepetitionLevel, int idx) {
        ++idx;
        while (idx < this.repetitionLevels.getElementsAppended() && this.repetitionLevels.getInt(idx) > maxRepetitionLevel) {
            ++idx;
        }
        return idx;
    }

    private int getCollectionSize(int maxRepetitionLevel, int idx) {
        int size = 1;
        ++idx;
        while (idx < this.repetitionLevels.getElementsAppended() && this.repetitionLevels.getInt(idx) > maxRepetitionLevel) {
            if (this.repetitionLevels.getInt(idx) <= maxRepetitionLevel + 1) {
                ++size;
            }
            ++idx;
        }
        return size;
    }
}

