/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.ExecActionBuilder;
import io.fabric8.kubernetes.api.model.ExecActionFluent;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import io.fabric8.kubernetes.api.model.LifecycleHandler;
import io.fabric8.kubernetes.api.model.SleepAction;
import io.fabric8.kubernetes.api.model.SleepActionBuilder;
import io.fabric8.kubernetes.api.model.SleepActionFluent;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketActionBuilder;
import io.fabric8.kubernetes.api.model.TCPSocketActionFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LifecycleHandlerFluent<A extends LifecycleHandlerFluent<A>>
extends BaseFluent<A> {
    private ExecActionBuilder exec;
    private HTTPGetActionBuilder httpGet;
    private SleepActionBuilder sleep;
    private TCPSocketActionBuilder tcpSocket;
    private Map<String, Object> additionalProperties;

    public LifecycleHandlerFluent() {
    }

    public LifecycleHandlerFluent(LifecycleHandler instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LifecycleHandler instance) {
        LifecycleHandler lifecycleHandler = instance = instance != null ? instance : new LifecycleHandler();
        if (instance != null) {
            this.withExec(instance.getExec());
            this.withHttpGet(instance.getHttpGet());
            this.withSleep(instance.getSleep());
            this.withTcpSocket(instance.getTcpSocket());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExecAction buildExec() {
        return this.exec != null ? this.exec.build() : null;
    }

    public A withExec(ExecAction exec) {
        this._visitables.remove((Object)"exec");
        if (exec != null) {
            this.exec = new ExecActionBuilder(exec);
            this._visitables.get((Object)"exec").add(this.exec);
        } else {
            this.exec = null;
            this._visitables.get((Object)"exec").remove((Object)this.exec);
        }
        return (A)((Object)this);
    }

    public boolean hasExec() {
        return this.exec != null;
    }

    public ExecNested<A> withNewExec() {
        return new ExecNested(null);
    }

    public ExecNested<A> withNewExecLike(ExecAction item) {
        return new ExecNested(item);
    }

    public ExecNested<A> editExec() {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(null));
    }

    public ExecNested<A> editOrNewExec() {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(new ExecActionBuilder().build()));
    }

    public ExecNested<A> editOrNewExecLike(ExecAction item) {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(item));
    }

    public HTTPGetAction buildHttpGet() {
        return this.httpGet != null ? this.httpGet.build() : null;
    }

    public A withHttpGet(HTTPGetAction httpGet) {
        this._visitables.remove((Object)"httpGet");
        if (httpGet != null) {
            this.httpGet = new HTTPGetActionBuilder(httpGet);
            this._visitables.get((Object)"httpGet").add(this.httpGet);
        } else {
            this.httpGet = null;
            this._visitables.get((Object)"httpGet").remove((Object)this.httpGet);
        }
        return (A)((Object)this);
    }

    public boolean hasHttpGet() {
        return this.httpGet != null;
    }

    public HttpGetNested<A> withNewHttpGet() {
        return new HttpGetNested(null);
    }

    public HttpGetNested<A> withNewHttpGetLike(HTTPGetAction item) {
        return new HttpGetNested(item);
    }

    public HttpGetNested<A> editHttpGet() {
        return this.withNewHttpGetLike(Optional.ofNullable(this.buildHttpGet()).orElse(null));
    }

    public HttpGetNested<A> editOrNewHttpGet() {
        return this.withNewHttpGetLike(Optional.ofNullable(this.buildHttpGet()).orElse(new HTTPGetActionBuilder().build()));
    }

    public HttpGetNested<A> editOrNewHttpGetLike(HTTPGetAction item) {
        return this.withNewHttpGetLike(Optional.ofNullable(this.buildHttpGet()).orElse(item));
    }

    public SleepAction buildSleep() {
        return this.sleep != null ? this.sleep.build() : null;
    }

    public A withSleep(SleepAction sleep) {
        this._visitables.remove((Object)"sleep");
        if (sleep != null) {
            this.sleep = new SleepActionBuilder(sleep);
            this._visitables.get((Object)"sleep").add(this.sleep);
        } else {
            this.sleep = null;
            this._visitables.get((Object)"sleep").remove((Object)this.sleep);
        }
        return (A)((Object)this);
    }

    public boolean hasSleep() {
        return this.sleep != null;
    }

    public A withNewSleep(Long seconds) {
        return this.withSleep(new SleepAction(seconds));
    }

    public SleepNested<A> withNewSleep() {
        return new SleepNested(null);
    }

    public SleepNested<A> withNewSleepLike(SleepAction item) {
        return new SleepNested(item);
    }

    public SleepNested<A> editSleep() {
        return this.withNewSleepLike(Optional.ofNullable(this.buildSleep()).orElse(null));
    }

    public SleepNested<A> editOrNewSleep() {
        return this.withNewSleepLike(Optional.ofNullable(this.buildSleep()).orElse(new SleepActionBuilder().build()));
    }

    public SleepNested<A> editOrNewSleepLike(SleepAction item) {
        return this.withNewSleepLike(Optional.ofNullable(this.buildSleep()).orElse(item));
    }

    public TCPSocketAction buildTcpSocket() {
        return this.tcpSocket != null ? this.tcpSocket.build() : null;
    }

    public A withTcpSocket(TCPSocketAction tcpSocket) {
        this._visitables.remove((Object)"tcpSocket");
        if (tcpSocket != null) {
            this.tcpSocket = new TCPSocketActionBuilder(tcpSocket);
            this._visitables.get((Object)"tcpSocket").add(this.tcpSocket);
        } else {
            this.tcpSocket = null;
            this._visitables.get((Object)"tcpSocket").remove((Object)this.tcpSocket);
        }
        return (A)((Object)this);
    }

    public boolean hasTcpSocket() {
        return this.tcpSocket != null;
    }

    public TcpSocketNested<A> withNewTcpSocket() {
        return new TcpSocketNested(null);
    }

    public TcpSocketNested<A> withNewTcpSocketLike(TCPSocketAction item) {
        return new TcpSocketNested(item);
    }

    public TcpSocketNested<A> editTcpSocket() {
        return this.withNewTcpSocketLike(Optional.ofNullable(this.buildTcpSocket()).orElse(null));
    }

    public TcpSocketNested<A> editOrNewTcpSocket() {
        return this.withNewTcpSocketLike(Optional.ofNullable(this.buildTcpSocket()).orElse(new TCPSocketActionBuilder().build()));
    }

    public TcpSocketNested<A> editOrNewTcpSocketLike(TCPSocketAction item) {
        return this.withNewTcpSocketLike(Optional.ofNullable(this.buildTcpSocket()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LifecycleHandlerFluent that = (LifecycleHandlerFluent)((Object)o);
        if (!Objects.equals((Object)this.exec, (Object)that.exec)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpGet, (Object)that.httpGet)) {
            return false;
        }
        if (!Objects.equals((Object)this.sleep, (Object)that.sleep)) {
            return false;
        }
        if (!Objects.equals((Object)this.tcpSocket, (Object)that.tcpSocket)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exec, this.httpGet, this.sleep, this.tcpSocket, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exec != null) {
            sb.append("exec:");
            sb.append(this.exec + ",");
        }
        if (this.httpGet != null) {
            sb.append("httpGet:");
            sb.append(this.httpGet + ",");
        }
        if (this.sleep != null) {
            sb.append("sleep:");
            sb.append(this.sleep + ",");
        }
        if (this.tcpSocket != null) {
            sb.append("tcpSocket:");
            sb.append(this.tcpSocket + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TcpSocketNested<N>
    extends TCPSocketActionFluent<TcpSocketNested<N>>
    implements Nested<N> {
        TCPSocketActionBuilder builder;

        TcpSocketNested(TCPSocketAction item) {
            this.builder = new TCPSocketActionBuilder(this, item);
        }

        public N and() {
            return (N)LifecycleHandlerFluent.this.withTcpSocket(this.builder.build());
        }

        public N endTcpSocket() {
            return this.and();
        }
    }

    public class SleepNested<N>
    extends SleepActionFluent<SleepNested<N>>
    implements Nested<N> {
        SleepActionBuilder builder;

        SleepNested(SleepAction item) {
            this.builder = new SleepActionBuilder(this, item);
        }

        public N and() {
            return (N)LifecycleHandlerFluent.this.withSleep(this.builder.build());
        }

        public N endSleep() {
            return this.and();
        }
    }

    public class HttpGetNested<N>
    extends HTTPGetActionFluent<HttpGetNested<N>>
    implements Nested<N> {
        HTTPGetActionBuilder builder;

        HttpGetNested(HTTPGetAction item) {
            this.builder = new HTTPGetActionBuilder(this, item);
        }

        public N and() {
            return (N)LifecycleHandlerFluent.this.withHttpGet(this.builder.build());
        }

        public N endHttpGet() {
            return this.and();
        }
    }

    public class ExecNested<N>
    extends ExecActionFluent<ExecNested<N>>
    implements Nested<N> {
        ExecActionBuilder builder;

        ExecNested(ExecAction item) {
            this.builder = new ExecActionBuilder(this, item);
        }

        public N and() {
            return (N)LifecycleHandlerFluent.this.withExec(this.builder.build());
        }

        public N endExec() {
            return this.and();
        }
    }
}

