/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import com.google.crypto.tink.subtle.Hex;
import com.google.crypto.tink.subtle.Hkdf;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;
import org.sparkproject.guava.annotations.VisibleForTesting;

class TransportCipherUtil {
    TransportCipherUtil() {
    }

    @VisibleForTesting
    static String getKeyId(SecretKeySpec key) throws GeneralSecurityException {
        byte[] keyIdBytes = Hkdf.computeHkdf((String)"HmacSha256", (byte[])key.getEncoded(), null, (byte[])"keyID".getBytes(StandardCharsets.UTF_8), (int)32);
        return Hex.encode((byte[])keyIdBytes);
    }
}

