/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    This function returns -1 for null input only if spark.sql.ansi.enabled is false and\n    spark.sql.legacy.sizeOfNull is true. Otherwise, it returns null for null input.\n    With the default settings, the function returns null for null input.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n  ", since="1.5.0", group="collection_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u0010 \u00012B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015I\u0007\u0001\"\u0011N\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\tI\u0001\u0001C)\u0003\u0017A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u0011%\t9\u0004AA\u0001\n\u0003\nI\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0001\u0002N!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003;\u0002\u0011\u0011!C!\u0003?B\u0011\"!\u001c\u0001\u0003\u0003%\t!a\u001c\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u000f\u001d\tyj\bE\u0001\u0003C3aAH\u0010\t\u0002\u0005\r\u0006B\u0002*\u0019\t\u0003\t)\fC\u0004\u00028b!\t!!/\t\u0013\u0005]\u0006$!A\u0005\u0002\u0006u\u0006\"CAb1\u0005\u0005I\u0011QAc\u0011%\t9\u000eGA\u0001\n\u0013\tIN\u0001\u0003TSj,'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001i\u0013\u0007\u000e\u001e\u0011\u00059zS\"A\u0010\n\u0005Az\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\u0012\u0014BA\u001a \u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\b!J|G-^2u!\tY4I\u0004\u0002=\u0003:\u0011Q\bQ\u0007\u0002})\u0011qhK\u0001\u0007yI|w\u000e\u001e \n\u0003]J!A\u0011\u001c\u0002\u000fA\f7m[1hK&\u0011A)\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0005Z\nQa\u00195jY\u0012,\u0012\u0001\u0013\t\u0003]%K!AS\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0011Y\u0016<\u0017mY=TSj,wJ\u001a(vY2,\u0012A\u0014\t\u0003k=K!\u0001\u0015\u001c\u0003\u000f\t{w\u000e\\3b]\u0006\tB.Z4bGf\u001c\u0016N_3PM:+H\u000e\u001c\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003]\u0001AQAR\u0003A\u0002!CQ\u0001T\u0003A\u00029#\"\u0001\u0016-\t\u000b\u00193\u0001\u0019\u0001%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u000e\nQ\u0001^=qKNL!\u0001Y/\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\u0007cA\u001eeM&\u0011Q-\u0012\u0002\u0004'\u0016\f\bC\u0001/h\u0013\tAWL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0003fm\u0006dGC\u00017p!\t)T.\u0003\u0002om\t\u0019\u0011I\\=\t\u000fAT\u0001\u0013!a\u0001c\u0006)\u0011N\u001c9viB\u0011!o]\u0007\u0002C%\u0011A/\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR!q/`A\u0003!\tA80D\u0001z\u0015\tQx$A\u0004d_\u0012,w-\u001a8\n\u0005qL(\u0001C#yaJ\u001cu\u000eZ3\t\u000by\\\u0001\u0019A@\u0002\u0007\r$\b\u0010E\u0002y\u0003\u0003I1!a\u0001z\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0002\f\u0001\u00049\u0018AA3w\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019A+!\u0004\t\r\u0005=A\u00021\u0001I\u0003!qWm^\"iS2$\u0017\u0001B2paf$R\u0001VA\u000b\u0003/AqAR\u0007\u0011\u0002\u0003\u0007\u0001\nC\u0004M\u001bA\u0005\t\u0019\u0001(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0004\u0016\u0004\u0011\u0006}1FAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-b'\u0001\u0006b]:|G/\u0019;j_:LA!a\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0007\u0016\u0004\u001d\u0006}\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00027b]\u001eT!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyD\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001f\u00022!NA)\u0013\r\t\u0019F\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004Y\u0006e\u0003\"CA.%\u0005\u0005\t\u0019AA(\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\r\t\u0006\u0003G\nI\u0007\\\u0007\u0003\u0003KR1!a\u001a7\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\n)G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001(\u0002r!A\u00111\f\u000b\u0002\u0002\u0003\u0007A.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u001e\u0003oB\u0011\"a\u0017\u0016\u0003\u0003\u0005\r!a\u0014\u0002\r\u0015\fX/\u00197t)\rq\u0015Q\u0010\u0005\t\u000372\u0012\u0011!a\u0001Y\"\u001a\u0002!!!\u0002\b\u0006%\u0015QRAH\u0003'\u000b)*!'\u0002\u001cB\u0019a&a!\n\u0007\u0005\u0015uDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0015A!\u001a\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001b>fA=4\u0007%\u00198!CJ\u0014\u0018-\u001f\u0011pe\u0002\n\u0007%\\1q])\u0001\u0003\u0005\t\u0011UQ&\u001c\bEZ;oGRLwN\u001c\u0011sKR,(O\\:![E\u0002cm\u001c:!]VdG\u000eI5oaV$\be\u001c8ms\u0002Jg\rI:qCJ\\gf]9m]\u0005t7/\u001b\u0018f]\u0006\u0014G.\u001a3!SN\u0004c-\u00197tK\u0002\ng\u000e\u001a\u0006!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018mK\u001e\f7-\u001f\u0018tSj,wJ\u001a(vY2\u0004\u0013n\u001d\u0011ueV,g\u0006I(uQ\u0016\u0014x/[:fY\u0001JG\u000f\t:fiV\u0014hn\u001d\u0011ok2d\u0007EZ8sA9,H\u000e\u001c\u0011j]B,HO\f\u0006!A\u0001\u0002s+\u001b;iAQDW\r\t3fM\u0006,H\u000e\u001e\u0011tKR$\u0018N\\4tY\u0001\"\b.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rW\u000f\u001c7!M>\u0014\bE\\;mY\u0002Jg\u000e];u])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t*AA\u0002\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001d\u0012w\u0005\f\u0011(I\u001eb\u0003eJ2(Y\u0001:\u0013mJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\"$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\":\u0013m\n\u0017!c1\u0002sEY\u0014-AIJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAL\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\ti*\u0001\td_2dWm\u0019;j_:|f-\u001e8dg\u0006!1+\u001b>f!\tq\u0003dE\u0003\u0019\u0003K\u000bY\u000bE\u00026\u0003OK1!!+7\u0005\u0019\te.\u001f*fMB!\u0011QVAZ\u001b\t\tyK\u0003\u0003\u00022\u0006\r\u0013AA5p\u0013\r!\u0015q\u0016\u000b\u0003\u0003C\u000bQ!\u00199qYf$2\u0001VA^\u0011\u00151%\u00041\u0001I)\u0015!\u0016qXAa\u0011\u001515\u00041\u0001I\u0011\u0015a5\u00041\u0001O\u0003\u001d)h.\u00199qYf$B!a2\u0002TB)Q'!3\u0002N&\u0019\u00111\u001a\u001c\u0003\r=\u0003H/[8o!\u0015)\u0014q\u001a%O\u0013\r\t\tN\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005UG$!AA\u0002Q\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u000e\u0005\u0003\u0002>\u0005u\u0017\u0002BAp\u0003\u007f\u0011aa\u00142kK\u000e$\b")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Tuple2<Expression, Object>> unapply(Size x$0) {
        return Size$.MODULE$.unapply(x$0);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        if (this.legacySizeOfNull()) {
            return false;
        }
        return super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            if (this.legacySizeOfNull()) {
                return BoxesRunTime.boxToInteger((int)-1);
            }
            return null;
        }
        DataType dataType = this.child().dataType();
        if (dataType instanceof ArrayType) {
            return BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
        }
        if (dataType instanceof MapType) {
            return BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedOperandTypeForSizeFunctionError(dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numElements()");
    }

    @Override
    public Size withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Size copy(Expression child, boolean legacySizeOfNull) {
        return new Size(child, legacySizeOfNull);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.legacySizeOfNull();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacySizeOfNull());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "legacySizeOfNull";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        if (this.legacySizeOfNull() != size.legacySizeOfNull()) return false;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child, boolean legacySizeOfNull) {
        this.child = child;
        this.legacySizeOfNull = legacySizeOfNull;
        ExpectsInputTypes.$init$(this);
    }

    public Size(Expression child) {
        this(child, SQLConf$.MODULE$.get().legacySizeOfNull());
    }
}

