/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns a sha1 hash value as a hex string of the `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark');\n       85f5955f4b27a9a4c2aab6ffe5d7189fc298b92c\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\u000b\u0001C!)\")a\f\u0001C)?\")Q\r\u0001C!M\")A\u000f\u0001C)k\"9\u0001\u0010AA\u0001\n\u0003I\bbB>\u0001#\u0003%\t\u0001 \u0005\n\u0003\u001f\u0001\u0011\u0011!C!\u0003#A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001b\u0001\u0005\u0005I\u0011IA\u001c\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00131K\u0004\n\u0003oR\u0012\u0011!E\u0001\u0003s2\u0001\"\u0007\u000e\u0002\u0002#\u0005\u00111\u0010\u0005\u0007\u0015N!\t!a%\t\u0013\u0005U5#!A\u0005F\u0005]\u0005\"CAM'\u0005\u0005I\u0011QAN\u0011%\tyjEA\u0001\n\u0003\u000b\t\u000bC\u0005\u0002.N\t\t\u0011\"\u0003\u00020\n!1\u000b[12\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011C\u0002\u0001)Y=\u0012\u0004\b\u0005\u0002*U5\t!$\u0003\u0002,5\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002*[%\u0011aF\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\u0006M\u0005\u0003ci\u0011\u0001\u0005R3gCVdGo\u0015;sS:<\u0007K]8ek\u000eLgnZ#yaJ,7o]5p]B\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9\u0001K]8ek\u000e$\bCA\u001dB\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>M\u00051AH]8pizJ\u0011!N\u0005\u0003\u0001R\nq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\tN\u0001\u0006G\"LG\u000eZ\u000b\u0002\rB\u0011\u0011fR\u0005\u0003\u0011j\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"\u0001T'\u0011\u0005%\u0002\u0001\"\u0002#\u0004\u0001\u00041\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002!B\u00111'U\u0005\u0003%R\u0012qAQ8pY\u0016\fg.\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0016\t\u0004sYC\u0016BA,D\u0005\r\u0019V-\u001d\t\u00033rk\u0011A\u0017\u0006\u00037z\tQ\u0001^=qKNL!!\u0018.\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAB\\;mYN\u000bg-Z#wC2$\"\u0001Y2\u0011\u0005M\n\u0017B\u000125\u0005\r\te.\u001f\u0005\u0006I\u001a\u0001\r\u0001Y\u0001\u0006S:\u0004X\u000f^\u0001\nI><UM\\\"pI\u0016$2aZ7s!\tA7.D\u0001j\u0015\tQ'$A\u0004d_\u0012,w-\u001a8\n\u00051L'\u0001C#yaJ\u001cu\u000eZ3\t\u000b9<\u0001\u0019A8\u0002\u0007\r$\b\u0010\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0019x\u00011\u0001h\u0003\t)g/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003\u0019ZDQa\u001e\u0005A\u0002\u0019\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Mu\"9A)\u0003I\u0001\u0002\u00041\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002{*\u0012aI`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tI\u0001N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006LA!!\t\u0002\u0018\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\n\u0011\u0007M\nI#C\u0002\u0002,Q\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001YA\u0019\u0011%\t\u0019$DA\u0001\u0002\u0004\t9#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0001R!a\u000f\u0002B\u0001l!!!\u0010\u000b\u0007\u0005}B'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0011\u0002>\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0016\u0011\n\u0005\t\u0003gy\u0011\u0011!a\u0001A\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019\"a\u0014\t\u0013\u0005M\u0002#!AA\u0002\u0005\u001d\u0012AB3rk\u0006d7\u000fF\u0002Q\u0003+B\u0001\"a\r\u0012\u0003\u0003\u0005\r\u0001\u0019\u0015\u0014\u0001\u0005e\u0013qLA1\u0003K\n9'a\u001b\u0002n\u0005E\u00141\u000f\t\u0004S\u0005m\u0013bAA/5\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA2\u0003\u001d{f)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011tQ\u0006\f\u0004\u0005[1tQ\u00022\u0018\r\\;fA\u0005\u001c\b%\u0019\u0011iKb\u00043\u000f\u001e:j]\u001e\u0004sN\u001a\u0011uQ\u0016\u0004\u0003-\u001a=qe\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005%\u0014!\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003(\u000e46sU*d\r\u000e23o\u0005L\u0014\rN23C\u0006\u0014gG\u001a4fk\u0011<\u0014\u0007O\u001dgGJJ\u0004HY\u001d3G*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002p\u0005)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011QO\u0001\u000bQ\u0006\u001c\bn\u00184v]\u000e\u001c\u0018\u0001B*iCF\u0002\"!K\n\u0014\u000bM\ti(!#\u0011\r\u0005}\u0014Q\u0011$M\u001b\t\t\tIC\u0002\u0002\u0004R\nqA];oi&lW-\u0003\u0003\u0002\b\u0006\u0005%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006m\u0011AA5p\u0013\r\u0011\u0015Q\u0012\u000b\u0003\u0003s\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\tQ!\u00199qYf$2\u0001TAO\u0011\u0015!e\u00031\u0001G\u0003\u001d)h.\u00199qYf$B!a)\u0002*B!1'!*G\u0013\r\t9\u000b\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005-v#!AA\u00021\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\f\u0005\u0003\u0002\u0016\u0005M\u0016\u0002BA[\u0003/\u0011aa\u00142kK\u000e$\b")
public class Sha1
extends UnaryExpression
implements ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Sha1 x$0) {
        return Sha1$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sha1, A> g) {
        return Sha1$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Sha1> compose(Function1<A$, Expression> g) {
        return Sha1$.MODULE$.compose(g);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object input) {
        return UTF8String.fromString((String)DigestUtils.sha1Hex((byte[])((byte[])input)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "UTF8String.fromString(" + DigestUtils.class.getName() + ".sha1Hex(" + c + "))");
    }

    @Override
    public Sha1 withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Sha1 copy(Expression child) {
        return new Sha1(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sha1";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha1;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha1)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha1 sha1 = (Sha1)x$1;
        Expression expression = this.child();
        Expression expression2 = sha1.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sha1.canEqual(this)) return false;
        return true;
    }

    public Sha1(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

