/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([years[, months[, weeks[, days[, hours[, mins[, secs]]]]]]]) - Make interval from years, months, weeks, days, hours, mins and secs.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n      * weeks - the number of weeks, positive or negative\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(100, 11, 1, 1, 12, 30, 01.001001);\n       100 years 11 months 8 days 12 hours 30 minutes 1.001001 seconds\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n      > SELECT _FUNC_(0, 1, 0, 1, 0, 0, 100.000001);\n       1 months 1 days 1 minutes 40.000001 seconds\n  ", since="3.0.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-h\u0001\u0002\u001f>\u0001*C\u0001\u0002\u001a\u0001\u0003\u0016\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0012)A\u0005M\"A!\u000e\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005l\u0001\tE\t\u0015!\u0003g\u0011!a\u0007A!f\u0001\n\u0003)\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00024\t\u00119\u0004!Q3A\u0005\u0002\u0015D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006IA\u001a\u0005\ta\u0002\u0011)\u001a!C\u0001K\"A\u0011\u000f\u0001B\tB\u0003%a\r\u0003\u0005s\u0001\tU\r\u0011\"\u0001f\u0011!\u0019\bA!E!\u0002\u00131\u0007\u0002\u0003;\u0001\u0005+\u0007I\u0011A3\t\u0011U\u0004!\u0011#Q\u0001\n\u0019D\u0001B\u001e\u0001\u0003\u0016\u0004%\ta\u001e\u0005\tw\u0002\u0011\t\u0012)A\u0005q\")A\u0010\u0001C\u0001{\"1\u0011q\u0002\u0001\u0005B]Da\u0001 \u0001\u0005\u0002\u0005E\u0001B\u0002?\u0001\t\u0003\t\u0019\u0003\u0003\u0004}\u0001\u0011\u0005\u0011\u0011\u0007\u0005\u0007y\u0002!\t!!\u0010\t\rq\u0004A\u0011AA$\u0011\u0019a\b\u0001\"\u0001\u0002P!1A\u0010\u0001C\u0001\u0003+Ba\u0001 \u0001\u0005\u0002\u0005e\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\t9\b\u0001C!\u0003sBa!!!\u0001\t\u0003:\bbBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\tY\r\u0001C!\u0003\u001bDq!a8\u0001\t#\n\t\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0001\u0002p\"I!\u0011\u0001\u0001\u0012\u0002\u0013\u0005!1\u0001\u0005\n\u00053\u0001\u0011\u0013!C\u0001\u0005\u0007A\u0011Ba\u0007\u0001#\u0003%\tAa\u0001\t\u0013\tu\u0001!%A\u0005\u0002\t\r\u0001\"\u0003B\u0010\u0001E\u0005I\u0011\u0001B\u0002\u0011%\u0011\t\u0003AI\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003$\u0001\t\n\u0011\"\u0001\u0003\u0004!I!Q\u0005\u0001\u0012\u0002\u0013\u0005!q\u0005\u0005\n\u0005W\u0001\u0011\u0011!C!\u0005[A\u0011B!\u0010\u0001\u0003\u0003%\tAa\u0010\t\u0013\t\u001d\u0003!!A\u0005\u0002\t%\u0003\"\u0003B(\u0001\u0005\u0005I\u0011\tB)\u0011%\u0011y\u0006AA\u0001\n\u0003\u0011\t\u0007C\u0005\u0003f\u0001\t\t\u0011\"\u0011\u0003h!I!1\u000e\u0001\u0002\u0002\u0013\u0005#QN\u0004\n\u0005/k\u0014\u0011!E\u0001\u000533\u0001\u0002P\u001f\u0002\u0002#\u0005!1\u0014\u0005\u0007yR\"\tAa-\t\u0013\tUF'!A\u0005F\t]\u0006\"\u0003B]i\u0005\u0005I\u0011\u0011B^\u0011%\u0011i\rNI\u0001\n\u0003\u00119\u0003C\u0005\u0003PR\n\t\u0011\"!\u0003R\"I!q\u001c\u001b\u0012\u0002\u0013\u0005!q\u0005\u0005\n\u0005C$\u0014\u0011!C\u0005\u0005G\u0014A\"T1lK&sG/\u001a:wC2T!AP \u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0001\u0006\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0005\u000e\u000b1a]9m\u0015\t!U)A\u0003ta\u0006\u00148N\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<7\u0001A\n\u0006\u0001-{%\u000b\u0017\t\u0003\u00196k\u0011!P\u0005\u0003\u001dv\u00121cU3qi\u0016t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u0014)\n\u0005Ek$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011,\u0019\b\u00035~s!a\u00170\u000e\u0003qS!!X%\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0016B\u00011U\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0001$\u0016!B=fCJ\u001cX#\u00014\u0011\u00051;\u0017B\u00015>\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007s\u0016\f'o\u001d\u0011\u0002\r5|g\u000e\u001e5t\u0003\u001diwN\u001c;ig\u0002\nQa^3fWN\faa^3fWN\u0004\u0013\u0001\u00023bsN\fQ\u0001Z1zg\u0002\nQ\u0001[8veN\fa\u0001[8veN\u0004\u0013\u0001B7j]N\fQ!\\5og\u0002\nAa]3dg\u0006)1/Z2tA\u0005Ya-Y5m\u001f:,%O]8s+\u0005A\bCA*z\u0013\tQHKA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)Aqx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u0002M\u0001!)A-\u0005a\u0001M\")!.\u0005a\u0001M\")A.\u0005a\u0001M\")a.\u0005a\u0001M\")\u0001/\u0005a\u0001M\")!/\u0005a\u0001M\")A/\u0005a\u0001M\"9a/\u0005I\u0001\u0002\u0004A\u0018A\u00048vY2Le\u000e^8mKJ\fg\u000e\u001e\u000b\u0010}\u0006M\u0011QCA\f\u00033\tY\"!\b\u0002 !)Am\u0005a\u0001M\")!n\u0005a\u0001M\")An\u0005a\u0001M\")an\u0005a\u0001M\")\u0001o\u0005a\u0001M\")!o\u0005a\u0001M\"1\u0011\u0011E\nA\u0002\u0019\f1a]3d)5q\u0018QEA\u0014\u0003S\tY#!\f\u00020!)A\r\u0006a\u0001M\")!\u000e\u0006a\u0001M\")A\u000e\u0006a\u0001M\")a\u000e\u0006a\u0001M\")\u0001\u000f\u0006a\u0001M\")!\u000f\u0006a\u0001MRYa0a\r\u00026\u0005]\u0012\u0011HA\u001e\u0011\u0015!W\u00031\u0001g\u0011\u0015QW\u00031\u0001g\u0011\u0015aW\u00031\u0001g\u0011\u0015qW\u00031\u0001g\u0011\u0015\u0001X\u00031\u0001g)%q\u0018qHA!\u0003\u0007\n)\u0005C\u0003e-\u0001\u0007a\rC\u0003k-\u0001\u0007a\rC\u0003m-\u0001\u0007a\rC\u0003o-\u0001\u0007a\rF\u0004\u007f\u0003\u0013\nY%!\u0014\t\u000b\u0011<\u0002\u0019\u00014\t\u000b)<\u0002\u0019\u00014\t\u000b1<\u0002\u0019\u00014\u0015\u000by\f\t&a\u0015\t\u000b\u0011D\u0002\u0019\u00014\t\u000b)D\u0002\u0019\u00014\u0015\u0007y\f9\u0006C\u0003e3\u0001\u0007a\rF\u0001\u007f\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA0!\u0011I\u0016\u0011\r4\n\u0007\u0005\r4MA\u0002TKF\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tI\u0007E\u0003Z\u0003C\nY\u0007\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t(Q\u0001\u0006if\u0004Xm]\u0005\u0005\u0003k\nyG\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002|A!\u0011QNA?\u0013\u0011\ty(a\u001c\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0011\u0003\u000f\u000bi)!%\u0002\u0016\u0006e\u0015QTAQ\u0003K\u00032aUAE\u0013\r\tY\t\u0016\u0002\u0004\u0003:L\bbBAH?\u0001\u0007\u0011qQ\u0001\u0005s\u0016\f'\u000fC\u0004\u0002\u0014~\u0001\r!a\"\u0002\u000b5|g\u000e\u001e5\t\u000f\u0005]u\u00041\u0001\u0002\b\u0006!q/Z3l\u0011\u001d\tYj\ba\u0001\u0003\u000f\u000b1\u0001Z1z\u0011\u001d\tyj\ba\u0001\u0003\u000f\u000bA\u0001[8ve\"9\u00111U\u0010A\u0002\u0005\u001d\u0015aA7j]\"9\u0011\u0011E\u0010A\u0002\u0005\u001d\u0006#B*\u0002*\u0006\u001d\u0015bAAV)\n1q\n\u001d;j_:\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005E\u0016QXAd!\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\{\u000591m\u001c3fO\u0016t\u0017\u0002BA^\u0003k\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u007f\u0003\u0003\u0019AAa\u0003\r\u0019G\u000f\u001f\t\u0005\u0003g\u000b\u0019-\u0003\u0003\u0002F\u0006U&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0013\u0004\u0003\u0019AAY\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a4\u0011\t\u0005E\u0017\u0011\u001c\b\u0005\u0003'\f)\u000e\u0005\u0002\\)&\u0019\u0011q\u001b+\u0002\rA\u0013X\rZ3g\u0013\u0011\tY.!8\u0003\rM#(/\u001b8h\u0015\r\t9\u000eV\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2A`Ar\u0011\u001d\t)O\ta\u0001\u0003O\f1B\\3x\u0007\"LG\u000e\u001a:f]B!\u0011,!;g\u0013\r\tYo\u0019\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$\u0012C`Ay\u0003g\f)0a>\u0002z\u0006m\u0018Q`A\u0000\u0011\u001d!7\u0005%AA\u0002\u0019DqA[\u0012\u0011\u0002\u0003\u0007a\rC\u0004mGA\u0005\t\u0019\u00014\t\u000f9\u001c\u0003\u0013!a\u0001M\"9\u0001o\tI\u0001\u0002\u00041\u0007b\u0002:$!\u0003\u0005\rA\u001a\u0005\bi\u000e\u0002\n\u00111\u0001g\u0011\u001d18\u0005%AA\u0002a\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0006)\u001aaMa\u0002,\u0005\t%\u0001\u0003\u0002B\u0006\u0005+i!A!\u0004\u000b\t\t=!\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0005U\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005/\u0011iAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"A!\u000b+\u0007a\u00149!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005_\u0001BA!\r\u0003<5\u0011!1\u0007\u0006\u0005\u0005k\u00119$\u0001\u0003mC:<'B\u0001B\u001d\u0003\u0011Q\u0017M^1\n\t\u0005m'1G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u0003\u00022a\u0015B\"\u0013\r\u0011)\u0005\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\u0013Y\u0005C\u0005\u0003N9\n\t\u00111\u0001\u0003B\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0015\u0011\r\tU#1LAD\u001b\t\u00119FC\u0002\u0003ZQ\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iFa\u0016\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004q\n\r\u0004\"\u0003B'a\u0005\u0005\t\u0019AAD\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t=\"\u0011\u000e\u0005\n\u0005\u001b\n\u0014\u0011!a\u0001\u0005\u0003\na!Z9vC2\u001cHc\u0001=\u0003p!I!Q\n\u001a\u0002\u0002\u0003\u0007\u0011q\u0011\u0015\u0018\u0001\tM$\u0011\u0010B>\u0005\u007f\u0012\tI!\"\u0003\b\n-%Q\u0012BI\u0005'\u00032\u0001\u0014B;\u0013\r\u00119(\u0010\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011i(AA\u000b?\u001a+fjQ0)7f,\u0017M]:\\Y\u0001jwN\u001c;ignc\u0003e^3fWN\\F\u0006\t3bsN\\F\u0006\t5pkJ\u001c8\f\f\u0011nS:\u001c8\f\f\u0011tK\u000e\u001cX,X/^;vk\u0016\u0006I\u0017!\u001b\u0006\\W\rI5oi\u0016\u0014h/\u00197!MJ|W\u000eI=fCJ\u001cH\u0006I7p]RD7\u000f\f\u0011xK\u0016\\7\u000f\f\u0011eCf\u001cH\u0006\t5pkJ\u001cH\u0006I7j]N\u0004\u0013M\u001c3!g\u0016\u001c7OL\u0001\nCJ<W/\\3oiN\f#Aa!\u0002\u0007\u001fS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I=fCJ\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011zK\u0006\u00148\u000f\f\u0011q_NLG/\u001b<fA=\u0014\bE\\3hCRLg/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f[:![\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002jwN\u001c;ig2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003e^3fWN\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI<fK.\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCf\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011eCf\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011i_V\u00148\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!Q>,(o\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A5Lgn\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gA5Lg.\u001e;fg2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003e]3dg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007e]3d_:$7\u000fI<ji\"\u0004C\u000f[3!MJ\f7\r^5p]\u0006d\u0007\u0005]1si\u0002Jg\u000eI7jGJ|7/Z2p]\u0012\u0004\u0003O]3dSNLwN\u001c\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0013\u000b!Q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cA\u0002D\u0006I\u00192Y\u0001\nD\u0006I\u0019-AE\u0012D\u0006I\u001a1Y\u0001\u0002\u0014G\f\u00191cA\u0002\u0014'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cA\u0002\u0004%_3beN\u0004\u0013'\r\u0011n_:$\bn\u001d\u00119A\u0011\f\u0017p\u001d\u00112e\u0001Bw.\u001e:tAM\u0002\u0004%\\5okR,7\u000fI\u0019/aA\n\u0004\u0007M\u0019!g\u0016\u001cwN\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\r\u0017!]VdG\u000e\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002D\u0006I\u0019-AAb\u0003%\r\u0017!a1\u0002\u0003\u0007\f\u00112aAr\u0003\u0007\r\u00191aEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019![>tG\u000f[:!c\u0001\"\u0017-_:!c\u0001j\u0017N\\;uKN\u0004C\u0007\r\u00181aA\u0002\u0004'\r\u0011tK\u000e|g\u000eZ:\u000bA\u0001\nQa]5oG\u0016\f#Aa$\u0002\u000bMr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tU\u0015A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\r\u001b\u0006\\W-\u00138uKJ4\u0018\r\u001c\t\u0003\u0019R\u001aR\u0001\u000eBO\u0005S\u0003RBa(\u0003&\u001a4gM\u001a4gMbtXB\u0001BQ\u0015\r\u0011\u0019\u000bV\u0001\beVtG/[7f\u0013\u0011\u00119K!)\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\b\u0005\u0003\u0003,\nEVB\u0001BW\u0015\u0011\u0011yKa\u000e\u0002\u0005%|\u0017b\u00012\u0003.R\u0011!\u0011T\u0001\ti>\u001cFO]5oOR\u0011!qF\u0001\u0006CB\u0004H.\u001f\u000b\u0012}\nu&q\u0018Ba\u0005\u0007\u0014)Ma2\u0003J\n-\u0007\"\u000238\u0001\u00041\u0007\"\u000268\u0001\u00041\u0007\"\u000278\u0001\u00041\u0007\"\u000288\u0001\u00041\u0007\"\u000298\u0001\u00041\u0007\"\u0002:8\u0001\u00041\u0007\"\u0002;8\u0001\u00041\u0007b\u0002<8!\u0003\u0005\r\u0001_\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u00059QO\\1qa2LH\u0003\u0002Bj\u00057\u0004RaUAU\u0005+\u00042b\u0015BlM\u001a4gM\u001a4gq&\u0019!\u0011\u001c+\u0003\rQ+\b\u000f\\39\u0011!\u0011i.OA\u0001\u0002\u0004q\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!:\u0011\t\tE\"q]\u0005\u0005\u0005S\u0014\u0019D\u0001\u0004PE*,7\r\u001e")
public class MakeInterval
extends SeptenaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression years;
    private final Expression months;
    private final Expression weeks;
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$8() {
        return MakeInterval$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>> unapply(MakeInterval x$0) {
        return MakeInterval$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$8() {
        return MakeInterval$.MODULE$.apply$default$8();
    }

    public static Function1<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>, MakeInterval> tupled() {
        return MakeInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeInterval>>>>>>>> curried() {
        return MakeInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    public Expression weeks() {
        return this.weeks;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.years(), (List)new .colon.colon((Object)this.months(), (List)new .colon.colon((Object)this.weeks(), (List)new .colon.colon((Object)this.days(), (List)new .colon.colon((Object)this.hours(), (List)new .colon.colon((Object)this.mins(), (List)new .colon.colon((Object)this.secs(), (List)Nil$.MODULE$)))))));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6), (List)Nil$.MODULE$)))))));
    }

    @Override
    public DataType dataType() {
        return CalendarIntervalType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        if (this.failOnError()) {
            return this.children().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nullable()));
        }
        return true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object week, Object day, Object hour, Object min, Option<Object> sec) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = IntervalUtils$.MODULE$.makeInterval(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)week), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec.map((Function1 & Serializable)x$2 -> (Decimal)x$2).getOrElse((Function0 & Serializable)() -> Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        }
        catch (ArithmeticException e) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.arithmeticOverflowError(e.getMessage(), QueryExecutionErrors$.MODULE$.arithmeticOverflowError$default$2(), QueryExecutionErrors$.MODULE$.arithmeticOverflowError$default$3());
            }
            calendarInterval = null;
        }
        return calendarInterval;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable)(year, month, week, day, hour, min, sec) -> {
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName()), "$");
            String secFrac = (String)sec.getOrElse((Function0 & Serializable)() -> "0");
            String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.arithmeticOverflowError(e.getMessage(), \"\", null);" : ev.isNull() + " = true;";
            return "\n        try {\n          " + ev.value() + " = " + iu + ".makeInterval(" + year + ", " + month + ", " + week + ", " + day + ", " + hour + ", " + min + ", " + secFrac + ");\n        } catch (java.lang.ArithmeticException e) {\n          " + failOnErrorBranch + "\n        }\n      ";
        });
    }

    @Override
    public String prettyName() {
        return "make_interval";
    }

    @Override
    public MakeInterval withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Expression)newChildren.apply(6), this.copy$default$8());
    }

    public MakeInterval copy(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        return new MakeInterval(years, months, weeks, days, hours, mins, secs, failOnError);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    public Expression copy$default$3() {
        return this.weeks();
    }

    public Expression copy$default$4() {
        return this.days();
    }

    public Expression copy$default$5() {
        return this.hours();
    }

    public Expression copy$default$6() {
        return this.mins();
    }

    public Expression copy$default$7() {
        return this.secs();
    }

    public boolean copy$default$8() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeInterval";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.years();
            }
            case 1: {
                return this.months();
            }
            case 2: {
                return this.weeks();
            }
            case 3: {
                return this.days();
            }
            case 4: {
                return this.hours();
            }
            case 5: {
                return this.mins();
            }
            case 6: {
                return this.secs();
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeInterval;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "years";
            }
            case 1: {
                return "months";
            }
            case 2: {
                return "weeks";
            }
            case 3: {
                return "days";
            }
            case 4: {
                return "hours";
            }
            case 5: {
                return "mins";
            }
            case 6: {
                return "secs";
            }
            case 7: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeInterval makeInterval = (MakeInterval)x$1;
        if (this.failOnError() != makeInterval.failOnError()) return false;
        Expression expression = this.years();
        Expression expression2 = makeInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.weeks();
        Expression expression6 = makeInterval.weeks();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.days();
        Expression expression8 = makeInterval.days();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.hours();
        Expression expression10 = makeInterval.hours();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.mins();
        Expression expression12 = makeInterval.mins();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Expression expression13 = this.secs();
        Expression expression14 = makeInterval.secs();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (!makeInterval.canEqual(this)) return false;
        return true;
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression sec) {
        this(years, months, weeks, days, hours, mins, sec, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins) {
        this(years, months, weeks, days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours) {
        this(years, months, weeks, days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days) {
        this(years, months, weeks, days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks) {
        this(years, months, weeks, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months) {
        this(years, months, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

