/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvedProjectList;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.AggregateHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.UnaryNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00154AAC\u0006\u00015!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001di\u0004A1A\u0005\nyBaA\u0011\u0001!\u0002\u0013y\u0004bB\"\u0001\u0005\u0004%I\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\u000b%\u0003A\u0011\t&\t\u000b5\u0003A\u0011\u0002(\u0003\u001fA\u0013xN[3diJ+7o\u001c7wKJT!\u0001D\u0007\u0002\u0011I,7o\u001c7wKJT!AD\b\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001E\t\u0002\u0011\r\fG/\u00197zgRT!AE\n\u0002\u0007M\fHN\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB!!eI\u0013.\u001b\u0005Y\u0011B\u0001\u0013\f\u0005A!&/Z3O_\u0012,'+Z:pYZ,'\u000f\u0005\u0002'W5\tqE\u0003\u0002)S\u00059An\\4jG\u0006d'B\u0001\u0016\u0010\u0003\u0015\u0001H.\u00198t\u0013\tasEA\u0004Qe>TWm\u0019;\u0011\u0005\u0019r\u0013BA\u0018(\u0005-aunZ5dC2\u0004F.\u00198\u0002!=\u0004XM]1u_J\u0014Vm]8mm\u0016\u0014\bC\u0001\u00123\u0013\t\u00194B\u0001\u0005SKN|GN^3s\u0003I)\u0007\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0011\u0005\t2\u0014BA\u001c\f\u0005I)\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0002\rqJg.\u001b;?)\rQ4\b\u0010\t\u0003E\u0001AQ\u0001M\u0002A\u0002EBQ\u0001N\u0002A\u0002U\nA\"[:MG\u0006,e.\u00192mK\u0012,\u0012a\u0010\t\u00039\u0001K!!Q\u000f\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n\u001d'dC\u0016s\u0017M\u00197fI\u0002\naa]2pa\u0016\u001cX#A#\u0011\u0005\t2\u0015BA$\f\u00059q\u0015-\\3TG>\u0004Xm\u0015;bG.\fqa]2pa\u0016\u001c\b%A\u0004sKN|GN^3\u0015\u00055Z\u0005\"\u0002'\t\u0001\u0004)\u0013!E;oe\u0016\u001cx\u000e\u001c<fIB\u0013xN[3di\u0006a\"-^5mIB\u0013xN[3di^KG\u000f\u001b*fg>dg/\u001a3M\u0007\u0006\u001bHcA\u0013P#\")\u0001+\u0003a\u0001[\u0005i!/Z:pYZ,Gm\u00115jY\u0012DQAU\u0005A\u0002M\u000b1c\u001c:jO&t\u0017\r\u001c)s_*,7\r\u001e'jgR\u00042\u0001\u0016/`\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y3\u00051AH]8pizJ\u0011AH\u0005\u00037v\tq\u0001]1dW\u0006<W-\u0003\u0002^=\n\u00191+Z9\u000b\u0005mk\u0002C\u00011d\u001b\u0005\t'B\u00012\u0010\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005\u0011\f'a\u0004(b[\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8")
public class ProjectResolver
implements TreeNodeResolver<Project, LogicalPlan> {
    private final Resolver operatorResolver;
    private final ExpressionResolver expressionResolver;
    private final boolean isLcaEnabled;
    private final NameScopeStack scopes;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private boolean isLcaEnabled() {
        return this.isLcaEnabled;
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    @Override
    public LogicalPlan resolve(Project unresolvedProject) {
        Tuple2 tuple2 = (Tuple2)this.scopes().withNewScope((Function0 & Serializable)() -> {
            LogicalPlan resolvedChild = $this.operatorResolver.resolve(unresolvedProject.child());
            ResolvedProjectList resolvedProjectList = $this.expressionResolver.resolveProjectList(unresolvedProject.projectList(), unresolvedProject);
            if (resolvedProjectList.hasAggregateExpressions()) {
                if (resolvedProjectList.hasLateralColumnAlias()) {
                    throw new ExplicitlyUnsupportedResolverFeature("LateralColumnAlias in Aggregate");
                }
                Aggregate aggregate = new Aggregate((Seq<Expression>)((Seq)scala.package$.MODULE$.Seq().empty()), resolvedProjectList.expressions(), resolvedChild, (Option<AggregateHint>)None$.MODULE$);
                if (resolvedProjectList.hasAttributes()) {
                    throw package$.MODULE$.AnalysisErrorAt(aggregate).failAnalysis("MISSING_GROUP_BY", (Map<String, String>)Predef$.MODULE$.Map().empty());
                }
                return new Tuple2((Object)aggregate, (Object)resolvedProjectList);
            }
            Project projectWithLca = this.isLcaEnabled() ? this.buildProjectWithResolvedLCAs(resolvedChild, resolvedProjectList.expressions()) : new Project(resolvedProjectList.expressions(), resolvedChild);
            return new Tuple2((Object)projectWithLca, (Object)resolvedProjectList);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UnaryNode resolvedOperator = (UnaryNode)tuple2._1();
        ResolvedProjectList resolvedProjectList = (ResolvedProjectList)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resolvedOperator, (Object)resolvedProjectList);
        UnaryNode resolvedOperator2 = (UnaryNode)tuple22._1();
        ResolvedProjectList resolvedProjectList2 = (ResolvedProjectList)tuple22._2();
        package$.MODULE$.withPosition(unresolvedProject, (JFunction0.mcV.sp & Serializable)() -> this.scopes().overwriteTop((Seq<Attribute>)((Seq)resolvedProjectList2.expressions().map((Function1 & Serializable)namedExpression -> namedExpression.toAttribute()))));
        return (LogicalPlan)((Object)resolvedOperator2);
    }

    private Project buildProjectWithResolvedLCAs(LogicalPlan resolvedChild, Seq<NamedExpression> originalProjectList) {
        ArrayList<ArrayList<Alias>> aliasDependencyMap = this.scopes().top().lcaRegistry().getAliasDependencyLevels();
        Tuple2 tuple2 = (Tuple2)CollectionConverters$.MODULE$.ListHasAsScala(aliasDependencyMap).asScala().foldLeft((Object)new Tuple2((Object)resolvedChild, this.scopes().top().output().map((Function1 & Serializable)x$2 -> x$2)), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ArrayList availableAliases = (ArrayList)tuple2._2();
                if (tuple22 != null) {
                    LogicalPlan currentPlan = (LogicalPlan)tuple22._1();
                    Seq currentProjectList = (Seq)tuple22._2();
                    ArrayBuffer referencedAliases = new ArrayBuffer();
                    availableAliases.forEach(alias -> {
                        if (this.scopes().top().lcaRegistry().isAttributeLaterallyReferenced(alias.toAttribute())) {
                            referencedAliases.append(alias);
                            return;
                        }
                    });
                    if (referencedAliases.nonEmpty()) {
                        Seq newProjectList = (Seq)((IterableOps)currentProjectList.map((Function1 & Serializable)x$3 -> x$3.toAttribute())).$plus$plus((IterableOnce)referencedAliases);
                        return new Tuple2((Object)new Project((Seq<NamedExpression>)newProjectList, currentPlan), (Object)newProjectList);
                    }
                    return new Tuple2((Object)currentPlan, (Object)currentProjectList);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan finalChildPlan = (LogicalPlan)tuple2._1();
        LogicalPlan finalChildPlan2 = finalChildPlan;
        Seq finalProjectList = (Seq)originalProjectList.map((Function1 & Serializable)alias -> {
            if (this.scopes().top().lcaRegistry().isAttributeLaterallyReferenced(alias.toAttribute())) {
                return alias.toAttribute();
            }
            return alias;
        });
        return new Project((Seq<NamedExpression>)finalProjectList, finalChildPlan2);
    }

    public ProjectResolver(Resolver operatorResolver, ExpressionResolver expressionResolver) {
        this.operatorResolver = operatorResolver;
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.isLcaEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.LATERAL_COLUMN_ALIAS_IMPLICIT_ENABLED()));
        this.scopes = operatorResolver.getNameScopes();
    }
}

