/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.LinearSVCModel$;
import org.apache.spark.ml.classification.LinearSVCModel$LinearSVCWriter$;
import org.apache.spark.ml.classification.LinearSVCModel$LinearSVCWriter$Data$;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.LinearSVCSummary;
import org.apache.spark.ml.classification.LinearSVCSummaryImpl;
import org.apache.spark.ml.classification.LinearSVCTrainingSummary;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001B A\u0001-C\u0001B\u001a\u0001\u0003\u0006\u0004%\te\u001a\u0005\t}\u0002\u0011\t\u0011)A\u0005Q\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t!a\u0001\t\u0013\u0005\u001d\u0001A!A!\u0002\u0013\u0001\u0006BCA\u0006\u0001\t\u0015\r\u0011\"\u0001\u0002\u000e!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u0011\u0005u\u0001\u0001\"\u0001A\u0003?A\u0001\"!\b\u0001\t\u0003\u0011\u0015Q\u0006\u0005\n\u0003_\u0001!\u0019!C!\u0003cA\u0001\"a\u000f\u0001A\u0003%\u00111\u0007\u0005\n\u0003\u007f\u0001!\u0019!C!\u0003cA\u0001\"a\u0011\u0001A\u0003%\u00111\u0007\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA,\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002\u001e\u0002!\t%a(\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011\u0011\u0017\u0001\u0005R\u0005M\u0006bBA]\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\tY\u000e\u0001C!\u0003;<q!a9A\u0011\u0003\t)O\u0002\u0004@\u0001\"\u0005\u0011q\u001d\u0005\b\u0003;IB\u0011\u0001B\u0003\u0011\u001d\u00119!\u0007C!\u0005\u0013AqAa\u0005\u001a\t\u0003\u0012)BB\u0004\u0003\u001ee\u0001\u0011Da\b\t\u0013\t5RD!A!\u0002\u00131\u0006bBA\u000f;\u0011\u0005!q\u0006\u0004\u0007\u0005oiBI!\u000f\t\u0015\u0005\u0005\u0001E!f\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\b\u0001\u0012\t\u0012)A\u0005!\"Q\u00111\u0002\u0011\u0003\u0016\u0004%\t!!\u0004\t\u0015\u0005e\u0001E!E!\u0002\u0013\ty\u0001C\u0004\u0002\u001e\u0001\"\tA!\u0015\t\u0013\u0005e\u0006%!A\u0005\u0002\tm\u0003\"\u0003B1AE\u0005I\u0011\u0001B2\u0011%\u00119\bII\u0001\n\u0003\u0011I\bC\u0005\u0003~\u0001\n\t\u0011\"\u0011\u0003\u0000!I!1\u0012\u0011\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0005\u001b\u0003\u0013\u0011!C\u0001\u0005\u001fC\u0011B!&!\u0003\u0003%\tEa&\t\u0013\t\u0015\u0006%!A\u0005\u0002\t\u001d\u0006\"\u0003BYA\u0005\u0005I\u0011\tBZ\u0011%\u00119\fIA\u0001\n\u0003\u0012I\fC\u0005\u0002\\\u0002\n\t\u0011\"\u0011\u0003<\"I!Q\u0018\u0011\u0002\u0002\u0013\u0005#qX\u0004\n\u0005\u0007l\u0012\u0011!E\u0005\u0005\u000b4\u0011Ba\u000e\u001e\u0003\u0003EIAa2\t\u000f\u0005u1\u0007\"\u0001\u0003V\"I\u00111\\\u001a\u0002\u0002\u0013\u0015#1\u0018\u0005\n\u0005/\u001c\u0014\u0011!CA\u00053D\u0011Ba84\u0003\u0003%\tI!9\t\u000f\tMX\u0004\"\u0015\u0003v\u001a1!q`\r\u0005\u0007\u0003Aq!!\b:\t\u0003\u0019\u0019\u0001C\u0005\u0004\be\u0012\r\u0011\"\u0003\u0003\u0000!A1\u0011B\u001d!\u0002\u0013\u0011\t\tC\u0004\u0003\u0014e\"\tea\u0003\t\u0013\r=\u0011$!A\u0005\n\rE!A\u0004'j]\u0016\f'o\u0015,D\u001b>$W\r\u001c\u0006\u0003\u0003\n\u000bab\u00197bgNLg-[2bi&|gN\u0003\u0002D\t\u0006\u0011Q\u000e\u001c\u0006\u0003\u000b\u001a\u000bQa\u001d9be.T!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO\u000e\u00011#\u0002\u0001M/j\u0003\u0007\u0003B'O!Zk\u0011\u0001Q\u0005\u0003\u001f\u0002\u00131c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"!\u0015+\u000e\u0003IS!a\u0015\"\u0002\r1Lg.\u00197h\u0013\t)&K\u0001\u0004WK\u000e$xN\u001d\t\u0003\u001b\u0002\u0001\"!\u0014-\n\u0005e\u0003%a\u0004'j]\u0016\f'o\u0015,D!\u0006\u0014\u0018-\\:\u0011\u0005msV\"\u0001/\u000b\u0005u\u0013\u0015\u0001B;uS2L!a\u0018/\u0003\u00155cuK]5uC\ndW\rE\u0002\\C\u000eL!A\u0019/\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u0003\u001b\u0012L!!\u001a!\u000311Kg.Z1s'Z\u001bEK]1j]&twmU;n[\u0006\u0014\u00180A\u0002vS\u0012,\u0012\u0001\u001b\t\u0003SJt!A\u001b9\u0011\u0005-tW\"\u00017\u000b\u00055T\u0015A\u0002\u001fs_>$hHC\u0001p\u0003\u0015\u00198-\u00197b\u0013\t\th.\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9oQ\r\ta\u000f \t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\tY\bPA\u0003TS:\u001cW-I\u0001~\u0003\u0015\u0011dF\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t1H0\u0001\u0007d_\u00164g-[2jK:$8/F\u0001QQ\r\u0019a\u000f`\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\u0007\u00111H0A\u0005j]R,'oY3qiV\u0011\u0011q\u0002\t\u0005\u0003#\t\u0019\"D\u0001o\u0013\r\t)B\u001c\u0002\u0007\t>,(\r\\3)\u0007\u00151H0\u0001\u0006j]R,'oY3qi\u0002B3A\u0002<}\u0003\u0019a\u0014N\\5u}Q9a+!\t\u0002&\u0005%\u0002\"\u00024\b\u0001\u0004A\u0007\u0006BA\u0011mrDa!!\u0001\b\u0001\u0004\u0001\u0006\u0006BA\u0013mrDq!a\u0003\b\u0001\u0004\ty\u0001\u000b\u0003\u0002*YdH#\u0001,\u0002\u00159,Xn\u00117bgN,7/\u0006\u0002\u00024A!\u0011\u0011CA\u001b\u0013\r\t9D\u001c\u0002\u0004\u0013:$\bfA\u0005wy\u0006Ya.^7DY\u0006\u001c8/Z:!Q\rQa\u000f`\u0001\f]Vlg)Z1ukJ,7\u000fK\u0002\fmr\fAB\\;n\r\u0016\fG/\u001e:fg\u0002B3\u0001\u0004<}\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\u0011\tY%!\u0014\u000e\u0003\u0001Aq!a\u0014\u000e\u0001\u0004\ty!A\u0003wC2,X\rK\u0002\u000emr\fa!\\1sO&tWCAA,!\u001d\t\t\"!\u0017Q\u0003\u001fI1!a\u0017o\u0005%1UO\\2uS>t\u0017'A\u0004nCJ<\u0017N\u001c\u0011\u0002\u000fM,X.\\1ssV\t1\r\u000b\u0003\u0011m\u0006\u0015\u0014EAA4\u0003\u0015\u0019d&\r\u00181\u0003!)g/\u00197vCR,G\u0003BA7\u0003g\u00022!TA8\u0013\r\t\t\b\u0011\u0002\u0011\u0019&tW-\u0019:T-\u000e\u001bV/\\7befDq!!\u001e\u0012\u0001\u0004\t9(A\u0004eCR\f7/\u001a;1\t\u0005e\u0014\u0011\u0012\t\u0007\u0003w\n\t)!\"\u000e\u0005\u0005u$bAA@\t\u0006\u00191/\u001d7\n\t\u0005\r\u0015Q\u0010\u0002\b\t\u0006$\u0018m]3u!\u0011\t9)!#\r\u0001\u0011a\u00111RA:\u0003\u0003\u0005\tQ!\u0001\u0002\u000e\n\u0019q\fJ\u001a\u0012\t\u0005=\u0015Q\u0013\t\u0005\u0003#\t\t*C\u0002\u0002\u0014:\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0012\u0005]\u0015bAAM]\n\u0019\u0011I\\=)\tE1\u0018QM\u0001\baJ,G-[2u)\u0011\ty!!)\t\r\u0005\r&\u00031\u0001Q\u0003!1W-\u0019;ve\u0016\u001c\u0018A\u00039sK\u0012L7\r\u001e*boR\u0019\u0001+!+\t\r\u0005\r6\u00031\u0001QQ\u0011\u0019b/!,\"\u0005\u0005=\u0016!B\u001a/a9\u0002\u0014A\u0004:boJ\u0002(/\u001a3jGRLwN\u001c\u000b\u0005\u0003\u001f\t)\f\u0003\u0004\u00028R\u0001\r\u0001U\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8\u0002\t\r|\u0007/\u001f\u000b\u0004-\u0006u\u0006bBA`+\u0001\u0007\u0011\u0011Y\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011q\u0019\"\u0002\u000bA\f'/Y7\n\t\u0005-\u0017Q\u0019\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001aQC\u001e?\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005M\u0007cA.\u0002V&\u0019\u0011q\u001b/\u0003\u00115cuK]5uKJD3A\u0006<}\u0003!!xn\u0015;sS:<G#\u00015)\t]1\u0018Q\u0016\u0015\u0004\u0001Yd\u0018A\u0004'j]\u0016\f'o\u0015,D\u001b>$W\r\u001c\t\u0003\u001bf\u0019r!GAu\u0003_\f)\u0010\u0005\u0003\u0002\u0012\u0005-\u0018bAAw]\n1\u0011I\\=SK\u001a\u0004BaWAy-&\u0019\u00111\u001f/\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\u0005%|'BAA\u0000\u0003\u0011Q\u0017M^1\n\t\t\r\u0011\u0011 \u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003K\fAA]3bIV\u0011!1\u0002\t\u00057\n5a+C\u0002\u0003\u0010q\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u00047Yd\u0018\u0001\u00027pC\u0012$2A\u0016B\f\u0011\u0019\u0011I\u0002\ba\u0001Q\u0006!\u0001/\u0019;iQ\rab\u000f \u0002\u0010\u0019&tW-\u0019:T-\u000e;&/\u001b;feN)Q$a5\u0003\"A!!1\u0005B\u0015\u001b\t\u0011)CC\u0002\u0003(\u0011\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0005W\u0011)CA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016$BA!\r\u00036A\u0019!1G\u000f\u000e\u0003eAaA!\f \u0001\u00041&\u0001\u0002#bi\u0006\u001cr\u0001IAu\u0005w\u0011\t\u0005\u0005\u0003\u0002\u0012\tu\u0012b\u0001B ]\n9\u0001K]8ek\u000e$\b\u0003\u0002B\"\u0005\u001brAA!\u0012\u0003J9\u00191Na\u0012\n\u0003=L1Aa\u0013o\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0001\u0003P)\u0019!1\n8\u0015\r\tM#q\u000bB-!\r\u0011)\u0006I\u0007\u0002;!1\u0011\u0011A\u0013A\u0002ACq!a\u0003&\u0001\u0004\ty\u0001\u0006\u0004\u0003T\tu#q\f\u0005\t\u0003\u00031\u0003\u0013!a\u0001!\"I\u00111\u0002\u0014\u0011\u0002\u0003\u0007\u0011qB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)GK\u0002Q\u0005OZ#A!\u001b\u0011\t\t-$1O\u0007\u0003\u0005[RAAa\u001c\u0003r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003s:LAA!\u001e\u0003n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0010\u0016\u0005\u0003\u001f\u00119'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0003\u0003BAa!\u0003\n6\u0011!Q\u0011\u0006\u0005\u0005\u000f\u000bi0\u0001\u0003mC:<\u0017bA:\u0003\u0006\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAK\u0005#C\u0011Ba%,\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\n\u0005\u0004\u0003\u001c\n\u0005\u0016QS\u0007\u0003\u0005;S1Aa(o\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005G\u0013iJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BU\u0005_\u0003B!!\u0005\u0003,&\u0019!Q\u00168\u0003\u000f\t{w\u000e\\3b]\"I!1S\u0017\u0002\u0002\u0003\u0007\u0011QS\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0002\nU\u0006\"\u0003BJ]\u0005\u0005\t\u0019AA\u001a\u0003!A\u0017m\u001d5D_\u0012,GCAA\u001a)\t\u0011\t)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005S\u0013\t\rC\u0005\u0003\u0014F\n\t\u00111\u0001\u0002\u0016\u0006!A)\u0019;b!\r\u0011)fM\n\u0006g\t%\u0017Q\u001f\t\n\u0005\u0017\u0014\t\u000eUA\b\u0005'j!A!4\u000b\u0007\t=g.A\u0004sk:$\u0018.\\3\n\t\tM'Q\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001Bc\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011\u0019Fa7\u0003^\"1\u0011\u0011\u0001\u001cA\u0002ACq!a\u00037\u0001\u0004\ty!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r(q\u001e\t\u0007\u0003#\u0011)O!;\n\u0007\t\u001dhN\u0001\u0004PaRLwN\u001c\t\b\u0003#\u0011Y\u000fUA\b\u0013\r\u0011iO\u001c\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tEx'!AA\u0002\tM\u0013a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003x\nu\b\u0003BA\t\u0005sL1Aa?o\u0005\u0011)f.\u001b;\t\r\te\u0001\b1\u0001i\u0005=a\u0015N\\3beN36IU3bI\u0016\u00148cA\u001d\u0003\fQ\u00111Q\u0001\t\u0004\u0005gI\u0014!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u000b\u0004-\u000e5\u0001B\u0002B\r{\u0001\u0007\u0001.\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u0014A!!1QB\u000b\u0013\u0011\u00199B!\"\u0003\r=\u0013'.Z2uQ\rIb\u000f \u0015\u00041Yd\b")
public class LinearSVCModel
extends ClassificationModel<Vector, LinearSVCModel>
implements LinearSVCParams,
MLWritable,
HasTrainingSummary<LinearSVCTrainingSummary> {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final int numClasses;
    private final int numFeatures;
    private final Function1<Vector, Object> margin;
    private Option<LinearSVCTrainingSummary> trainingSummary;
    private DoubleParam threshold;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam regParam;

    public static LinearSVCModel load(String path) {
        return LinearSVCModel$.MODULE$.load(path);
    }

    public static MLReader<LinearSVCModel> read() {
        return LinearSVCModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LinearSVCTrainingSummary> setSummary(Option<LinearSVCTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Option<LinearSVCTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LinearSVCTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearSVCModel setThreshold(double value) {
        return (LinearSVCModel)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    @Override
    public LinearSVCTrainingSummary summary() {
        return (LinearSVCTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public LinearSVCSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ClassificationModel summaryModel = (ClassificationModel)tuple3._1();
        String rawPrediction = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)rawPrediction, (Object)predictionColName);
        ClassificationModel summaryModel2 = (ClassificationModel)tuple32._1();
        String rawPrediction2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        return new LinearSVCSummaryImpl(summaryModel2.transform(dataset), rawPrediction2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        if (BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features)) > BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()))) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        if (rawPrediction.apply(1) > BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()))) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public LinearSVCModel copy(ParamMap extra) {
        return (LinearSVCModel)((Model)this.copyValues(new LinearSVCModel(this.uid(), this.coefficients(), this.intercept()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new LinearSVCWriter(this);
    }

    @Override
    public String toString() {
        return "LinearSVCModel: uid=" + this.uid() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LinearSVCModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this.coefficients()) + $this.intercept();
    }

    public LinearSVCModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numClasses = 2;
        this.numFeatures = coefficients.size();
        this.margin = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LinearSVCModel.$anonfun$margin$1(this, features));
        Statics.releaseFence();
    }

    public LinearSVCModel() {
        this("", (Vector)Vectors$.MODULE$.empty(), Double.NaN);
    }

    private static class LinearSVCReader
    extends MLReader<LinearSVCModel> {
        private final String className = LinearSVCModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearSVCModel load(String path) {
            Vector vector;
            Object intercept;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    Some some;
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().format("parquet").load(dataPath);
                    row = (Row)data.select("coefficients", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept"})).head();
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block2;
                    Object coefficients = ((SeqOps)some.get()).apply(0);
                    intercept = ((SeqOps)some.get()).apply(1);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (intercept instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d = BoxesRunTime.unboxToDouble((Object)intercept);
            Tuple2 tuple2 = new Tuple2((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d));
            Vector coefficients = (Vector)tuple2._1();
            double intercept2 = tuple2._2$mcD$sp();
            LinearSVCModel model = new LinearSVCModel(metadata.uid(), coefficients, intercept2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LinearSVCWriter
    extends MLWriter {
        private volatile LinearSVCModel$LinearSVCWriter$Data$ Data$module;
        private final LinearSVCModel instance;

        private LinearSVCModel$LinearSVCWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearSVCWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LinearSVCModel.LinearSVCWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LinearSVCModel.LinearSVCWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$1(LinearSVCWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$1(null))).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LinearSVCWriter linearSVCWriter = this;
            synchronized (linearSVCWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LinearSVCModel$LinearSVCWriter$Data$(this);
                }
            }
        }

        public LinearSVCWriter(LinearSVCModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final Vector coefficients;
            private final double intercept;
            public final /* synthetic */ LinearSVCWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public Data copy(Vector coefficients, double intercept) {
                return new Data(this.org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer(), coefficients, intercept);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return this.coefficients();
                    }
                    case 1: {
                        return BoxesRunTime.boxToDouble((double)this.intercept());
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return "coefficients";
                    }
                    case 1: {
                        return "intercept";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LinearSVCWriter org$apache$spark$ml$classification$LinearSVCModel$LinearSVCWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LinearSVCWriter $outer, Vector coefficients, double intercept) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

