/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h!\u0002\u000f\u001e\u0001\u0005J\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000be\u0002A\u0011\u0001\u001e\t\u000fu\u0002!\u0019!C\u0005}!1Q\u000b\u0001Q\u0001\n}BqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0003X\u0011\u0019\u0001\u0007\u0001)A\u00051\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0004h\u0001\t\u0007I\u0011\u00022\t\r!\u0004\u0001\u0015!\u0003d\u0011\u0015I\u0007\u0001\"\u0003k\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0018\u0001\t\u0003\t\t\u0007\u0003\u0005\u0002n\u0001!\taHA8\u000f\u001d\tI(\bE\u0001\u0003w2a\u0001H\u000f\t\u0002\u0005u\u0004BB\u001d\u0013\t\u0003\ty\bC\u0005\u0002\u0002J\u0011\r\u0011\"\u0001\u0002\u0004\"A\u00111\u0012\n!\u0002\u0013\t)\tC\u0004\u0002*J!\t!a+\t\u000f\u0005]&\u0003\"\u0001\u0002:\"9\u0011\u0011\u001a\n\u0005\u0002\u0005-\u0007\u0002CAj%\u0001\u0006I!!-\t\u000f\u0005U'\u0003\"\u0001\u0002X\"I\u0011\u0011\u001d\n\u0002\u0002\u0013%\u00111\u001d\u0002\u0010\u0015N|g.\u00138gKJ\u001c6\r[3nC*\u0011adH\u0001\u0005UN|gN\u0003\u0002!C\u0005A1-\u0019;bYf\u001cHO\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c2\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u00111&M\u0005\u0003e1\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fqa\u001c9uS>t7o\u0001\u0001\u0011\u0005Y:T\"A\u000f\n\u0005aj\"a\u0003&T\u001f:{\u0005\u000f^5p]N\fa\u0001P5oSRtDCA\u001e=!\t1\u0004\u0001C\u00034\u0005\u0001\u0007Q'A\u0007eK\u000eLW.\u00197QCJ\u001cXM]\u000b\u0002\u007fA!1\u0006\u0011\"N\u0013\t\tEFA\u0005Gk:\u001cG/[8ocA\u00111I\u0013\b\u0003\t\"\u0003\"!\u0012\u0017\u000e\u0003\u0019S!a\u0012\u001b\u0002\rq\u0012xn\u001c;?\u0013\tIE&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%-!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003nCRD'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013!BQ5h\t\u0016\u001c\u0017.\\1m\u00039!WmY5nC2\u0004\u0016M]:fe\u0002\n!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\?\u0005!Q\u000f^5m\u0013\ti&L\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM]\u0001\u0017i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3sA\u0005a\u0011n\u001d#fM\u0006,H\u000e\u001e(U5V\t1\r\u0005\u0002,I&\u0011Q\r\f\u0002\b\u0005>|G.Z1o\u00035I7\u000fR3gCVdGO\u0014+[A\u0005QA.Z4bGflu\u000eZ3\u0002\u00171,w-Y2z\u001b>$W\rI\u0001\u001cQ\u0006tG\r\\3Kg>tWI\u001d:peN\u0014\u0015\u0010U1sg\u0016lu\u000eZ3\u0015\t-$\u0018p\u001f\t\u0004W1t\u0017BA7-\u0005\u0019y\u0005\u000f^5p]B\u0011qN]\u0007\u0002a*\u0011\u0011/I\u0001\u0006if\u0004Xm]\u0005\u0003gB\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015)X\u00021\u0001w\u0003%\u0001\u0018M]:f\u001b>$W\r\u0005\u0002Zo&\u0011\u0001P\u0017\u0002\n!\u0006\u00148/Z'pI\u0016DQA_\u0007A\u0002\t\u000b\u0011dY8mk6tg*Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sI\")A0\u0004a\u0001{\u0006\tQ\rE\u0002\u007f\u0003\u000fq1a`A\u0002\u001d\r)\u0015\u0011A\u0005\u0002[%\u0019\u0011Q\u0001\u0017\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u00061\nQ!\u001b8gKJ,B!!\u0005\u0002&Q)a.a\u0005\u00028!1aD\u0004a\u0001\u0003+\u0001b!a\u0006\u0002\u001e\u0005\u0005RBAA\r\u0015\r\tYbI\u0001\u0004e\u0012$\u0017\u0002BA\u0010\u00033\u00111A\u0015#E!\u0011\t\u0019#!\n\r\u0001\u00119\u0011q\u0005\bC\u0002\u0005%\"!\u0001+\u0012\t\u0005-\u0012\u0011\u0007\t\u0004W\u00055\u0012bAA\u0018Y\t9aj\u001c;iS:<\u0007cA\u0016\u00024%\u0019\u0011Q\u0007\u0017\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002:9\u0001\r!a\u000f\u0002\u0019\r\u0014X-\u0019;f!\u0006\u00148/\u001a:\u0011\u0013-\ni$!\u0011\u0002\"\u0005e\u0013bAA Y\tIa)\u001e8di&|gN\r\t\u0005\u0003\u0007\n)&\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011\u0019wN]3\u000b\t\u0005-\u0013QJ\u0001\bU\u0006\u001c7n]8o\u0015\u0011\ty%!\u0015\u0002\u0013\u0019\f7\u000f^3sq6d'BAA*\u0003\r\u0019w.\\\u0005\u0005\u0003/\n)EA\u0006Kg>tg)Y2u_JL\b\u0003BA\"\u00037JA!!\u0018\u0002F\tQ!j]8o!\u0006\u00148/\u001a:\u0002\u0015%tg-\u001a:GS\u0016dG\r\u0006\u0003\u0002d\u0005%\u0004cA8\u0002f%\u0019\u0011q\r9\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a\u001b\u0010\u0001\u0004\tI&\u0001\u0004qCJ\u001cXM]\u0001\u0011G\u0006twN\\5dC2L'0\u001a+za\u0016$b!!\u001d\u0002t\u0005]\u0004\u0003B\u0016m\u0003GBq!!\u001e\u0011\u0001\u0004\t\u0019'A\u0002ua\u0016DQa\r\tA\u0002U\nqBS:p]&sg-\u001a:TG\",W.\u0019\t\u0003mI\u00192A\u0005\u00161)\t\tY(A\u000btiJ,8\r\u001e$jK2$7i\\7qCJ\fGo\u001c:\u0016\u0005\u0005\u0015%CBAD\u0003\u001b\u000bIJ\u0002\u0004\u0002\nV\u0001\u0011Q\u0011\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u0017gR\u0014Xo\u0019;GS\u0016dGmQ8na\u0006\u0014\u0018\r^8sAA!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014F\u000bA\u0001\\1oO&!\u0011qSAI\u0005\u0019y%M[3diB1\u00111TAP\u0003Gk!!!(\u000b\u0005m\u000b\u0016\u0002BAQ\u0003;\u0013!bQ8na\u0006\u0014\u0018\r^8s!\ry\u0017QU\u0005\u0004\u0003O\u0003(aC*ueV\u001cGOR5fY\u0012\f\u0001\"[:T_J$X\r\u001a\u000b\u0004G\u00065\u0006bBAX-\u0001\u0007\u0011\u0011W\u0001\u0004CJ\u0014\b#B\u0016\u00024\u0006\r\u0016bAA[Y\t)\u0011I\u001d:bs\u0006\u0001r/\u001b;i\u0007>\u0014(/\u001e9u\r&,G\u000e\u001a\u000b\n]\u0006m\u0016qXAb\u0003\u000fDa!!0\u0018\u0001\u0004q\u0017AB:ueV\u001cG\u000fC\u0004\u0002B^\u0001\r!a\u0019\u0002\u000b=$\b.\u001a:\t\r\u0005\u0015w\u00031\u0001C\u0003i\u0019w\u000e\\;n]:\u000bW.Z(g\u0007>\u0014(/\u001e9u%\u0016\u001cwN\u001d3t\u0011\u0015)x\u00031\u0001w\u0003I\u0019w.\u001c9bi&\u0014G.\u001a*p_R$\u0016\u0010]3\u0015\r\u00055\u0017qZAi!%Y\u0013QHA2\u0003G\n\u0019\u0007\u0003\u0004\u0002Fb\u0001\rA\u0011\u0005\u0006kb\u0001\rA^\u0001\u0016K6\u0004H/_*ueV\u001cGOR5fY\u0012\f%O]1z\u00039\u0019w.\u001c9bi&\u0014G.\u001a+za\u0016$b!a\u0019\u0002Z\u0006u\u0007bBAn5\u0001\u0007\u00111M\u0001\u0003iFBq!a8\u001b\u0001\u0004\t\u0019'\u0001\u0002ue\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\t")
public class JsonInferSchema
implements scala.Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final boolean isDefaultNTZ;
    private final boolean legacyMode;

    public static DataType compatibleType(DataType dataType, DataType dataType2) {
        return JsonInferSchema$.MODULE$.compatibleType(dataType, dataType2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(string, parseMode);
    }

    public static StructType withCorruptField(StructType structType, DataType dataType, String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(structType, dataType, string, parseMode);
    }

    public static boolean isSorted(StructField[] structFieldArray) {
        return JsonInferSchema$.MODULE$.isSorted(structFieldArray);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    private boolean legacyMode() {
        return this.legacyMode;
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            return new Some((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            return None$.MODULE$;
        }
        if (FailFastMode$.MODULE$.equals(parseMode2)) {
            throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e);
        }
        throw new MatchError((Object)parseMode2);
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Iterable iterable;
                try {
                    iterable = Option$.MODULE$.option2Iterable((Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable & scala.Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    }));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException)) {
                        iterable = Option$.MODULE$.option2Iterable(this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2));
                    }
                    if (throwable2 instanceof CharConversionException) {
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if ($this.options.encoding().isEmpty()) {
                            String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |")).stripMargin()).append(charConversionException.getMessage()).toString();
                            CharConversionException wrappedCharException = new CharConversionException(msg);
                            wrappedCharException.initCause(charConversionException);
                            iterable = Option$.MODULE$.option2Iterable(this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException));
                        }
                    }
                    throw throwable;
                }
                return iterable;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        Function1 & Serializable & scala.Serializable foldPartition = (Function1 & Serializable & scala.Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$), typeMerger);
        Function2 & Serializable & scala.Serializable mergeResult = (Function2 & Serializable & scala.Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable & scala.Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2)) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            if (this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined()) {
                return (DataType)this.decimalTry$1(decimalTry$lzy, field).get();
            }
            if (this.options.inferTimestamp()) {
                if (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
                    return TimestampNTZType$.MODULE$;
                }
                if (this.timestampFormatter().parseOptional(field).isDefined()) {
                    return TimestampType$.MODULE$;
                }
                if (this.legacyMode()) {
                    UTF8String utf8Value = UTF8String.fromString((String)field);
                    if (SparkDateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(utf8Value, false).isDefined()) {
                        return TimestampType$.MODULE$;
                    }
                    return StringType$.MODULE$;
                }
                return StringType$.MODULE$;
            }
            return StringType$.MODULE$;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType((DataType)elementType, this.inferField(parser));
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        if ((JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if ((JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) {
            JsonParser.NumberType numberType = parser.getNumberType();
            if (JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType)) {
                return LongType$.MODULE$;
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if ((JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) && this.options.prefersDecimal()) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return DoubleType$.MODULE$;
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) {
            return BooleanType$.MODULE$;
        }
        throw QueryExecutionErrors$.MODULE$.malformedJSONError();
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable & scala.Serializable)t -> arrayType.copy(t, arrayType.copy$default$2()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$canonicalizeType$2(x$2))))).flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable & scala.Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])canonicalFields)).isEmpty()) {
                return None$.MODULE$;
            }
            return new Some((Object)new StructType(canonicalFields));
        }
        if (NullType$.MODULE$.equals(dataType)) {
            if (options.dropFieldIfAllNull()) {
                return None$.MODULE$;
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return new Some((Object)dataType);
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        if (decimalTry$lzy$1.initialized()) {
            return (Option)decimalTry$lzy$1.value();
        }
        return this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.name())).nonEmpty();
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        this.legacyMode = !(value != null ? !value.equals(value2) : value2 != null);
    }
}

