/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import javax.jcr.Session;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXHandler;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ProviderType
public final class DocViewParser {
    @Nullable
    private final NamespaceResolver resolver;
    public static final int MAX_NUM_BYTES_TO_READ_FOR_DOCVIEW_DETECTION = 1024;

    public DocViewParser() {
        this((NamespaceResolver)null);
    }

    public DocViewParser(@NotNull Session session) {
        this(new SessionNamespaceResolver(session));
    }

    public DocViewParser(@Nullable NamespaceResolver resolver) {
        this.resolver = resolver;
    }

    public static boolean isDocView(InputSource source) throws IOException {
        String encoding = source.getEncoding() != null ? source.getEncoding() : StandardCharsets.UTF_8.name();
        try (Reader reader = source.getCharacterStream() != null ? source.getCharacterStream() : new InputStreamReader(source.getByteStream(), encoding);){
            boolean bl = DocViewParser.isDocView(reader);
            return bl;
        }
    }

    private static boolean isDocView(Reader reader) throws IOException {
        int pos;
        int read;
        char[] buffer = new char[1024];
        for (pos = 0; pos < buffer.length && (read = reader.read(buffer, pos, buffer.length - pos)) >= 0; pos += read) {
        }
        String str = new String(buffer, 0, pos);
        return str.contains("<jcr:root") && str.contains("\"http://www.jcp.org/jcr/1.0\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getDocumentViewXmlRootNodePath(InputStream input, Path filePath) throws IOException {
        if (filePath.isAbsolute()) {
            throw new IllegalArgumentException("The filePath parameter must be given as relative path!");
        }
        Path name = filePath.getFileName();
        Path rootPath = null;
        int nameCount = filePath.getNameCount();
        if (name.equals(Paths.get(".content.xml", new String[0]))) {
            rootPath = nameCount > 1 ? filePath.getParent() : Paths.get("", new String[0]);
        } else if (name.toString().endsWith(".xml")) {
            input.mark(1024);
            try {
                if (DocViewParser.isDocView(new InputStreamReader((InputStream)new BoundedInputStream(input, 1024L), StandardCharsets.US_ASCII))) {
                    String fileName = filePath.getFileName().toString();
                    fileName = fileName.substring(0, fileName.length() - ".xml".length());
                    rootPath = nameCount > 1 ? filePath.getParent().resolve(fileName) : Paths.get(fileName, new String[0]);
                }
            }
            finally {
                input.reset();
            }
        }
        if (rootPath == null) {
            return null;
        }
        String platformPath = FilenameUtils.separatorsToUnix(rootPath.toString());
        return "/" + PlatformNameFormat.getRepositoryPath(platformPath, true);
    }

    private SAXParser createSaxParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        SAXParser parser = factory.newSAXParser();
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return parser;
    }

    public void parse(String rootNodePath, InputSource inputSource, DocViewParserHandler handler) throws IOException, XmlParseException {
        SAXParser parser;
        try {
            parser = this.createSaxParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalStateException("Could not create SAX parser" + e.getMessage(), e);
        }
        DocViewSAXHandler docViewSaxHandler = new DocViewSAXHandler(handler, rootNodePath, this.resolver);
        try {
            parser.parse(inputSource, (DefaultHandler)docViewSaxHandler);
        }
        catch (IllegalArgumentException | SAXException e) {
            throw new XmlParseException(e, docViewSaxHandler.getCurrentPath(), docViewSaxHandler.getDocumentLocator());
        }
    }

    public static final class XmlParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String nodePath;
        private final int lineNumber;
        private final int columnNumber;

        public XmlParseException(String message, String nodePath, int lineNumber, int columnNumber) {
            super(message);
            this.nodePath = nodePath;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public XmlParseException(Throwable cause, String nodePath, int lineNumber, int columnNumber) {
            super(cause.getMessage(), cause);
            this.nodePath = nodePath;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public XmlParseException(Throwable cause, String nodePath, Locator locator) {
            this(cause, nodePath, locator.getLineNumber(), locator.getColumnNumber());
        }

        public String getNodePath() {
            return this.nodePath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int hashCode() {
            return Objects.hash(this.nodePath, this.columnNumber, this.lineNumber, this.getMessage());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XmlParseException other = (XmlParseException)obj;
            return Objects.equals(this.nodePath, other.nodePath) && this.columnNumber == other.columnNumber && this.lineNumber == other.lineNumber && this.getMessage().equals(other.getMessage());
        }
    }
}

