/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import org.apache.sling.ide.eclipse.core.DefaultSlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.internal.SlingLaunchpadConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.osgi.framework.Version;

public class SlingLaunchpadServer
extends ServerDelegate
implements ISlingLaunchpadServer {
    private static final String MODULE_TYPE_SLING_CONTENT = "sling.content";
    private static final String MODULE_TYPE_SLING_BUNDLE = "sling.bundle";
    private ISlingLaunchpadConfiguration config;

    @Override
    public ISlingLaunchpadConfiguration getConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        this.config = new SlingLaunchpadConfiguration(this);
        return this.config;
    }

    public IStatus canModifyModules(IModule[] toAdd, IModule[] toRemove) {
        if (toAdd == null) {
            return Status.OK_STATUS;
        }
        IModule[] iModuleArray = toAdd;
        int n = toAdd.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (!MODULE_TYPE_SLING_CONTENT.equals(module.getModuleType().getId()) && !MODULE_TYPE_SLING_BUNDLE.equals(module.getModuleType().getId())) {
                return new Status(4, "org.apache.sling.ide.eclipse-core", "Will only handle modules of type 'sling.content' or 'sling.bundle'");
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        if (module == null) {
            return null;
        }
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule arg0) throws CoreException {
        if (MODULE_TYPE_SLING_CONTENT.equals(arg0.getModuleType().getId()) || MODULE_TYPE_SLING_BUNDLE.equals(arg0.getModuleType().getId())) {
            return new IModule[]{arg0};
        }
        throw new CoreException((IStatus)new Status(4, "org.apache.sling.slingclipse", 0, "Will only handle modules of type 'sling.content' or 'sling.bundle'", null));
    }

    public void modifyModules(IModule[] toAdd, IModule[] toRemove, IProgressMonitor arg2) throws CoreException {
        IStatus status = this.canModifyModules(toAdd, toRemove);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setAttribute("launchpad.port", DefaultSlingLaunchpadConfiguration.INSTANCE.getPort());
        this.setAttribute("launchpad.debugPort", DefaultSlingLaunchpadConfiguration.INSTANCE.getDebugPort());
        this.setAttribute("launchpad.contextPath", "/");
        this.setAttribute("launchpad.username", DefaultSlingLaunchpadConfiguration.INSTANCE.getUsername());
        this.setAttribute("launchpad.password", DefaultSlingLaunchpadConfiguration.INSTANCE.getPassword());
    }

    @Override
    public Version getBundleVersion(String bundleSymbolicName) {
        String rawValue = this.getAttribute(String.format("launchpad.bundle.%s.version", bundleSymbolicName), null);
        return rawValue != null ? new Version(rawValue) : null;
    }

    @Override
    public void setBundleVersion(String bundleSymbolicName, Version version, IProgressMonitor monitor) {
        String stringVersion = version != null ? version.toString() : null;
        IServerWorkingCopy wc = this.getServer().createWorkingCopy();
        wc.setAttribute(String.format("launchpad.bundle.%s.version", bundleSymbolicName), stringVersion);
        try {
            wc.save(false, monitor);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

