/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.debug.impl;

import java.util.Date;
import org.apache.sling.ide.eclipse.core.logger.LogSubscriber;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(property={"listener.symbolic.name=org.apache.sling.ide.eclipse-core"}, service={LogSubscriber.class})
public class Tracer
implements DebugOptionsListener,
LogSubscriber {
    protected static final String BUNDLE_SYMBOLIC_NAME = "org.apache.sling.ide.eclipse-core";
    private boolean debugEnabled;
    private boolean consoleEnabled;
    private boolean performanceEnabled;
    private DebugTrace trace;
    private ServiceRegistration<DebugOptionsListener> debugOptionsListenerRegistration;

    @Activate
    public void activate(BundleContext context) {
        context.registerService(DebugOptionsListener.class, (Object)this, null);
    }

    @Deactivate
    public void deactivate(BundleContext context) {
        this.debugOptionsListenerRegistration.unregister();
    }

    public void optionsChanged(DebugOptions options) {
        this.debugEnabled = options.getBooleanOption("org.apache.sling.ide.eclipse-core/debug", false);
        this.consoleEnabled = options.getBooleanOption("org.apache.sling.ide.eclipse-core/debug/console", false) && this.debugEnabled;
        this.performanceEnabled = options.getBooleanOption("org.apache.sling.ide.eclipse-core/debug/performance", false) && this.debugEnabled;
        this.trace = options.newDebugTrace(BUNDLE_SYMBOLIC_NAME, this.getClass());
    }

    private void writeToStdOut(String message, Throwable t) {
        System.out.println("[" + Thread.currentThread().getName() + "] " + String.valueOf(new Date()) + "  : " + message);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    @Override
    public void log(LogSubscriber.Severity severity, String message, Throwable t) {
        if (!this.debugEnabled) {
            return;
        }
        if (this.consoleEnabled && severity == LogSubscriber.Severity.TRACE) {
            this.trace.trace("/debug", message);
            this.writeToStdOut(message, t);
        } else if (this.performanceEnabled && severity == LogSubscriber.Severity.TRACE) {
            this.trace.trace("/debug/performance", message);
            this.writeToStdOut(message, t);
        }
    }
}

