/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.objects;

import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectArrays;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ReferenceArraySet;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ReferenceCollections;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Set;

public final class ReferenceSets {
    public static final EmptySet EMPTY_SET = new EmptySet();
    static final ReferenceSet UNMODIFIABLE_EMPTY_SET = ReferenceSets.unmodifiable(new ReferenceArraySet(ObjectArrays.EMPTY_ARRAY));

    public static <K> ReferenceSet<K> unmodifiable(ReferenceSet<? extends K> s) {
        return new UnmodifiableSet<K>(s);
    }

    public static class EmptySet<K>
    extends ReferenceCollections.EmptyCollection<K>
    implements ReferenceSet<K>,
    Serializable,
    Cloneable {
        protected EmptySet() {
        }

        @Override
        public boolean remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }
    }

    public static class UnmodifiableSet<K>
    extends ReferenceCollections.UnmodifiableCollection<K>
    implements ReferenceSet<K>,
    Serializable {
        protected UnmodifiableSet(ReferenceSet<? extends K> s) {
            super(s);
        }

        @Override
        public boolean remove(Object k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }
    }
}

