/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.DAO;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public interface IMetricsQueryDAO
extends DAO {
    public static final int METRICS_VALUES_WITHOUT_ENTITY_LIMIT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public MetricsValues readMetricsValuesDebuggable(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: readMetricsValues");
                span.setMsg("Condition: MetricsCondition: " + String.valueOf(condition) + ", ValueColumnName: " + valueColumnName + ", Duration: " + String.valueOf(duration));
            }
            MetricsValues metricsValues = this.readMetricsValues(condition, valueColumnName, duration);
            return metricsValues;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<MetricsValues> readLabeledMetricsValuesDebuggable(MetricsCondition condition, String valueColumnName, List<KeyValue> labels, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: readLabeledMetricsValues");
                span.setMsg("Condition: MetricsCondition: " + String.valueOf(condition) + ", ValueColumnName: " + valueColumnName + ", Labels: " + String.valueOf(labels) + ", Duration: " + String.valueOf(duration));
            }
            List<MetricsValues> list = this.readLabeledMetricsValues(condition, valueColumnName, labels, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    public MetricsValues readMetricsValues(MetricsCondition var1, String var2, Duration var3) throws IOException;

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition var1, String var2, List<KeyValue> var3, Duration var4) throws IOException;

    public List<MetricsValues> readLabeledMetricsValuesWithoutEntity(String var1, String var2, List<KeyValue> var3, Duration var4) throws IOException;

    public HeatMap readHeatMap(MetricsCondition var1, String var2, Duration var3) throws IOException;

    private static List<MetricsValues> buildMetricsValues(String metricName, List<String> ids, Map<String, DataTable> idMap, List<String> allLabels) {
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(metricName);
        List labeledValues = new TreeSet<String>(allLabels).stream().flatMap(label -> ids.stream().map(id -> {
            DataTable value = idMap.getOrDefault(id, new DataTable());
            return Objects.nonNull(value.get((String)label)) ? new LabeledValue((String)label, (String)id, value.get((String)label), false) : new LabeledValue((String)label, (String)id, defaultValue, true);
        })).collect(Collectors.toList());
        MetricsValues current = new MetricsValues();
        ArrayList<MetricsValues> result = new ArrayList<MetricsValues>();
        for (LabeledValue each : labeledValues) {
            if (Objects.equals(current.getLabel(), each.label)) {
                current.getValues().addKVInt(each.kv);
                continue;
            }
            current = new MetricsValues();
            current.setLabel(each.label);
            current.getValues().addKVInt(each.kv);
            result.add(current);
        }
        return result;
    }

    private static LinkedHashMap<String, List<String>> buildLabelIndex(List<KeyValue> queryLabels, String separator) {
        LinkedHashMap<String, List<String>> labelIndex = new LinkedHashMap<String, List<String>>();
        if (null != queryLabels) {
            for (KeyValue keyValue : queryLabels) {
                String[] subValues;
                String labelName = keyValue.getKey();
                String labelValue = keyValue.getValue();
                if (!StringUtil.isNotBlank((String)labelValue)) continue;
                for (String subValue : subValues = labelValue.split(separator)) {
                    labelIndex.computeIfAbsent(labelName, key -> new ArrayList()).add(subValue);
                }
            }
        }
        return labelIndex;
    }

    public static class LabeledValue {
        private final String label;
        private final KVInt kv;

        public LabeledValue(String label, String id, long value, boolean isEmptyValue) {
            this.label = label;
            this.kv = new KVInt(id, value, isEmptyValue);
        }
    }

    public static class Util {
        public static IntValues sortValues(IntValues origin, List<String> expectedOrder, int defaultValue) {
            IntValues intValues = new IntValues();
            expectedOrder.forEach(id -> intValues.addKVInt(origin.findValue((String)id, defaultValue)));
            return intValues;
        }

        public static List<MetricsValues> sortValues(List<MetricsValues> origin, List<String> expectedOrder, int defaultValue) {
            for (int i = 0; i < origin.size(); ++i) {
                MetricsValues metricsValues = origin.get(i);
                metricsValues.setValues(Util.sortValues(metricsValues.getValues(), expectedOrder, defaultValue));
            }
            return origin;
        }

        public static List<MetricsValues> composeLabelValue(String metricName, List<KeyValue> queryLabels, List<String> ids, Map<String, DataTable> idMap) {
            Optional<ValueColumnMetadata.ValueColumn> valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
            if (valueColumn.isEmpty()) {
                return Collections.emptyList();
            }
            if (valueColumn.get().isMultiIntValues()) {
                List<String> labelValues = IMetricsQueryDAO.buildLabelIndex(queryLabels, ",").values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                return Util.composeLabelValueForMultiIntValues(metricName, labelValues, ids, idMap);
            }
            return Util.composeLabelValueForMultipleLabels(metricName, queryLabels, ids, idMap);
        }

        public static List<String> composeLabelConditions(List<KeyValue> queryLabels, Collection<DataTable> metricValues) {
            LinkedHashMap<String, List<String>> queryLabelIndex = IMetricsQueryDAO.buildLabelIndex(queryLabels, ",");
            ArrayList<String> labelConditions = new ArrayList();
            if (queryLabelIndex.isEmpty()) {
                labelConditions = metricValues.stream().flatMap(dataTable -> dataTable.keys().stream()).distinct().filter(k -> k.startsWith("{")).collect(Collectors.toList());
            } else {
                ArrayList keySets = new ArrayList();
                for (Map.Entry<String, List<String>> queryLabel : queryLabelIndex.entrySet()) {
                    HashSet keySet = new HashSet();
                    metricValues.forEach(dataTable -> {
                        Map<String, Set<String>> metricLabelIndex = dataTable.buildLabelIndex();
                        for (String labelValue : (List)queryLabel.getValue()) {
                            keySet.addAll(metricLabelIndex.getOrDefault((String)queryLabel.getKey() + "=" + labelValue, new HashSet()));
                        }
                    });
                    if (keySet.isEmpty()) continue;
                    keySets.add(keySet);
                }
                keySets.stream().reduce((a, b) -> {
                    a.retainAll((Collection<?>)b);
                    return a;
                }).ifPresent(labelConditions::addAll);
            }
            return labelConditions;
        }

        private static List<MetricsValues> composeLabelValueForMultiIntValues(String metricName, List<String> labels, List<String> ids, Map<String, DataTable> idMap) {
            List<String> allLabels = Objects.isNull(labels) || labels.isEmpty() || labels.stream().allMatch(Strings::isNullOrEmpty) ? idMap.values().stream().flatMap(dataTable -> dataTable.keys().stream()).distinct().filter(k -> !k.startsWith("{")).collect(Collectors.toList()) : labels;
            return IMetricsQueryDAO.buildMetricsValues(metricName, ids, idMap, allLabels);
        }

        private static List<MetricsValues> composeLabelValueForMultipleLabels(String metricName, List<KeyValue> queryLabels, List<String> ids, Map<String, DataTable> idMap) {
            List<String> labelConditions = Util.composeLabelConditions(queryLabels, idMap.values());
            return IMetricsQueryDAO.buildMetricsValues(metricName, ids, idMap, labelConditions);
        }
    }
}

