/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.tracing.zipkin.HttpClientRequestWrapper;
import org.apache.servicecomb.tracing.zipkin.HttpClientResponseWrapper;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;

class ZipkinConsumerDelegate
implements ZipkinTracingDelegate {
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
    private final HttpTracing httpTracing;
    private final TraceContext.Injector<Invocation> injector;
    private final HttpClientResponseWrapper responseWrapper;
    private final HttpClientRequestWrapper requestWrapper;

    ZipkinConsumerDelegate(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.injector = httpTracing.tracing().propagation().injector(this.injector());
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
        this.responseWrapper = new HttpClientResponseWrapper();
        this.requestWrapper = new HttpClientRequestWrapper();
    }

    @Override
    public Span createSpan(Invocation invocation) {
        return this.handler.handleSend((HttpClientRequest)this.requestWrapper.invocation(invocation));
    }

    @Override
    public void onResponse(Span span, Response response, Throwable error) {
        this.handler.handleReceive((HttpClientResponse)this.responseWrapper.response(response).throwable(error).request(this.requestWrapper), span);
    }

    @Override
    public String name() {
        return "Zipkin consumer";
    }

    @Override
    public Tracing tracer() {
        return this.httpTracing.tracing();
    }

    private Propagation.Setter<Invocation, String> injector() {
        return (invocation, key, value) -> invocation.getContext().put(key, value);
    }
}

