/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.processor.injection;

import org.apache.servicecomb.governance.policy.FaultInjectionPolicy;
import org.apache.servicecomb.governance.processor.injection.AbstractFault;
import org.apache.servicecomb.governance.processor.injection.FaultInjectionUtil;
import org.apache.servicecomb.governance.processor.injection.FaultParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortFault
extends AbstractFault {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbortFault.class);
    public static final String ABORTED_ERROR_MSG = "aborted by fault inject";

    public AbortFault(String key, FaultInjectionPolicy policy) {
        super(key, policy);
    }

    @Override
    public boolean injectFault(FaultParam faultParam) {
        return this.shouldAbort(faultParam, this.policy);
    }

    private boolean shouldAbort(FaultParam param, FaultInjectionPolicy policy) {
        int abortPercent = policy.getPercentage();
        if (abortPercent == -1) {
            LOGGER.debug("Fault injection: Abort percentage is not configured");
            return false;
        }
        return FaultInjectionUtil.isFaultNeedToInject(param.getReqCount(), abortPercent);
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public String getName() {
        return "abort";
    }
}

