/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import com.netflix.config.DynamicPropertyFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class PojoConfig {
    private static final String LOADING_MODE_BLOCKING = "blocking";

    PojoConfig() {
    }

    @Bean
    Executor executor() {
        if (LOADING_MODE_BLOCKING.equals(this.loadingMode())) {
            return Runnable::run;
        }
        return Executors.newSingleThreadExecutor();
    }

    private String loadingMode() {
        return DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.rpcReference.loadingMode", LOADING_MODE_BLOCKING).get();
    }
}

