/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.QueryProcessorCreator;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;
import org.apache.servicecomb.core.exception.Exceptions;
import org.springframework.stereotype.Component;

@Component
public class QueryCodecJson
implements QueryCodec {
    public static final String CODEC_NAME = "json";
    private static final JavaType OBJECT_TYPE = TypeFactory.defaultInstance().constructType(Object.class);

    @Override
    public String getCodecName() {
        return CODEC_NAME;
    }

    @Override
    public void encode(URLPathBuilder.URLPathStringBuilder builder, String name, @Nullable Object value) throws Exception {
        if (value == null) {
            return;
        }
        String json = RestObjectMapperFactory.getRestObjectMapper().writeValueAsString(value);
        builder.appendQuery(name, QueryCodec.encodeValue(json));
    }

    @Override
    public Object decode(QueryProcessorCreator.QueryProcessor processor, HttpServletRequest request) {
        Object value = processor.getAndCheckParameter(request);
        if (value == null) {
            return null;
        }
        try {
            JavaType targetType = processor.getTargetType();
            if (targetType == null) {
                targetType = OBJECT_TYPE;
            }
            return RestObjectMapperFactory.getRestObjectMapper().readValue(value.toString(), targetType);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.create((Response.StatusType)Response.Status.BAD_REQUEST, (String)"SCB.00000000", (String)("failed to decode query parameter, name=" + processor.getParameterPath()));
        }
    }
}

