/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.OperationConfig;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowInvocationLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlowInvocationLogger.class);

    public SlowInvocationLogger(SCBEngine scbEngine) {
        scbEngine.getEventBus().register((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onInvocationFinish(InvocationFinishEvent event) {
        Invocation invocation = event.getInvocation();
        OperationConfig operationConfig = invocation.getOperationMeta().getConfig();
        if (!operationConfig.isSlowInvocationEnabled() || invocation.getInvocationStageTrace().calcTotalTime() < (double)operationConfig.getNanoSlowInvocation()) {
            return;
        }
        if (!invocation.isConsumer()) {
            this.logSlowProducer(invocation, event.getResponse(), operationConfig);
            return;
        }
        if (invocation.isEdge()) {
            this.logSlowEdge(invocation, event.getResponse(), operationConfig);
            return;
        }
        this.logSlowConsumer(invocation, event.getResponse(), operationConfig);
    }

    private String collectClientAddress(Invocation invocation) {
        HttpServletRequestEx requestEx = invocation.getRequestEx();
        return requestEx == null ? "unknown" : requestEx.getRemoteAddr() + ":" + requestEx.getRemotePort();
    }

    private String collectTargetAddress(Invocation invocation) {
        Endpoint endpoint = invocation.getEndpoint();
        return endpoint == null ? "unknown" : endpoint.getEndpoint();
    }

    private String formatTime(double doubleNano) {
        long micros = TimeUnit.NANOSECONDS.toMicros((long)doubleNano);
        return micros / 1000L + "." + micros % 1000L;
    }

    private void logSlowProducer(Invocation invocation, Response response, OperationConfig operationConfig) {
        RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        InvocationStageTrace stageTrace = invocation.getInvocationStageTrace();
        invocation.getTraceIdLogger().warn(LOGGER, "slow({} ms) invocation, {}:\n  http method: {}\n  url        : {}\n  client     : {}\n  status code: {}\n  total      : {} ms\n    prepare                : {} ms\n    threadPoolQueue        : {} ms\n    server filters request : {} ms\n    handlers request       : {} ms\n    business execute       : {} ms\n    handlers response      : {} ms\n    server filters response: {} ms\n    send response          : {} ms", new Object[]{operationConfig.getMsSlowInvocation(), invocation.getInvocationQualifiedName(), restOperationMeta.getHttpMethod(), restOperationMeta.getAbsolutePath(), this.collectClientAddress(invocation), response.getStatusCode(), this.formatTime(stageTrace.calcTotalTime()), this.formatTime(stageTrace.calcInvocationPrepareTime()), this.formatTime(stageTrace.calcThreadPoolQueueTime()), this.formatTime(stageTrace.calcServerFiltersRequestTime()), this.formatTime(stageTrace.calcHandlersRequestTime()), this.formatTime(stageTrace.calcBusinessTime()), this.formatTime(stageTrace.calcHandlersResponseTime()), this.formatTime(stageTrace.calcServerFiltersResponseTime()), this.formatTime(stageTrace.calcSendResponseTime())});
    }

    private void logSlowConsumer(Invocation invocation, Response response, OperationConfig operationConfig) {
        RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        InvocationStageTrace stageTrace = invocation.getInvocationStageTrace();
        invocation.getTraceIdLogger().warn(LOGGER, "slow({} ms) invocation, {}:\n  http method: {}\n  url        : {}\n  server     : {}\n  status code: {}\n  total      : {} ms\n    prepare                : {} ms\n    handlers request       : {} ms\n    client filters request : {} ms\n    send request           : {} ms\n    get connection         : {} ms\n    write to buf           : {} ms\n    wait response          : {} ms\n    wake consumer          : {} ms\n    client filters response: {} ms\n    handlers response      : {} ms", new Object[]{operationConfig.getMsSlowInvocation(), invocation.getInvocationQualifiedName(), restOperationMeta.getHttpMethod(), restOperationMeta.getAbsolutePath(), this.collectTargetAddress(invocation), response.getStatusCode(), this.formatTime(stageTrace.calcTotalTime()), this.formatTime(stageTrace.calcInvocationPrepareTime()), this.formatTime(stageTrace.calcHandlersRequestTime()), this.formatTime(stageTrace.calcClientFiltersRequestTime()), this.formatTime(stageTrace.calcSendRequestTime()), this.formatTime(stageTrace.calcGetConnectionTime()), this.formatTime(stageTrace.calcWriteToBufferTime()), this.formatTime(stageTrace.calcReceiveResponseTime()), this.formatTime(stageTrace.calcWakeConsumer()), this.formatTime(stageTrace.calcClientFiltersResponseTime()), this.formatTime(stageTrace.calcHandlersResponseTime())});
    }

    private void logSlowEdge(Invocation invocation, Response response, OperationConfig operationConfig) {
        RestOperationMeta restOperationMeta = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        InvocationStageTrace stageTrace = invocation.getInvocationStageTrace();
        invocation.getTraceIdLogger().warn(LOGGER, "slow({} ms) invocation, {}:\n  http method: {}\n  url        : {}\n  server     : {}\n  status code: {}\n  total      : {} ms\n    prepare                : {} ms\n    threadPoolQueue        : {} ms\n    server filters request : {} ms\n    handlers request       : {} ms\n    client filters request : {} ms\n    send request           : {} ms\n    get connection         : {} ms\n    write to buf           : {} ms\n    wait response          : {} ms\n    wake consumer          : {} ms\n    client filters response: {} ms\n    handlers response      : {} ms\n    server filters response: {} ms\n    send response          : {} ms", new Object[]{operationConfig.getMsSlowInvocation(), invocation.getInvocationQualifiedName(), restOperationMeta.getHttpMethod(), restOperationMeta.getAbsolutePath(), this.collectTargetAddress(invocation), response.getStatusCode(), this.formatTime(stageTrace.calcTotalTime()), this.formatTime(stageTrace.calcInvocationPrepareTime()), this.formatTime(stageTrace.calcThreadPoolQueueTime()), this.formatTime(stageTrace.calcServerFiltersRequestTime()), this.formatTime(stageTrace.calcHandlersRequestTime()), this.formatTime(stageTrace.calcClientFiltersRequestTime()), this.formatTime(stageTrace.calcSendRequestTime()), this.formatTime(stageTrace.calcGetConnectionTime()), this.formatTime(stageTrace.calcWriteToBufferTime()), this.formatTime(stageTrace.calcReceiveResponseTime()), this.formatTime(stageTrace.calcWakeConsumer()), this.formatTime(stageTrace.calcClientFiltersResponseTime()), this.formatTime(stageTrace.calcHandlersResponseTime()), this.formatTime(stageTrace.calcServerFiltersResponseTime()), this.formatTime(stageTrace.calcSendResponseTime())});
    }
}

