/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn.SoleConnectionDetectionPolicy;
import org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn.SoleConnectionEnforcementPolicy;
import org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn.SoleConnectionEnforcementPolicyException;
import org.apache.qpid.server.security.limit.ConnectionLimiter;
import org.apache.qpid.server.security.limit.ConnectionLimiterService;
import org.apache.qpid.server.security.limit.ConnectionSlot;
import org.apache.qpid.server.transport.AMQPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class StrongConnectionEstablishmentLimiter
implements ConnectionLimiterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrongConnectionEstablishmentLimiter.class);
    private final Map<String, UsageCounter> _slots;
    private final ConnectionLimiter _underlyingLimiter;

    public StrongConnectionEstablishmentLimiter() {
        this._slots = new ConcurrentHashMap<String, UsageCounter>();
        this._underlyingLimiter = ConnectionLimiter.noLimits();
    }

    private StrongConnectionEstablishmentLimiter(StrongConnectionEstablishmentLimiter limiter, ConnectionLimiter underlyingLimiter) {
        this._slots = limiter._slots;
        this._underlyingLimiter = Objects.requireNonNull(underlyingLimiter);
    }

    public String getType() {
        return "EstablishmentPolicy." + String.valueOf(SoleConnectionDetectionPolicy.STRONG);
    }

    public ConnectionSlot register(AMQPConnection<?> connection) {
        if (!(connection instanceof AMQPConnection_1_0) || connection.isClosing()) {
            return this._underlyingLimiter.register(connection);
        }
        LOGGER.debug("Registering a new connection '{}'", connection);
        AMQPConnection_1_0 newConnection = (AMQPConnection_1_0)connection;
        String remoteContainerId = newConnection.getRemoteContainerId();
        if (remoteContainerId == null) {
            LOGGER.warn("The connection '{}' without container ID, 'container-id' is the mandatory field of open frame", connection);
            return this._underlyingLimiter.register(connection);
        }
        LOGGER.debug("Checking a container slot for the connection '{}'", connection);
        try {
            return this._slots.compute(remoteContainerId, (containerId, counter) -> counter == null ? this.newUsageCounter((String)containerId) : counter.addUser()).registerConnection(newConnection);
        }
        catch (RuntimeException e) {
            LOGGER.debug("Registering connection failed", (Throwable)e);
            this.deregisterUser(remoteContainerId);
            throw e;
        }
    }

    private void deregisterUser(String containerId) {
        this._slots.computeIfPresent(containerId, (id, slot) -> slot.removeUser());
    }

    private UsageCounter newUsageCounter(String containerId) {
        return new UsageCounter(new RemoteContainerSlot(containerId), 1L);
    }

    public ConnectionLimiter append(ConnectionLimiter limiter) {
        return new StrongConnectionEstablishmentLimiter(this, this._underlyingLimiter.append(limiter));
    }

    private static final class UsageCounter {
        private final long _counter;
        private final RemoteContainerSlot _slot;

        UsageCounter(RemoteContainerSlot slot, long counter) {
            this._counter = counter;
            this._slot = Objects.requireNonNull(slot);
        }

        public ConnectionSlot registerConnection(AMQPConnection_1_0<?> connection) {
            return this._slot.register(connection);
        }

        public UsageCounter addUser() {
            return new UsageCounter(this._slot, this._counter + 1L);
        }

        public UsageCounter removeUser() {
            return this._counter <= 1L ? null : new UsageCounter(this._slot, this._counter - 1L);
        }
    }

    private final class RemoteContainerSlot {
        private final String _containerId;
        private final Set<AMQPConnection_1_0<?>> _connections = new HashSet();

        RemoteContainerSlot(String containerId) {
            this._containerId = Objects.requireNonNull(containerId);
        }

        private synchronized ConnectionSlot register(AMQPConnection_1_0<?> connection) {
            SoleConnectionEnforcementPolicy soleConnectionPolicy = this.extractPolicy(connection);
            if (soleConnectionPolicy != null && !this._connections.isEmpty()) {
                LOGGER.debug("Single connection is required, sole connection policy: {}", (Object)soleConnectionPolicy);
                throw new SoleConnectionEnforcementPolicyException(soleConnectionPolicy, this._connections, this._containerId);
            }
            ConnectionSlot underlyingSlot = StrongConnectionEstablishmentLimiter.this._underlyingLimiter.register(connection);
            this._connections.add(connection);
            ConnectionSlot slot = () -> {
                try {
                    this.remove(connection);
                }
                finally {
                    StrongConnectionEstablishmentLimiter.this.deregisterUser(this._containerId);
                }
            };
            return slot.chainTo(underlyingSlot);
        }

        private SoleConnectionEnforcementPolicy extractPolicy(AMQPConnection_1_0<?> connection) {
            if (this._connections.isEmpty()) {
                return connection.getSoleConnectionEnforcementPolicy();
            }
            SoleConnectionEnforcementPolicy soleConnectionPolicy = null;
            Iterator<AMQPConnection_1_0<?>> iterator = this._connections.iterator();
            while (iterator.hasNext()) {
                AMQPConnection_1_0<?> existingConnection = iterator.next();
                if (existingConnection.isClosing()) {
                    iterator.remove();
                    continue;
                }
                soleConnectionPolicy = existingConnection.getSoleConnectionEnforcementPolicy();
            }
            if (soleConnectionPolicy == null) {
                return connection.getSoleConnectionEnforcementPolicy();
            }
            return soleConnectionPolicy;
        }

        private synchronized void remove(AMQPConnection_1_0<?> connection) {
            this._connections.remove(connection);
        }
    }
}

