/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.txn.Locker;

public abstract class SecondaryReferenceException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final String secDbName;
    private final DatabaseEntry secKey;
    private final DatabaseEntry priKey;
    private final long expirationTime;

    public SecondaryReferenceException(Locker locker, String message, String secDbName, DatabaseEntry secKey, DatabaseEntry priKey, long expirationTime) {
        super(locker, true, message, null);
        this.secDbName = secDbName;
        this.secKey = secKey;
        this.priKey = priKey;
        this.expirationTime = expirationTime;
        String expirationTimeMsg = "expiration: ";
        expirationTimeMsg = expirationTime != 0L ? expirationTimeMsg + TTL.formatExpirationTime(expirationTime) : expirationTimeMsg + "none";
        this.addErrorMessage(expirationTimeMsg);
        if (locker.getEnvironment().getExposeUserData()) {
            this.addErrorMessage("secDbName=" + secDbName + " secKey=" + secKey + " priKey=" + priKey);
        }
    }

    SecondaryReferenceException(String message, SecondaryReferenceException cause) {
        super(message, cause);
        this.secDbName = cause.secDbName;
        this.secKey = cause.secKey;
        this.priKey = cause.priKey;
        this.expirationTime = cause.expirationTime;
    }

    public String getSecondaryDatabaseName() {
        return this.secDbName;
    }

    public DatabaseEntry getSecondaryKey() {
        return this.secKey;
    }

    public DatabaseEntry getPrimaryKey() {
        return this.priKey;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

