/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;

public final class NumberExpressionFactory {
    private NumberExpressionFactory() {
    }

    private static Function<String, Number> fallbackWrapper(Supplier<Number> callback, Supplier<Number> fallback) {
        return arg -> {
            try {
                return (Number)callback.get();
            }
            catch (NumberFormatException e) {
                return (Number)fallback.get();
            }
        };
    }

    public static Number fromDecimal(String source) {
        Number number = Optional.ofNullable(source).map(text -> text.toUpperCase(Locale.US).endsWith("L") ? text.substring(0, text.length() - 1) : text).map(text -> NumberExpressionFactory.fallbackWrapper(() -> Long.valueOf(text), () -> new BigDecimal((String)text))).map(f -> (Number)f.apply(source)).map(value -> value.longValue() == (long)((int)value.longValue()) ? (Number)value.intValue() : (Number)((Number)value)).orElse(null);
        return NumberConverter.narrow(number);
    }

    public static Number fromHex(String source) {
        Number number = Optional.ofNullable(source).map(text -> Long.parseLong(text.substring(2), 16)).map(value -> value.longValue() == (long)((int)value.longValue()) ? (Number)value.intValue() : (Number)((Number)value)).orElse(null);
        return NumberConverter.narrow(number);
    }

    public static Number fromOctal(String source) {
        Number number = Optional.ofNullable(source).map(text -> Long.parseLong(text, 8)).orElse(null);
        return NumberConverter.narrow(number);
    }

    public static Number fromDouble(String source) {
        Number number = Optional.ofNullable(source).map(Double::parseDouble).orElse(null);
        return NumberConverter.narrow(number);
    }
}

