/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;

public abstract class AbstractAccessControlProvider<X extends AbstractAccessControlProvider<X, Y, T>, Y extends CommonAccessControlProvider<Y>, T extends EventLoggerProvider & ConfiguredObject<?>>
extends AbstractConfiguredObject<X>
implements EventLoggerProvider,
CommonAccessControlProvider<Y> {
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private int _priority;

    public AbstractAccessControlProvider(Map<String, Object> attributes, T parent) {
        super((ConfiguredObject)parent, attributes);
        this._eventLogger = parent.getEventLogger();
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    public final int getPriority() {
        return this._priority;
    }

    @Override
    public int compareTo(Y o) {
        return ACCESS_CONTROL_PROVIDER_COMPARATOR.compare(this, o);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private CompletableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(AccessControlMessages.OPERATION(operation));
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.UPDATE(this.getName(), outcome.name(), this.attributesAsString(attributes)));
    }
}

