/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.KeyManager;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.security.CertificateDetails;

@ManagedObject(defaultType="FileKeyStore")
public interface KeyStore<X extends KeyStore<X>>
extends ConfiguredObject<X> {
    public static final String CERTIFICATE_EXPIRY_WARN_PERIOD = "qpid.keystore.certificateExpiryWarnPeriod";
    @ManagedContextDefault(name="qpid.keystore.certificateExpiryWarnPeriod", description="The number of days before a certificate's expiry that certificate expiration warnings will be written to the log")
    public static final int DEFAULT_CERTIFICATE_EXPIRY_WARN_PERIOD = 30;
    public static final String CERTIFICATE_EXPIRY_CHECK_FREQUENCY = "qpid.keystore.certificateExpiryCheckFrequency";
    @ManagedContextDefault(name="qpid.keystore.certificateExpiryCheckFrequency", description="Period (in days) with which the Broker will repeat the certificate expiration warning")
    public static final int DEFAULT_CERTIFICATE_EXPIRY_CHECK_FREQUENCY = 1;

    @DerivedAttribute
    public int getCertificateExpiryWarnPeriod();

    @DerivedAttribute
    public int getCertificateExpiryCheckFrequency();

    public KeyManager[] getKeyManagers() throws GeneralSecurityException;

    @DerivedAttribute(description="List of details about the certificates like validity dates, SANs, issuer and subject names, etc.")
    public List<CertificateDetails> getCertificateDetails();
}

