/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging;

import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class TerminusDurability
implements RestrictedType<UnsignedInteger> {
    private final UnsignedInteger _val;
    public static final TerminusDurability NONE = new TerminusDurability(UnsignedInteger.valueOf(0));
    public static final TerminusDurability CONFIGURATION = new TerminusDurability(UnsignedInteger.valueOf(1));
    public static final TerminusDurability UNSETTLED_STATE = new TerminusDurability(UnsignedInteger.valueOf(2));

    private TerminusDurability(UnsignedInteger val) {
        this._val = val;
    }

    @Override
    public UnsignedInteger getValue() {
        return this._val;
    }

    public String toString() {
        if (this == NONE) {
            return "none";
        }
        if (this == CONFIGURATION) {
            return "configuration";
        }
        if (this == UNSETTLED_STATE) {
            return "unsettled-state";
        }
        return String.valueOf(this._val);
    }

    public static TerminusDurability valueOf(Object obj) {
        if (obj instanceof UnsignedInteger) {
            UnsignedInteger val = (UnsignedInteger)obj;
            if (TerminusDurability.NONE._val.equals(val)) {
                return NONE;
            }
            if (TerminusDurability.CONFIGURATION._val.equals(val)) {
                return CONFIGURATION;
            }
            if (TerminusDurability.UNSETTLED_STATE._val.equals(val)) {
                return UNSETTLED_STATE;
            }
        }
        String message = String.format("Cannot convert '%s' into 'terminus-durability'", obj);
        throw new IllegalArgumentException(message);
    }

    public static TerminusDurability min(TerminusDurability durabilityA, TerminusDurability durabilityB) {
        int durabilitAValue = durabilityA != null ? durabilityA._val.intValue() : 0;
        int durabilityBValue = durabilityB != null ? durabilityB._val.intValue() : 0;
        return TerminusDurability.valueOf(new UnsignedInteger(Math.min(durabilitAValue, durabilityBValue)));
    }
}

