/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.nio.BufferUnderflowException;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.plugin.MessageFormat;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@PluggableService
public class MessageFormat_0_9_1
implements MessageFormat<AMQMessage> {
    public static final int AMQP_MESSAGE_FORMAT_0_9_1 = 91;
    private static final byte MANDATORY_MASK = 1;
    private static final byte IMMEDIATE_MASK = 2;

    public String getType() {
        return "AMQP_0_9_1";
    }

    public int getSupportedFormat() {
        return 91;
    }

    public Class<AMQMessage> getMessageClass() {
        return AMQMessage.class;
    }

    public QpidByteBuffer convertToMessageFormat(AMQMessage message) {
        MessagePublishInfo messagePublishInfo = message.getMessagePublishInfo();
        ContentHeaderBody contentHeaderBody = message.getContentHeaderBody();
        AMQShortString exchange = messagePublishInfo.getExchange();
        AMQShortString routingKey = messagePublishInfo.getRoutingKey();
        int length = contentHeaderBody.getSize() + (exchange == null ? 0 : exchange.length()) + (routingKey == null ? 0 : routingKey.length()) + 3;
        try (QpidByteBuffer headerBuf = QpidByteBuffer.allocateDirect((int)length);){
            QpidByteBuffer qpidByteBuffer;
            block13: {
                QpidByteBuffer content = message.getContent();
                try {
                    byte flags;
                    EncodingUtils.writeShortStringBytes(headerBuf, exchange);
                    EncodingUtils.writeShortStringBytes(headerBuf, routingKey);
                    byte by = flags = messagePublishInfo.isMandatory() ? (byte)0 : 1;
                    if (messagePublishInfo.isImmediate()) {
                        flags = (byte)(flags | 2);
                    }
                    headerBuf.put(flags);
                    headerBuf.flip();
                    contentHeaderBody.writePayload(headerBuf);
                    qpidByteBuffer = QpidByteBuffer.concatenate((QpidByteBuffer[])new QpidByteBuffer[]{headerBuf, content});
                    if (content == null) break block13;
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                content.close();
            }
            return qpidByteBuffer;
        }
    }

    public AMQMessage createMessage(QpidByteBuffer payload, MessageStore store, Object connectionReference) {
        try {
            AMQShortString exchange = this.readShortString(payload);
            AMQShortString routingKey = this.readShortString(payload);
            byte flags = payload.get();
            MessagePublishInfo publishBody = new MessagePublishInfo(exchange, (flags & 2) != 0, (flags & 1) != 0, routingKey);
            ContentHeaderBody contentHeaderBody = this.readContentBody(payload);
            MessageMetaData mmd = new MessageMetaData(publishBody, contentHeaderBody);
            MessageHandle handle = store.addMessage((StorableMessageMetaData)mmd);
            handle.addContent(payload);
            StoredMessage storedMessage = handle.allContentAdded();
            return new AMQMessage((StoredMessage<MessageMetaData>)storedMessage, connectionReference);
        }
        catch (BufferUnderflowException | AMQFrameDecodingException e) {
            throw new ConnectionScopedRuntimeException("Error parsing AMQP 0-9-1 message format", (Throwable)e);
        }
    }

    private ContentHeaderBody readContentBody(QpidByteBuffer buf) throws AMQFrameDecodingException {
        long size = buf.getUnsignedInt();
        try (QpidByteBuffer buffer = this.readByteBuffer(buf, size);){
            long newPosition = (long)buf.position() + size;
            if (newPosition > Integer.MAX_VALUE) {
                throw new IllegalStateException(String.format("trying to advance QBB to %d which is larger than MAX_INT", newPosition));
            }
            buf.position((int)newPosition);
            ContentHeaderBody contentHeaderBody = new ContentHeaderBody(buffer, size);
            return contentHeaderBody;
        }
    }

    private QpidByteBuffer readByteBuffer(QpidByteBuffer data, long size) {
        return data.view(0, (int)size);
    }

    private int readInt(List<QpidByteBuffer> data) {
        int required = 4;
        int result = 0;
        for (QpidByteBuffer buf : data) {
            if (required == 4 && buf.remaining() >= 4) {
                return buf.getInt();
            }
            while (buf.remaining() > 0) {
                result <<= 8;
                result |= buf.get() & 0xFF;
                if (--required != 0) continue;
                return result;
            }
        }
        throw new BufferUnderflowException();
    }

    private AMQShortString readShortString(QpidByteBuffer data) {
        return AMQShortString.readAMQShortString(data);
    }
}

