/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class AliasKeyManager
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager delegateKeyManager;
    private final String serverAlias;
    private final String clientAlias;

    public AliasKeyManager(X509ExtendedKeyManager delegateKeyManager, String serverAlias, String clientAlias) {
        this.delegateKeyManager = delegateKeyManager;
        this.serverAlias = serverAlias;
        this.clientAlias = clientAlias;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegateKeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.clientAlias != null) {
            return this.clientAlias;
        }
        return this.delegateKeyManager.chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegateKeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.serverAlias != null) {
            return this.serverAlias;
        }
        return this.delegateKeyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegateKeyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegateKeyManager.getPrivateKey(alias);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        if (this.clientAlias != null) {
            return this.clientAlias;
        }
        return this.delegateKeyManager.chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.serverAlias != null) {
            return this.serverAlias;
        }
        return this.delegateKeyManager.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

