/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback.jdbc;

import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.classic.db.names.DBNameResolver;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.logback.jdbc.JDBCSettingsDBNameResolver;
import org.apache.qpid.server.logging.logback.jdbc.JDBCSettingsDrivenConnectionSource;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JDBCLoggerHelper {
    static final ch.qos.logback.classic.Logger ROOT_LOGGER = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCLoggerHelper.class);

    JDBCLoggerHelper() {
    }

    Appender<ILoggingEvent> createAppenderInstance(Context context, ConfiguredObject<?> logger, JDBCSettings settings) {
        try {
            JDBCSettingsDBNameResolver dbNameResolver = new JDBCSettingsDBNameResolver(settings);
            ConnectionSource connectionSource = this.createConnectionSource(context, logger, settings);
            DBAppender appender = new DBAppender();
            appender.setDbNameResolver((DBNameResolver)dbNameResolver);
            appender.setConnectionSource(connectionSource);
            appender.setContext(context);
            appender.start();
            return appender;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create appender", (Throwable)e);
            throw new IllegalConfigurationException("Cannot create appender");
        }
    }

    void restartAppenderIfExists(Appender appender) {
        if (appender != null) {
            appender.stop();
            appender.start();
        }
    }

    void restartConnectionSourceIfExists(Appender appender) {
        ConnectionSource connectionSource;
        if (appender instanceof DBAppender && (connectionSource = ((DBAppender)appender).getConnectionSource()) != null) {
            connectionSource.stop();
            connectionSource.start();
        }
    }

    void validateConnectionSourceSettings(ConfiguredObject<?> logger, JDBCSettings settings) {
        try {
            ConnectionSource connectionSource = this.createConnectionSource(logger, settings);
            connectionSource.getConnection().close();
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Cannot create connection source from given URL, credentials and connection pool type");
        }
    }

    private ConnectionSource createConnectionSource(ConfiguredObject<?> logger, JDBCSettings settings) {
        return this.createConnectionSource((Context)ROOT_LOGGER.getLoggerContext(), logger, settings);
    }

    private ConnectionSource createConnectionSource(Context context, ConfiguredObject<?> logger, JDBCSettings settings) {
        JDBCSettingsDrivenConnectionSource connectionSource = new JDBCSettingsDrivenConnectionSource(logger, settings);
        connectionSource.setContext(context);
        connectionSource.start();
        return connectionSource;
    }
}

