/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.LegacyCategoryController;
import org.apache.qpid.server.model.ConfiguredObject;

class VirtualHostController
extends LegacyCategoryController {
    public static final String TYPE = "VirtualHost";

    VirtualHostController(LegacyManagementController legacyManagementController, Set<TypeController> typeControllers) {
        super(legacyManagementController, TYPE, new String[]{"VirtualHostNode"}, "ProvidedStore", typeControllers);
    }

    @Override
    public LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject object) {
        return new LegacyVirtualHost(this.getManagementController(), object);
    }

    @Override
    public Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        Map context = (Map)attributes.get("context");
        if (attributes.containsKey("queue_deadLetterQueueEnabled") || context != null && context.containsKey("queue.deadLetterQueueEnabled")) {
            LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(attributes);
            converted.remove("queue_deadLetterQueueEnabled");
            if (context != null) {
                LinkedHashMap convertedContext = new LinkedHashMap(context);
                converted.put("context", convertedContext);
                convertedContext.remove("queue.deadLetterQueueEnabled");
            }
            return converted;
        }
        return attributes;
    }

    public static class LegacyVirtualHost
    extends GenericLegacyConfiguredObject {
        static final String QUEUE_DEAD_LETTER_QUEUE_ENABLED = "queue_deadLetterQueueEnabled";
        private static final String MODEL_VERSION = "modelVersion";

        LegacyVirtualHost(LegacyManagementController managementController, LegacyConfiguredObject nextVersionLegacyConfiguredObject) {
            super(managementController, nextVersionLegacyConfiguredObject, VirtualHostController.TYPE);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return super.getAttributeNames();
        }

        @Override
        public Object getAttribute(String name) {
            if (MODEL_VERSION.equals(name)) {
                return this.getManagementController().getVersion();
            }
            if (QUEUE_DEAD_LETTER_QUEUE_ENABLED.equals(name)) {
                return false;
            }
            return super.getAttribute(name);
        }

        @Override
        public ManagementResponse invoke(String operation, Map<String, Object> parameters, boolean isSecure) {
            if ("resetStatistics".equalsIgnoreCase(operation)) {
                throw ManagementException.createGoneManagementException("Method 'resetStatistics' was removed");
            }
            return super.invoke(operation, parameters, isSecure);
        }
    }
}

