/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;

public abstract class Rule {
    private boolean _terminating;

    public abstract Handler matchAndApply(Handler var1) throws IOException;

    public boolean isTerminating() {
        return this._terminating;
    }

    public void setTerminating(boolean value) {
        this._terminating = value;
    }

    public String toString() {
        return "%s@%x[terminating=%b]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.isTerminating());
    }

    public static class HttpURIHandler
    extends Handler {
        private final HttpURI _uri;

        public HttpURIHandler(Handler handler, HttpURI uri) {
            super(handler);
            this._uri = uri;
        }

        public HttpURI getHttpURI() {
            return this._uri;
        }
    }

    public static class Handler
    extends Request.Wrapper {
        private Handler _nextRuleHandler;

        protected Handler(Request request) {
            super(request);
        }

        public Handler(Handler handler) {
            super((Request)handler);
            handler._nextRuleHandler = this;
        }

        protected boolean handle(Response response, Callback callback) throws Exception {
            return this._nextRuleHandler.handle(response, callback);
        }
    }
}

