/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.memory;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jdk.jfr.consumer.RecordedEvent;

public final class G1HeapSummaryHandler
implements RecordedEventHandler {
    private static final Logger logger = Logger.getLogger(G1HeapSummaryHandler.class.getName());
    private static final String EVENT_NAME = "jdk.G1HeapSummary";
    private static final String BEFORE = "Before GC";
    private static final String AFTER = "After GC";
    private static final String GC_ID = "gcId";
    private static final String EDEN_USED_SIZE = "edenUsedSize";
    private static final String EDEN_TOTAL_SIZE = "edenTotalSize";
    private static final String SURVIVOR_USED_SIZE = "survivorUsedSize";
    private static final String WHEN = "when";
    private static final Attributes ATTR_MEMORY_EDEN = Attributes.of(Constants.ATTR_TYPE, (Object)"heap", Constants.ATTR_POOL, (Object)"G1 Eden Space");
    private static final Attributes ATTR_MEMORY_SURVIVOR = Attributes.of(Constants.ATTR_TYPE, (Object)"heap", Constants.ATTR_POOL, (Object)"G1 Survivor Space");
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long usageEden = 0L;
    private volatile long usageEdenAfter = 0L;
    private volatile long usageSurvivor = 0L;
    private volatile long usageSurvivorAfter = 0L;
    private volatile long committedEden = 0L;

    public G1HeapSummaryHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.usage").setDescription("Measure of memory used").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.usageEden, ATTR_MEMORY_EDEN);
            measurement.record(this.usageSurvivor, ATTR_MEMORY_SURVIVOR);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.usage_after_last_gc").setDescription("Measure of memory used, as measured after the most recent garbage collection event on this pool").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.usageEdenAfter, ATTR_MEMORY_EDEN);
            measurement.record(this.usageSurvivorAfter, ATTR_MEMORY_SURVIVOR);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.committed").setDescription("Measure of memory committed").setUnit("By").buildWithCallback(measurement -> measurement.record(this.committedEden, ATTR_MEMORY_EDEN)));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.MEMORY_POOL_METRICS;
    }

    @Override
    public void accept(RecordedEvent ev) {
        if (!ev.hasField(WHEN)) {
            logger.fine(String.format("G1 GC Event seen without when: %s", ev));
            return;
        }
        String when = ev.getString(WHEN);
        if (!BEFORE.equals(when) && !AFTER.equals(when)) {
            logger.fine(String.format("G1 GC Event seen where when is neither before nor after: %s", ev));
            return;
        }
        if (!ev.hasField(GC_ID)) {
            logger.fine(String.format("G1 GC Event seen without GC ID: %s", ev));
            return;
        }
        this.recordValues(ev, BEFORE.equals(when));
    }

    private void recordValues(RecordedEvent event, boolean before) {
        if (event.hasField(EDEN_USED_SIZE)) {
            if (before) {
                this.usageEden = event.getLong(EDEN_USED_SIZE);
            } else {
                this.usageEdenAfter = event.getLong(EDEN_USED_SIZE);
            }
        }
        if (event.hasField(SURVIVOR_USED_SIZE)) {
            if (before) {
                this.usageSurvivor = event.getLong(SURVIVOR_USED_SIZE);
            } else {
                this.usageSurvivorAfter = event.getLong(SURVIVOR_USED_SIZE);
            }
        }
        if (event.hasField(EDEN_TOTAL_SIZE)) {
            this.committedEden = event.getLong(EDEN_TOTAL_SIZE);
        }
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

