---
layout: page
title: CVE-2025-47436
---

# Potential Heap Buffer Overflow during C++ LZO Decompression

## Date:
2025-05-13

## Severity:

Medium

## Vendor:

[The Apache Software Foundation](https://apache.org)

## Versions Affected:

- Apache ORC through 1.8.8
- Apache ORC 1.9.0 through 1.9.5
- Apache ORC 2.0.0 through 2.0.4
- Apache ORC 2.1.0 through 2.1.1

## Description:

A vulnerability has been identified in the ORC C++ LZO decompression logic,
where specially crafted malformed ORC files can cause the decompressor
to allocate a 250-byte buffer but then attempts to copy 295 bytes into it.
It causes memory corruption due to insufficient input buffer boundary validation during decompression.

This issue is being tracked as ORC-1879 

## Mitigation:

* Upgrade to 1.8.9, 1.9.6, 2.0.5, and 2.1.2

## Credit:

This issue was discovered by Jason Villaluna.

## References:
[Apache ORC security](/security)
