/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.menu;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.app.WhiteboardManager;
import org.apache.openmeetings.web.common.InvitationDialog;
import org.apache.openmeetings.web.common.menu.OmMenuItem;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.menu.RoomInvitationForm;
import org.apache.openmeetings.web.room.menu.RoomMenuPanel;
import org.apache.openmeetings.web.room.menu.SipDialerDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.injection.Injector;

public class ActionsSubMenu
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RoomPanel room;
    private final RoomMenuPanel mp;
    private InvitationDialog invite;
    private SipDialerDialog sipDialer;
    private OmMenuItem actionsMenu;
    private OmMenuItem inviteMenuItem;
    private OmMenuItem shareMenuItem;
    private OmMenuItem applyModerMenuItem;
    private OmMenuItem applyWbMenuItem;
    private OmMenuItem applyAvMenuItem;
    private OmMenuItem sipDialerMenuItem;
    private OmMenuItem downloadPngMenuItem;
    private OmMenuItem downloadPdfMenuItem;
    private OmMenuItem resetWb;
    private OmMenuItem localSettings;
    private final boolean visible;
    @Inject
    private WhiteboardManager wbManager;

    public ActionsSubMenu(RoomPanel room, RoomMenuPanel mp) {
        Injector.get().inject((Object)this);
        this.room = room;
        this.mp = mp;
        this.visible = !room.getRoom().isHidden(Room.RoomElement.ACTION_MENU);
    }

    public void init() {
        String roomInviteDialogId = "roomInviteDialog";
        RoomInvitationForm rif = new RoomInvitationForm("form", this.room.getRoom().getId(), "roomInviteDialog");
        this.invite = new InvitationDialog("roomInviteDialog", rif);
        this.mp.add(new Component[]{this.invite});
        rif.setDialog(this.invite);
        this.sipDialer = new SipDialerDialog("sipDialer", this.room);
        this.mp.add(new Component[]{this.sipDialer});
        this.actionsMenu = new OmMenuItem(this.mp.getString("635"), null, false);
        this.inviteMenuItem = new OmMenuItem(this.mp.getString("213"), this.mp.getString("1489"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.this.invite.updateModel(target);
                ActionsSubMenu.this.invite.show((IPartialPageRequestHandler)target);
            }
        };
        this.shareMenuItem = new OmMenuItem(this.mp.getString("239"), this.mp.getString("1480"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                target.appendJavaScript((CharSequence)"Sharer.open();");
            }
        };
        this.applyModerMenuItem = new OmMenuItem(this.mp.getString("784"), this.mp.getString("1481"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.this.room.requestRight(Room.Right.MODERATOR, (IPartialPageRequestHandler)target);
            }
        };
        this.applyWbMenuItem = new OmMenuItem(this.mp.getString("785"), this.mp.getString("1492"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.this.room.requestRight(Room.Right.WHITEBOARD, (IPartialPageRequestHandler)target);
            }
        };
        this.applyAvMenuItem = new OmMenuItem(this.mp.getString("786"), this.mp.getString("1482"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.this.room.requestRight(Room.Right.VIDEO, (IPartialPageRequestHandler)target);
            }
        };
        this.sipDialerMenuItem = new OmMenuItem(this.mp.getString("1447"), this.mp.getString("1488"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.this.sipDialer.show((IPartialPageRequestHandler)target);
            }
        };
        this.downloadPngMenuItem = new OmMenuItem(this.mp.getString("download.png"), this.mp.getString("download.png")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.download(target, "png");
            }
        };
        this.downloadPdfMenuItem = new OmMenuItem(this.mp.getString("download.pdf"), this.mp.getString("download.pdf")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.download(target, "pdf");
            }
        };
        this.resetWb = new OmMenuItem(this.mp.getString("reset.whiteboard"), this.mp.getString("reset.whiteboard")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                ActionsSubMenu.this.wbManager.reset(ActionsSubMenu.this.room.getRoom().getId(), WebSession.getUserId());
            }
        };
        this.localSettings = new OmMenuItem(this.mp.getString("edit.settings"), this.mp.getString("edit.settings")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                attributes.getAjaxCallListeners().add(new IAjaxCallListener(){

                    public CharSequence getPrecondition(Component component) {
                        return "UserSettings.open(); return false;";
                    }
                });
            }
        };
    }

    OmMenuItem getMenu() {
        this.actionsMenu.add(this.inviteMenuItem).add(this.shareMenuItem).add(this.applyModerMenuItem).add(this.applyWbMenuItem).add(this.applyAvMenuItem).add(this.sipDialerMenuItem);
        if (Room.Type.INTERVIEW != this.room.getRoom().getType()) {
            this.actionsMenu.add(this.downloadPngMenuItem).add(this.downloadPdfMenuItem).add(this.resetWb);
        }
        this.actionsMenu.add(this.localSettings);
        return this.actionsMenu;
    }

    public void update(boolean moder, boolean notExternalUser) {
        if (!this.visible) {
            return;
        }
        Room r = this.room.getRoom();
        boolean isInterview = Room.Type.INTERVIEW == r.getType();
        this.downloadPngMenuItem.setVisible(!isInterview);
        this.downloadPdfMenuItem.setVisible(!isInterview);
        this.actionsMenu.setVisible(moder || r.isAllowUserQuestions());
        this.inviteMenuItem.setVisible(notExternalUser && moder);
        boolean shareVisible = this.room.screenShareAllowed();
        this.shareMenuItem.setVisible(shareVisible);
        this.applyModerMenuItem.setVisible(!moder);
        this.applyWbMenuItem.setVisible(!this.room.getClient().hasRight(Room.Right.WHITEBOARD));
        this.applyAvMenuItem.setVisible(!this.room.getClient().hasRight(Room.Right.AUDIO) || !this.room.getClient().hasRight(Room.Right.VIDEO));
        this.sipDialerMenuItem.setVisible(r.isSipEnabled() && OpenmeetingsVariables.isSipEnabled());
        this.resetWb.setVisible(moder);
    }

    private static void download(AjaxRequestTarget target, String type) {
        target.appendJavaScript((CharSequence)String.format("WbArea.download('%s');", type));
    }

    public boolean isVisible() {
        return this.visible;
    }
}

