/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.ReleaseReferencesStrategy;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.ThreadAffinityTask;
import gov.nist.javax.sip.address.AddressFactoryImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPClientTransactionImpl;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.sip.Dialog;
import javax.sip.IOExceptionEvent;
import javax.sip.TransactionState;
import javax.sip.address.SipURI;
import javax.sip.message.Request;
import javax.sip.message.Response;

public abstract class SIPTransactionImpl
implements SIPTransaction {
    private static StackLogger logger = CommonLogger.getLogger(SIPTransaction.class);
    private static final Pattern EXTRACT_CN = Pattern.compile(".*CN\\s*=\\s*([\\w*\\.\\-_]+).*");
    protected boolean toListener;
    protected int baseTimerInterval = 500;
    protected int T4 = 5000 / this.baseTimerInterval;
    protected int T2 = 4000 / this.baseTimerInterval;
    protected int timerI = this.T4;
    protected int timerK = this.T4;
    protected int timerD = 32000 / this.baseTimerInterval;
    protected transient Object applicationData;
    protected SIPResponse lastResponse;
    protected boolean isMapped;
    private transient TransactionSemaphore semaphore;
    protected String transactionId;
    protected long auditTag = 0L;
    protected transient SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    protected byte[] originalRequestBytes;
    protected long originalRequestCSeqNumber;
    protected String originalRequestBranch;
    protected boolean originalRequestHasPort;
    protected transient MessageChannel encapsulatedChannel;
    protected AtomicBoolean transactionTimerStarted = new AtomicBoolean(false);
    private String branch;
    private String method;
    private int currentState = -1;
    private transient int retransmissionTimerLastTickCount;
    private transient int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private transient Set<SIPTransactionEventListener> eventListeners;
    protected int collectionTime;
    private boolean terminatedEventDelivered;
    private ReleaseReferencesStrategy releaseReferencesStrategy;
    private Boolean inviteTransaction = null;
    private Boolean dialogCreatingTransaction = null;
    private String forkId = null;
    protected String mergeId = null;
    public SIPClientTransactionImpl.ExpiresTimerTask expiresTimerTask;
    private MaxTxLifeTimeListener maxTxLifeTimeListener;

    @Override
    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransactionImpl(SIPTransactionStack newParentStack, MessageChannel newEncapsulatedChannel) {
        this.sipStack = newParentStack;
        this.semaphore = new TransactionSemaphore();
        this.encapsulatedChannel = newEncapsulatedChannel;
        if (this.isReliable()) {
            ++this.encapsulatedChannel.useCount;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("use count for encapsulated channel" + this + " " + this.encapsulatedChannel.useCount);
            }
        }
        this.currentState = -1;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = new CopyOnWriteArraySet<SIPTransactionEventListener>();
        this.addEventListener(newParentStack);
        this.releaseReferencesStrategy = this.sipStack.getReleaseReferencesStrategy();
    }

    @Override
    public abstract void cleanUp();

    @Override
    public void setOriginalRequest(SIPRequest newOriginalRequest) {
        String newTransactionId = newOriginalRequest.getTransactionId();
        if (this.originalRequest != null && !this.originalRequest.getTransactionId().equals(newTransactionId)) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = newOriginalRequest;
        this.originalRequestCSeqNumber = newOriginalRequest.getCSeq().getSeqNumber();
        Via topmostVia = newOriginalRequest.getTopmostVia();
        this.originalRequestBranch = topmostVia.getBranch();
        this.originalRequestHasPort = topmostVia.hasPort();
        int originalRequestViaPort = topmostVia.getPort();
        if (originalRequestViaPort == -1) {
            originalRequestViaPort = topmostVia.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060;
        }
        this.method = newOriginalRequest.getMethod();
        this.transactionId = newTransactionId;
        this.originalRequest.setTransaction(this);
        String newBranch = topmostVia.getBranch();
        if (newBranch != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Setting Branch id : " + newBranch);
            }
            this.setBranch(newBranch);
        } else {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Branch id is null - compute TID!" + newOriginalRequest.encode());
            }
            this.setBranch(newTransactionId);
        }
    }

    @Override
    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public Request getRequest() {
        block4: {
            if (this.getReleaseReferencesStrategy() != ReleaseReferencesStrategy.None && this.originalRequest == null && this.originalRequestBytes != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("reparsing original request " + this.originalRequestBytes + " since it was eagerly cleaned up, but beware this is not efficient with the aggressive flag set !");
                }
                try {
                    this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
                }
                catch (ParseException e) {
                    if (!logger.isLoggingEnabled(32)) break block4;
                    logger.logDebug("message " + this.originalRequestBytes + " could not be reparsed !", e);
                }
            }
        }
        return this.originalRequest;
    }

    @Override
    public boolean isDialogCreatingTransaction() {
        if (this.dialogCreatingTransaction == null) {
            this.dialogCreatingTransaction = this.isInviteTransaction() || this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER");
        }
        return this.dialogCreatingTransaction;
    }

    @Override
    public boolean isInviteTransaction() {
        if (this.inviteTransaction == null) {
            this.inviteTransaction = this.getMethod().equals("INVITE");
        }
        return this.inviteTransaction;
    }

    @Override
    public boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    @Override
    public boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    @Override
    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    @Override
    public void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    @Override
    public String getBranch() {
        if (this.branch == null) {
            this.branch = this.originalRequestBranch;
        }
        return this.branch;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public long getCSeq() {
        return this.originalRequestCSeqNumber;
    }

    @Override
    public void setState(int newState) {
        if (this.currentState == 3 && newState != 5 && newState != 4) {
            newState = 3;
        }
        if (this.currentState == 4 && newState != 5) {
            newState = 4;
        }
        if (this.currentState != 5) {
            this.currentState = newState;
        } else {
            newState = this.currentState;
        }
        if (newState == 3) {
            this.enableTimeoutTimer(64);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction:setState " + newState + " " + this + " branchID = " + this.getBranch() + " isClient = " + (this instanceof SIPClientTransaction));
            logger.logStackTrace();
        }
    }

    @Override
    public int getInternalState() {
        return this.currentState;
    }

    @Override
    public TransactionState getState() {
        if (this.currentState < 0) {
            return null;
        }
        return TransactionState.getObject(this.currentState);
    }

    protected void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerTicksLeft = this.isInviteTransaction() && this instanceof SIPClientTransaction ? tickCount : Math.min(tickCount, this.getTimerT2());
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft;
    }

    @Override
    public void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected void enableTimeoutTimer(int tickCount) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("enableTimeoutTimer " + this + " tickCount " + tickCount + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = tickCount;
    }

    @Override
    public void disableTimeoutTimer() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("disableTimeoutTimer " + this);
        }
        this.timeoutTimerTicksLeft = -1;
    }

    @Override
    public void fireTimer() {
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    @Override
    public boolean isTerminated() {
        return this.currentState == 5;
    }

    @Override
    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    @Override
    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    @Override
    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public String getPeerAddress() {
        return this.encapsulatedChannel.getPeerAddress();
    }

    @Override
    public int getPeerPort() {
        return this.encapsulatedChannel.getPeerPort();
    }

    @Override
    public int getPeerPacketSourcePort() {
        return this.encapsulatedChannel.getPeerPacketSourcePort();
    }

    @Override
    public InetAddress getPeerPacketSourceAddress() {
        return this.encapsulatedChannel.getPeerPacketSourceAddress();
    }

    public InetAddress getPeerInetAddress() {
        return this.encapsulatedChannel.getPeerInetAddress();
    }

    @Override
    public String getPeerProtocol() {
        return this.encapsulatedChannel.getPeerProtocol();
    }

    @Override
    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    @Override
    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    @Override
    public Via getViaHeader() {
        Via channelViaHeader = this.encapsulatedChannel.getViaHeader();
        try {
            channelViaHeader.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return channelViaHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(final SIPMessage messageToSend) throws IOException {
        try {
            final RawMessageChannel channel = (RawMessageChannel)((Object)this.encapsulatedChannel);
            for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                boolean addrmatch = messageProcessor.getIpAddress().getHostAddress().toString().equals(this.getPeerAddress());
                if (!addrmatch || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
                if (channel instanceof TCPMessageChannel) {
                    try {
                        ThreadAffinityTask processMessageTask = new ThreadAffinityTask(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        ((TCPMessageChannel)channel).processMessage((SIPMessage)messageToSend.clone(), SIPTransactionImpl.this.getPeerInetAddress());
                                    }
                                    catch (Exception ex) {
                                        if (!logger.isLoggingEnabled(4)) break block2;
                                        logger.logError("Error self routing TCP message cause by: ", ex);
                                    }
                                }
                            }

                            @Override
                            public Object getThreadHash() {
                                return messageToSend.getCallId().getCallId();
                            }
                        };
                        this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
                    }
                    catch (Exception e) {
                        logger.logError("Error passing message in self routing TCP", e);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Self routing message TCP");
                    }
                    return;
                }
                if (channel instanceof TLSMessageChannel) {
                    try {
                        ThreadAffinityTask processMessageTask = new ThreadAffinityTask(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        ((TLSMessageChannel)channel).processMessage((SIPMessage)messageToSend.clone(), SIPTransactionImpl.this.getPeerInetAddress());
                                    }
                                    catch (Exception ex) {
                                        if (!logger.isLoggingEnabled(4)) break block2;
                                        logger.logError("Error self routing TLS message cause by: ", ex);
                                    }
                                }
                            }

                            @Override
                            public Object getThreadHash() {
                                return messageToSend.getCallId().getCallId();
                            }
                        };
                        this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
                    }
                    catch (Exception e) {
                        logger.logError("Error passing message in TLS self routing", e);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Self routing message TLS");
                    }
                    return;
                }
                if (!(channel instanceof RawMessageChannel)) continue;
                try {
                    ThreadAffinityTask processMessageTask = new ThreadAffinityTask(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    channel.processMessage((SIPMessage)messageToSend.clone());
                                }
                                catch (Exception ex) {
                                    if (!logger.isLoggingEnabled(4)) break block2;
                                    logger.logError("Error self routing message cause by: ", ex);
                                }
                            }
                        }

                        @Override
                        public Object getThreadHash() {
                            return messageToSend.getCallId().getCallId();
                        }
                    };
                    this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
                }
                catch (Exception e) {
                    logger.logError("Error passing message in self routing", e);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Self routing message");
                }
                return;
            }
            this.encapsulatedChannel.sendMessage(messageToSend, this.getPeerInetAddress(), this.getPeerPort());
        }
        finally {
            this.startTransactionTimer();
        }
    }

    public void sendMessage(byte[] messageBytes, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        throw new IOException("Cannot send unparsed message through Transaction Channel!");
    }

    @Override
    public void addEventListener(SIPTransactionEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    @Override
    public void removeEventListener(SIPTransactionEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raiseErrorEvent(int errorEventID) {
        SIPTransactionErrorEvent newErrorEvent = new SIPTransactionErrorEvent(this, errorEventID);
        Set<SIPTransactionEventListener> set = this.eventListeners;
        synchronized (set) {
            for (SIPTransactionEventListener nextListener : this.eventListeners) {
                nextListener.transactionErrorEvent(newErrorEvent);
            }
        }
        if (errorEventID != 3) {
            this.eventListeners.clear();
            this.setState(5);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).setState(3);
            }
        }
    }

    @Override
    public boolean isServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    @Override
    public abstract Dialog getDialog();

    @Override
    public abstract void setDialog(SIPDialog var1, String var2);

    @Override
    public int getRetransmitTimer() {
        return 500;
    }

    @Override
    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    @Override
    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public Response getResponse() {
        return this.lastResponse;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    @Override
    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    @Override
    public boolean doesCancelMatchTransaction(SIPRequest requestToTest) {
        boolean transactionMatches = false;
        SIPRequest origRequest = this.getOriginalRequest();
        if (origRequest == null || this.getMethod().equals("CANCEL")) {
            return false;
        }
        Via topViaHeader = requestToTest.getTopmostVia();
        if (topViaHeader != null) {
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(origRequest.getTopmostVia().getSentBy())) {
                    transactionMatches = true;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("returning  true");
                    }
                }
            } else {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("testing against " + origRequest);
                }
                if (origRequest.getRequestURI().equals(requestToTest.getRequestURI()) && origRequest.getTo().equals(requestToTest.getTo()) && origRequest.getFrom().equals(requestToTest.getFrom()) && origRequest.getCallId().getCallId().equals(requestToTest.getCallId().getCallId()) && origRequest.getCSeq().getSeqNumber() == requestToTest.getCSeq().getSeqNumber() && topViaHeader.equals(origRequest.getTopmostVia())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    @Override
    public void setRetransmitTimer(int retransmitTimer) {
        if (retransmitTimer <= 0) {
            throw new IllegalArgumentException("Retransmit timer must be positive!");
        }
        if (this.transactionTimerStarted.get()) {
            throw new IllegalStateException("Transaction timer is already started");
        }
        this.baseTimerInterval = retransmitTimer;
    }

    @Override
    public void close() {
        this.encapsulatedChannel.close();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.encapsulatedChannel);
        }
    }

    @Override
    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    @Override
    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    @Override
    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public Object getApplicationData() {
        return this.applicationData;
    }

    @Override
    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        if (this instanceof SIPClientTransaction) {
            this.encapsulatedChannel.setEncapsulatedClientTransaction((SIPClientTransaction)((Object)this));
        }
    }

    @Override
    public SipProviderImpl getSipProvider() {
        return this.getMessageProcessor().getListeningPoint().getProvider();
    }

    @Override
    public void raiseIOExceptionEvent() {
        this.setState(5);
        String host = this.getPeerAddress();
        int port = this.getPeerPort();
        String transport = this.getTransport();
        IOExceptionEvent exceptionEvent = new IOExceptionEvent(this, host, port, transport);
        this.getSipProvider().handleEvent(exceptionEvent, this);
    }

    @Override
    public boolean acquireSem() {
        boolean retval = false;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("acquireSem [[[[" + this);
            logger.logStackTrace();
        }
        retval = this.sipStack.maxListenerResponseTime == -1 ? this.semaphore.acquire() : this.semaphore.tryAcquire();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("acquireSem() returning : " + retval);
        }
        return retval;
    }

    @Override
    public void releaseSem() {
        try {
            this.toListener = false;
            this.semRelease();
        }
        catch (Exception ex) {
            logger.logError("Unexpected exception releasing sem", ex);
        }
    }

    @Override
    public void semRelease() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("semRelease ]]]]" + this);
            logger.logStackTrace();
        }
        this.semaphore.release();
    }

    @Override
    public boolean passToListener() {
        return this.toListener;
    }

    @Override
    public void setPassToListener() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setPassToListener()");
        }
        this.toListener = true;
    }

    @Override
    public synchronized boolean testAndSetTransactionTerminatedEvent() {
        boolean retval = !this.terminatedEventDelivered;
        this.terminatedEventDelivered = true;
        return retval;
    }

    @Override
    public String getCipherSuite() throws UnsupportedOperationException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getCipherSuite();
        }
        if (this.getMessageChannel() instanceof NioTlsMessageChannel) {
            if (((NioTlsMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            return ((NioTlsMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getCipherSuite();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public Certificate[] getLocalCertificates() throws UnsupportedOperationException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getLocalCertificates();
        }
        if (this.getMessageChannel() instanceof NioTlsMessageChannel) {
            if (((NioTlsMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            return ((NioTlsMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getLocalCertificates();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.getMessageChannel() instanceof TLSMessageChannel) {
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            if (((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent() == null) {
                return null;
            }
            return ((TLSMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getHandshakeCompletedEvent().getPeerCertificates();
        }
        if (this.getMessageChannel() instanceof NioTlsMessageChannel) {
            if (((NioTlsMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener() == null) {
                return null;
            }
            return ((NioTlsMessageChannel)this.getMessageChannel()).getHandshakeCompletedListener().getPeerCertificates();
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public List<String> extractCertIdentities() throws SSLPeerUnverifiedException {
        if (this.getMessageChannel() instanceof TLSMessageChannel || this.getMessageChannel() instanceof NioTlsMessageChannel) {
            ArrayList<String> certIdentities = new ArrayList<String>();
            Certificate[] certs = this.getPeerCertificates();
            if (certs == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("No certificates available");
                }
                return certIdentities;
            }
            for (Certificate cert : certs) {
                Collection<List<?>> subjAltNames;
                X509Certificate x509cert;
                block17: {
                    x509cert = (X509Certificate)cert;
                    subjAltNames = null;
                    try {
                        subjAltNames = x509cert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException ex) {
                        if (!logger.isLoggingEnabled()) break block17;
                        logger.logError("Error parsing TLS certificate", ex);
                    }
                }
                Integer dnsNameType = 2;
                Integer uriNameType = 6;
                if (subjAltNames != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("found subjAltNames: " + subjAltNames);
                    }
                    for (List<?> altName : subjAltNames) {
                        if (!altName.get(0).equals(uriNameType)) continue;
                        try {
                            SipURI altNameUri = new AddressFactoryImpl().createSipURI((String)altName.get(1));
                            if (!"sip".equals(altNameUri.getScheme()) || altNameUri.getUser() != null) continue;
                            String altHostName = altNameUri.getHost();
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("found uri " + altName.get(1) + ", hostName " + altHostName);
                            }
                            certIdentities.add(altHostName);
                        }
                        catch (ParseException e) {
                            if (!logger.isLoggingEnabled()) continue;
                            logger.logError("certificate contains invalid uri: " + altName.get(1));
                        }
                    }
                    if (!certIdentities.isEmpty()) continue;
                    for (List<?> altName : subjAltNames) {
                        if (!altName.get(0).equals(dnsNameType)) continue;
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("found dns " + altName.get(1));
                        }
                        certIdentities.add(altName.get(1).toString());
                    }
                    continue;
                }
                String dname = x509cert.getSubjectDN().getName();
                String cname = "";
                try {
                    Matcher matcher = EXTRACT_CN.matcher(dname);
                    if (!matcher.matches()) continue;
                    cname = matcher.group(1);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("found CN: " + cname + " from DN: " + dname);
                    }
                    certIdentities.add(cname);
                }
                catch (Exception ex) {
                    if (!logger.isLoggingEnabled()) continue;
                    logger.logError("exception while extracting CN", ex);
                }
            }
            return certIdentities;
        }
        throw new UnsupportedOperationException("Not a TLS channel");
    }

    @Override
    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    @Override
    public ReleaseReferencesStrategy getReleaseReferencesStrategy() {
        return this.releaseReferencesStrategy;
    }

    @Override
    public void setReleaseReferencesStrategy(ReleaseReferencesStrategy releaseReferencesStrategy) {
        this.releaseReferencesStrategy = releaseReferencesStrategy;
    }

    @Override
    public int getTimerD() {
        return this.timerD;
    }

    @Override
    public int getTimerT2() {
        return this.T2;
    }

    @Override
    public int getTimerT4() {
        return this.T4;
    }

    @Override
    public void setTimerD(int interval) {
        if (interval < 32000) {
            throw new IllegalArgumentException("To be RFC 3261 compliant, the value of Timer D should be at least 32s");
        }
        this.timerD = interval / this.baseTimerInterval;
    }

    @Override
    public void setTimerT2(int interval) {
        this.T2 = interval / this.baseTimerInterval;
    }

    @Override
    public void setTimerT4(int interval) {
        this.timerI = this.T4 = interval / this.baseTimerInterval;
        this.timerK = this.T4;
    }

    @Override
    public int getBaseTimerInterval() {
        return this.baseTimerInterval;
    }

    @Override
    public int getT4() {
        return this.T4;
    }

    @Override
    public int getT2() {
        return this.T2;
    }

    @Override
    public int getTimerI() {
        return this.timerI;
    }

    @Override
    public int getTimerK() {
        return this.timerK;
    }

    @Override
    public void setForkId(String forkId) {
        this.forkId = forkId;
    }

    @Override
    public String getForkId() {
        return this.forkId;
    }

    @Override
    public void scheduleMaxTxLifeTimeTimer() {
        if (this.maxTxLifeTimeListener == null && this.getMethod().equalsIgnoreCase("INVITE") && this.sipStack.getMaxTxLifetimeInvite() > 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Scheduling MaxTxLifeTimeListener for tx " + this + " , tx id " + this.getTransactionId() + " , state " + this.getState());
            }
            this.maxTxLifeTimeListener = new MaxTxLifeTimeListener();
            this.sipStack.getTimer().schedule(this.maxTxLifeTimeListener, this.sipStack.getMaxTxLifetimeInvite() * 1000);
        }
        if (this.maxTxLifeTimeListener == null && !this.getMethod().equalsIgnoreCase("INVITE") && this.sipStack.getMaxTxLifetimeNonInvite() > 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Scheduling MaxTxLifeTimeListener for tx " + this + " , tx id " + this.getTransactionId() + " , state " + this.getState());
            }
            this.maxTxLifeTimeListener = new MaxTxLifeTimeListener();
            this.sipStack.getTimer().schedule(this.maxTxLifeTimeListener, this.sipStack.getMaxTxLifetimeNonInvite() * 1000);
        }
    }

    @Override
    public void cancelMaxTxLifeTimeTimer() {
        if (this.maxTxLifeTimeListener != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Cancelling MaxTxLifeTimeListener for tx " + this + " , tx id " + this.getTransactionId() + " , state " + this.getState());
            }
            this.sipStack.getTimer().cancel(this.maxTxLifeTimeListener);
            this.maxTxLifeTimeListener = null;
        }
    }

    @Override
    public String getMergeId() {
        if (this.mergeId == null) {
            return ((SIPRequest)this.getRequest()).getMergeId();
        }
        return this.mergeId;
    }

    @Override
    public long getAuditTag() {
        return this.auditTag;
    }

    @Override
    public void setAuditTag(long auditTag) {
        this.auditTag = auditTag;
    }

    @Override
    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    @Override
    public void setTransactionMapped(boolean transactionMapped) {
        this.isMapped = transactionMapped;
    }

    @Override
    public void setCollectionTime(int collectionTime) {
        this.collectionTime = collectionTime;
    }

    class MaxTxLifeTimeListener
    extends SIPStackTimerTask {
        SIPTransaction sipTransaction;

        MaxTxLifeTimeListener() {
            this.sipTransaction = SIPTransactionImpl.this;
        }

        @Override
        public void runTask() {
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Fired MaxTxLifeTimeListener for tx " + this.sipTransaction + " , tx id " + this.sipTransaction.getTransactionId() + " , state " + this.sipTransaction.getState());
                }
                SIPTransactionImpl.this.raiseErrorEvent(1);
                LingerTimer myTimer = new LingerTimer();
                if (SIPTransactionImpl.this.sipStack.getConnectionLingerTimer() != 0) {
                    SIPTransactionImpl.this.sipStack.getTimer().schedule(myTimer, SIPTransactionImpl.this.sipStack.getConnectionLingerTimer() * 1000);
                } else {
                    ((SIPStackTimerTask)myTimer).runTask();
                }
                SIPTransactionImpl.this.maxTxLifeTimeListener = null;
            }
            catch (Exception ex) {
                logger.logError("unexpected exception", ex);
            }
        }

        @Override
        public Object getThreadHash() {
            Request request = SIPTransactionImpl.this.getRequest();
            if (request != null && request instanceof SIPRequest) {
                return ((SIPRequest)request).getCallIdHeader().getCallId();
            }
            return null;
        }
    }

    class LingerTimer
    extends SIPStackTimerTask {
        public LingerTimer() {
            if (logger.isLoggingEnabled(32)) {
                SIPTransactionImpl sipTransaction = SIPTransactionImpl.this;
                logger.logDebug("LingerTimer : " + sipTransaction.getTransactionId());
            }
        }

        @Override
        public void runTask() {
            SIPTransactionImpl.this.cleanUp();
        }

        @Override
        public Object getThreadHash() {
            Request request = SIPTransactionImpl.this.getRequest();
            if (request != null && request instanceof SIPRequest) {
                return ((SIPRequest)request).getCallIdHeader().getCallId();
            }
            return null;
        }
    }

    class TransactionSemaphore {
        private static final long serialVersionUID = -1634100711669020804L;
        Semaphore sem = null;
        ReentrantLock lock = null;

        public TransactionSemaphore() {
            if (((SipStackImpl)SIPTransactionImpl.this.sipStack).isReEntrantListener()) {
                this.lock = new ReentrantLock();
            } else {
                this.sem = new Semaphore(1, true);
            }
        }

        public boolean acquire() {
            try {
                if (((SipStackImpl)SIPTransactionImpl.this.sipStack).isReEntrantListener()) {
                    this.lock.lock();
                } else {
                    this.sem.acquire();
                }
                return true;
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception acquiring sem", ex);
                InternalErrorHandler.handleException(ex);
                return false;
            }
        }

        public boolean tryAcquire() {
            try {
                if (((SipStackImpl)SIPTransactionImpl.this.sipStack).isReEntrantListener()) {
                    return this.lock.tryLock(SIPTransactionImpl.this.sipStack.maxListenerResponseTime, TimeUnit.SECONDS);
                }
                return this.sem.tryAcquire(SIPTransactionImpl.this.sipStack.maxListenerResponseTime, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception trying acquiring sem", ex);
                InternalErrorHandler.handleException(ex);
                return false;
            }
        }

        public void release() {
            try {
                if (((SipStackImpl)SIPTransactionImpl.this.sipStack).isReEntrantListener()) {
                    if (this.lock.isHeldByCurrentThread()) {
                        this.lock.unlock();
                    }
                } else {
                    this.sem.release();
                }
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception releasing sem", ex);
            }
        }
    }
}

