/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl.syncRequest;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncRequest.SyncRequestValue;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class SyncRequestValueImpl
extends AbstractControl
implements SyncRequestValue {
    private SynchronizationModeEnum mode;
    private byte[] cookie;
    private boolean isReloadHint;

    public SyncRequestValueImpl() {
        super("1.3.6.1.4.1.4203.1.9.1.1");
    }

    public SyncRequestValueImpl(boolean isCritical) {
        super("1.3.6.1.4.1.4203.1.9.1.1", isCritical);
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    @Override
    public SynchronizationModeEnum getMode() {
        return this.mode;
    }

    @Override
    public void setMode(SynchronizationModeEnum mode) {
        this.mode = mode;
    }

    @Override
    public boolean isReloadHint() {
        return this.isReloadHint;
    }

    @Override
    public void setReloadHint(boolean reloadHint) {
        this.isReloadHint = reloadHint;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 17 + (this.isReloadHint ? 1 : 0);
        h = h * 17 + this.mode.getValue();
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncRequestValue)) {
            return false;
        }
        SyncRequestValue otherControl = (SyncRequestValue)o;
        return super.equals(o) && this.mode == otherControl.getMode() && this.isReloadHint == otherControl.isReloadHint() && Arrays.equals(this.cookie, otherControl.getCookie());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncRequestValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        mode              : '").append((Object)this.getMode()).append("'\n");
        sb.append("        cookie            : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        sb.append("        reloadHint : '").append(this.isReloadHint()).append("'\n");
        return sb.toString();
    }
}

