/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.search;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.search.Filter;

public abstract class ConnectorFilter
extends Filter {
    protected List<Filter> filterSet;
    protected int filtersLength;

    public ConnectorFilter(int tlvId) {
        super(tlvId);
    }

    public ConnectorFilter() {
    }

    public void addFilter(Filter filter) throws DecoderException {
        if (this.filterSet == null) {
            this.filterSet = new ArrayList<Filter>();
        }
        this.filterSet.add(filter);
    }

    public List<Filter> getFilterSet() {
        return this.filterSet;
    }

    @Override
    public int computeLength() {
        int connectorFilterLength = 0;
        if (this.filterSet != null && !this.filterSet.isEmpty()) {
            for (Filter filter : this.filterSet) {
                connectorFilterLength += filter.computeLength();
            }
        }
        return connectorFilterLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        if (this.filterSet != null && !this.filterSet.isEmpty()) {
            for (Filter filter : this.filterSet) {
                filter.encode(buffer);
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.filterSet != null && !this.filterSet.isEmpty()) {
            for (Filter filter : this.filterSet) {
                sb.append('(').append(filter).append(')');
            }
        }
        return sb.toString();
    }
}

