/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.LinedData;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.CanvasTextRenderer, JqPlotResources.CategoryAxisRenderer})
public class LineChart<T extends Number>
extends AbstractChart<LinedData<T>, String> {
    private static final long serialVersionUID = -643105267124184518L;
    private final ChartConfiguration<String> chartConfig;
    private LinedData<T> linedData = new LinedData();

    public LineChart() {
        this(null, null, null);
    }

    public LineChart(String title) {
        this(title, null, null);
    }

    public LineChart(String title, String labelX, String labelY) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).setLabelX(labelX).setLabelY(labelY).axesDefaultsInstance().setLabelRenderer(JqPlotResources.CanvasAxisLabelRenderer);
        this.chartConfig.axesInstance().xAxisInstance().setPad(Float.valueOf(0.0f));
    }

    public void addValue(T value) {
        this.linedData.addValue(value);
    }

    public void addValues(T ... values) {
        this.linedData.addValues(values);
    }

    @Override
    public LinedData<T> getChartData() {
        return this.linedData;
    }

    @Override
    public ChartConfiguration<String> getChartConfiguration() {
        return this.chartConfig;
    }
}

